/*
 * Decompiled with CFR 0.152.
 */
package org.pushingpixels.trident.internal.swing;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Point;
import java.awt.Rectangle;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import org.pushingpixels.trident.api.interpolator.PropertyInterpolator;
import org.pushingpixels.trident.api.interpolator.PropertyInterpolatorSource;

public class AWTPropertyInterpolators
implements PropertyInterpolatorSource {
    private Set<PropertyInterpolator<?>> interpolators = new HashSet();

    public AWTPropertyInterpolators() {
        this.interpolators.add(new ColorInterpolator());
        this.interpolators.add(new PointInterpolator());
        this.interpolators.add(new RectangleInterpolator());
        this.interpolators.add(new DimensionInterpolator());
    }

    @Override
    public Set<PropertyInterpolator<?>> getPropertyInterpolators() {
        return Collections.unmodifiableSet(this.interpolators);
    }

    static class DimensionInterpolator
    implements PropertyInterpolator<Dimension> {
        DimensionInterpolator() {
        }

        @Override
        public Dimension interpolate(Dimension from, Dimension to, float timelinePosition) {
            int w2 = from.width + (int)(timelinePosition * (float)(to.width - from.width));
            int h2 = from.height + (int)(timelinePosition * (float)(to.height - from.height));
            return new Dimension(w2, h2);
        }

        @Override
        public Class<Dimension> getBasePropertyClass() {
            return Dimension.class;
        }
    }

    static class RectangleInterpolator
    implements PropertyInterpolator<Rectangle> {
        RectangleInterpolator() {
        }

        @Override
        public Rectangle interpolate(Rectangle from, Rectangle to, float timelinePosition) {
            int x2 = from.x + (int)(timelinePosition * (float)(to.x - from.x));
            int y2 = from.y + (int)(timelinePosition * (float)(to.y - from.y));
            int w2 = from.width + (int)(timelinePosition * (float)(to.width - from.width));
            int h2 = from.height + (int)(timelinePosition * (float)(to.height - from.height));
            return new Rectangle(x2, y2, w2, h2);
        }

        @Override
        public Class<Rectangle> getBasePropertyClass() {
            return Rectangle.class;
        }
    }

    static class PointInterpolator
    implements PropertyInterpolator<Point> {
        PointInterpolator() {
        }

        @Override
        public Point interpolate(Point from, Point to, float timelinePosition) {
            int x2 = from.x + (int)(timelinePosition * (float)(to.x - from.x));
            int y2 = from.y + (int)(timelinePosition * (float)(to.y - from.y));
            return new Point(x2, y2);
        }

        @Override
        public Class<Point> getBasePropertyClass() {
            return Point.class;
        }
    }

    static class ColorInterpolator
    implements PropertyInterpolator<Color> {
        ColorInterpolator() {
        }

        @Override
        public Class<Color> getBasePropertyClass() {
            return Color.class;
        }

        @Override
        public Color interpolate(Color from, Color to, float timelinePosition) {
            return this.getInterpolatedColor(from, to, 1.0f - timelinePosition);
        }

        int getInterpolatedRGB(Color color1, Color color2, float color1Likeness) {
            if ((double)color1Likeness < 0.0 || (double)color1Likeness > 1.0) {
                throw new IllegalArgumentException("Color likeness should be in 0.0-1.0 range [is " + color1Likeness + "]");
            }
            int alpha1 = color1.getAlpha();
            int alpha2 = color2.getAlpha();
            int r2 = ColorInterpolator.getInterpolatedChannelValue(color1.getRed(), color2.getRed(), color1Likeness);
            int g2 = ColorInterpolator.getInterpolatedChannelValue(color1.getGreen(), color2.getGreen(), color1Likeness);
            int b2 = ColorInterpolator.getInterpolatedChannelValue(color1.getBlue(), color2.getBlue(), color1Likeness);
            int a2 = alpha1 == alpha2 ? alpha1 : (int)Math.round((double)(color1Likeness * (float)alpha1) + (1.0 - (double)color1Likeness) * (double)alpha2);
            return a2 << 24 | r2 << 16 | g2 << 8 | b2;
        }

        private static int getInterpolatedChannelValue(int value1, int value2, double value1Likeness) {
            double optical2;
            if (value1 == value2) {
                return value1;
            }
            if (value1Likeness == 1.0) {
                return value1;
            }
            if (value1Likeness == 0.0) {
                return value2;
            }
            double optical1 = ColorInterpolator.EOCF_sRGB((float)value1 / 255.0f);
            double interpolatedOptical = value1Likeness * optical1 + (1.0 - value1Likeness) * (optical2 = ColorInterpolator.EOCF_sRGB((float)value2 / 255.0f));
            double interpolatedElectro = ColorInterpolator.OECF_sRGB(interpolatedOptical);
            int result = (int)Math.round(interpolatedElectro * 255.0);
            if (result < 0) {
                result = 0;
            }
            if (result > 255) {
                result = 255;
            }
            return result;
        }

        private static double OECF_sRGB(double linear) {
            return linear <= (double)0.0031308f ? linear * (double)12.92f : Math.pow(linear, 0.4166666567325592) * (double)1.055f - (double)0.055f;
        }

        private static double EOCF_sRGB(double srgb) {
            return srgb <= (double)0.04045f ? srgb / (double)12.92f : Math.pow((srgb + (double)0.055f) / (double)1.055f, 2.4f);
        }

        Color getInterpolatedColor(Color color1, Color color2, float color1Likeness) {
            if (color1.equals(color2)) {
                return color1;
            }
            if ((double)color1Likeness == 1.0) {
                return color1;
            }
            if ((double)color1Likeness == 0.0) {
                return color2;
            }
            return new Color(this.getInterpolatedRGB(color1, color2, color1Likeness), true);
        }
    }
}

