/*
 * Decompiled with CFR 0.152.
 */
package org.pushingpixels.trident.api.interpolator;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.pushingpixels.trident.api.TridentCortex;
import org.pushingpixels.trident.api.interpolator.PropertyInterpolator;

public class KeyValues<T> {
    private final List<T> values = new ArrayList<T>();
    private final PropertyInterpolator<T> interpolator;
    private final Class<?> type;
    private T startValue;

    @SafeVarargs
    public static <T> KeyValues<T> create(T ... params) {
        return new KeyValues<T>(params);
    }

    public static <T> KeyValues<T> create(PropertyInterpolator<T> interpolator, T[] params) {
        return new KeyValues<T>(interpolator, params);
    }

    private KeyValues(T[] params) {
        this(TridentCortex.getPropertyInterpolator(Arrays.asList(params)), params);
    }

    private KeyValues(PropertyInterpolator<T> interpolator, T[] params) {
        if (params == null) {
            throw new IllegalArgumentException("params array cannot be null");
        }
        if (params.length == 0) {
            throw new IllegalArgumentException("params array must have at least one element");
        }
        if (params.length == 1) {
            this.values.add(null);
        }
        Collections.addAll(this.values, params);
        this.type = params.getClass().getComponentType();
        this.interpolator = interpolator;
    }

    int getSize() {
        return this.values.size();
    }

    Class<?> getType() {
        return this.type;
    }

    void setStartValue(T startValue) {
        if (this.isToAnimation()) {
            this.startValue = startValue;
        }
    }

    private boolean isToAnimation() {
        return this.values.get(0) == null;
    }

    T getValue(int i0, int i1, float fraction) {
        T value;
        T lowerValue = this.values.get(i0);
        if (lowerValue == null) {
            lowerValue = this.startValue;
        }
        if (i0 == i1) {
            value = lowerValue;
        } else {
            T v0 = lowerValue;
            T v1 = this.values.get(i1);
            value = this.interpolator.interpolate(v0, v1, fraction);
        }
        return value;
    }
}

