/*
 * Decompiled with CFR 0.152.
 */
package org.pushingpixels.trident.api;

import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.LinkedBlockingQueue;
import org.pushingpixels.trident.api.Timeline;
import org.pushingpixels.trident.api.TimelineScenario;
import org.pushingpixels.trident.api.TridentCortex;
import org.pushingpixels.trident.api.swing.RunOnEventDispatchThread;
import org.pushingpixels.trident.internal.swing.SwingUtils;

class TimelineEngine {
    public static boolean DEBUG_MODE = false;
    private static TimelineEngine instance;
    private Set<Timeline> runningTimelines = new HashSet<Timeline>();
    private Set<TimelineScenario> runningScenarios = new HashSet<TimelineScenario>();
    long lastIterationTimeStamp;
    TridentAnimationThread animatorThread;
    private BlockingQueue<Runnable> callbackQueue = new LinkedBlockingQueue<Runnable>();
    private TimelineCallbackThread callbackThread = this.getCallbackThread();
    static final Object LOCK;

    private TimelineEngine() {
    }

    public static synchronized TimelineEngine getInstance() {
        if (instance == null) {
            instance = new TimelineEngine();
        }
        return instance;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void updateTimelines() {
        Object object = LOCK;
        synchronized (object) {
            if (this.runningTimelines.size() == 0 && this.runningScenarios.size() == 0) {
                this.lastIterationTimeStamp = System.currentTimeMillis();
                return;
            }
            long passedSinceLastIteration = System.currentTimeMillis() - this.lastIterationTimeStamp;
            if (passedSinceLastIteration < 0L) {
                passedSinceLastIteration = 0L;
            }
            if (DEBUG_MODE) {
                System.out.println("Elapsed since last iteration: " + passedSinceLastIteration + "ms");
            }
            Iterator<Timeline> itTimeline = this.runningTimelines.iterator();
            while (itTimeline.hasNext()) {
                Timeline timeline = itTimeline.next();
                if (timeline.getState() == Timeline.TimelineState.SUSPENDED) continue;
                boolean timelineWasInReadyState = false;
                if (timeline.getState() == Timeline.TimelineState.READY) {
                    if (timeline.timeUntilPlay - passedSinceLastIteration > 0L) {
                        timeline.timeUntilPlay -= passedSinceLastIteration;
                        continue;
                    }
                    timelineWasInReadyState = true;
                    timeline.popState();
                    if (DEBUG_MODE) {
                        System.out.println("Moving " + timeline.id + " to READY");
                    }
                    this.callbackCallTimelineStateChanged(timeline, Timeline.TimelineState.READY);
                }
                boolean hasEnded = false;
                if (DEBUG_MODE) {
                    System.out.println("Processing " + timeline.id + "[" + timeline.getMainObject().getClass().getSimpleName() + "] from " + timeline.durationFraction + ". Callback - " + (timeline.callbackChain == null ? "no" : "yes"));
                }
                switch (timeline.getState()) {
                    case PLAYING_FORWARD: {
                        int loopsToLive;
                        if (!timelineWasInReadyState) {
                            timeline.durationFraction += (float)passedSinceLastIteration / (float)timeline.getDuration();
                        }
                        this.updateAndEnforceTimelinePosition(timeline);
                        if (DEBUG_MODE) {
                            System.out.println("Timeline " + timeline.id + " position: " + (long)(timeline.durationFraction * (float)timeline.getDuration()) + "/" + timeline.getDuration() + " = " + timeline.durationFraction);
                        }
                        if (!(timeline.durationFraction > 1.0f)) break;
                        timeline.durationFraction = 1.0f;
                        this.updateAndEnforceTimelinePosition(timeline);
                        if (timeline.isLooping) {
                            boolean stopLoopingAnimation = timeline.toCancelAtCycleBreak;
                            loopsToLive = timeline.repeatCount;
                            if (loopsToLive > 0) {
                                stopLoopingAnimation = stopLoopingAnimation || --loopsToLive == 0;
                                timeline.repeatCount = loopsToLive;
                            }
                            if (stopLoopingAnimation) {
                                hasEnded = true;
                                itTimeline.remove();
                                break;
                            }
                            if (timeline.getRepeatBehavior() == Timeline.RepeatBehavior.REVERSE) {
                                timeline.replaceState(Timeline.TimelineState.PLAYING_REVERSE);
                                if (timeline.getCycleDelay() > 0L) {
                                    timeline.pushState(Timeline.TimelineState.READY);
                                    timeline.timeUntilPlay = timeline.getCycleDelay();
                                }
                                this.callbackCallTimelineStateChanged(timeline, Timeline.TimelineState.PLAYING_FORWARD);
                                break;
                            }
                            timeline.durationFraction = 0.0f;
                            this.updateAndEnforceTimelinePosition(timeline);
                            if (timeline.getCycleDelay() > 0L) {
                                timeline.pushState(Timeline.TimelineState.READY);
                                timeline.timeUntilPlay = timeline.getCycleDelay();
                                this.callbackCallTimelineStateChanged(timeline, Timeline.TimelineState.PLAYING_FORWARD);
                                break;
                            }
                            this.callbackCallTimelineStateChanged(timeline, Timeline.TimelineState.PLAYING_FORWARD);
                            break;
                        }
                        hasEnded = true;
                        itTimeline.remove();
                        break;
                    }
                    case PLAYING_REVERSE: {
                        int loopsToLive;
                        if (!timelineWasInReadyState) {
                            timeline.durationFraction -= (float)passedSinceLastIteration / (float)timeline.getDuration();
                        }
                        this.updateAndEnforceTimelinePosition(timeline);
                        if (DEBUG_MODE) {
                            System.out.println("Timeline position: " + (long)(timeline.durationFraction * (float)timeline.getDuration()) + "/" + timeline.getDuration() + " = " + timeline.durationFraction);
                        }
                        if (!(timeline.durationFraction < 0.0f)) break;
                        timeline.durationFraction = 0.0f;
                        this.updateAndEnforceTimelinePosition(timeline);
                        if (timeline.isLooping) {
                            boolean stopLoopingAnimation = timeline.toCancelAtCycleBreak;
                            loopsToLive = timeline.repeatCount;
                            if (loopsToLive > 0) {
                                stopLoopingAnimation = stopLoopingAnimation || --loopsToLive == 0;
                                timeline.repeatCount = loopsToLive;
                            }
                            if (stopLoopingAnimation) {
                                hasEnded = true;
                                itTimeline.remove();
                                break;
                            }
                            timeline.replaceState(Timeline.TimelineState.PLAYING_FORWARD);
                            if (timeline.getCycleDelay() > 0L) {
                                timeline.pushState(Timeline.TimelineState.READY);
                                timeline.timeUntilPlay = timeline.getCycleDelay();
                            }
                            this.callbackCallTimelineStateChanged(timeline, Timeline.TimelineState.PLAYING_REVERSE);
                            break;
                        }
                        hasEnded = true;
                        itTimeline.remove();
                        break;
                    }
                    default: {
                        throw new IllegalStateException("Timeline cannot be in " + (Object)((Object)timeline.getState()) + " state");
                    }
                }
                if (hasEnded) {
                    if (DEBUG_MODE) {
                        System.out.println("Ending " + timeline.id + " on  in state " + timeline.getState().name() + " at position " + timeline.durationFraction);
                    }
                    Timeline.TimelineState oldState = timeline.getState();
                    timeline.replaceState(Timeline.TimelineState.DONE);
                    this.callbackCallTimelineStateChanged(timeline, oldState);
                    timeline.popState();
                    if (timeline.getState() != Timeline.TimelineState.IDLE) {
                        throw new IllegalStateException("Timeline should be IDLE at this point");
                    }
                    this.callbackCallTimelineStateChanged(timeline, Timeline.TimelineState.DONE);
                    continue;
                }
                if (DEBUG_MODE) {
                    System.out.println("Calling " + timeline.id + " on " + timeline.durationFraction);
                }
                this.callbackCallTimelinePulse(timeline);
            }
            if (this.runningScenarios.size() > 0) {
                Iterator<TimelineScenario> it = this.runningScenarios.iterator();
                while (it.hasNext()) {
                    TimelineScenario scenario = it.next();
                    if (scenario.state == TimelineScenario.TimelineScenarioState.DONE) {
                        it.remove();
                        this.callbackCallTimelineScenarioEnded(scenario);
                        continue;
                    }
                    Set<TimelineScenario.TimelineScenarioActor> readyActors = scenario.getReadyActors();
                    if (readyActors == null) continue;
                    for (TimelineScenario.TimelineScenarioActor readyActor : readyActors) {
                        readyActor.play();
                    }
                }
            }
            this.lastIterationTimeStamp = System.currentTimeMillis();
        }
    }

    private void callbackCallTimelineStateChanged(Timeline timeline, Timeline.TimelineState oldState) {
        Timeline.TimelineState newState = timeline.getState();
        float durationFraction = timeline.durationFraction;
        float timelinePosition = timeline.timelinePosition;
        Runnable callbackRunnable = () -> {
            boolean shouldRunOnUIThread = false;
            for (Class<?> clazz = timeline.callbackChain.getClass(); clazz != null && !shouldRunOnUIThread; clazz = clazz.getSuperclass()) {
                shouldRunOnUIThread = clazz.isAnnotationPresent(RunOnEventDispatchThread.class);
            }
            if (shouldRunOnUIThread && SwingUtils.isUiComponent(timeline.getMainObject())) {
                if (DEBUG_MODE) {
                    System.out.println("Scheduling callback state change from " + oldState.name() + " to " + newState.name() + " on timeline " + timeline.id);
                }
                SwingUtils.runOnEventDispatchThread(() -> timeline.callbackChain.onTimelineStateChanged(oldState, newState, durationFraction, timelinePosition));
            } else {
                if (DEBUG_MODE) {
                    System.out.println("Calling callback state change from " + oldState.name() + " to " + newState.name() + " on timeline " + timeline.id);
                }
                timeline.callbackChain.onTimelineStateChanged(oldState, newState, durationFraction, timelinePosition);
            }
        };
        if (DEBUG_MODE) {
            System.out.println("Scheduling callback runnable for " + oldState.name() + " to " + newState.name() + " on timeline " + timeline.id);
        }
        this.callbackQueue.add(callbackRunnable);
    }

    private void callbackCallTimelinePulse(Timeline timeline) {
        float durationFraction = timeline.durationFraction;
        float timelinePosition = timeline.timelinePosition;
        Runnable callbackRunnable = () -> {
            boolean shouldRunOnUIThread = false;
            for (Class<?> clazz = timeline.callbackChain.getClass(); clazz != null && !shouldRunOnUIThread; clazz = clazz.getSuperclass()) {
                shouldRunOnUIThread = clazz.isAnnotationPresent(RunOnEventDispatchThread.class);
            }
            if (shouldRunOnUIThread && SwingUtils.isUiComponent(timeline.getMainObject())) {
                SwingUtils.runOnEventDispatchThread(() -> timeline.callbackChain.onTimelinePulse(durationFraction, timelinePosition));
            } else {
                timeline.callbackChain.onTimelinePulse(durationFraction, timelinePosition);
            }
        };
        this.callbackQueue.add(callbackRunnable);
    }

    private void callbackCallTimelineScenarioEnded(TimelineScenario timelineScenario) {
        Runnable callbackRunnable = () -> timelineScenario.callback.onTimelineScenarioDone();
        this.callbackQueue.offer(callbackRunnable);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Timeline getRunningTimeline(Timeline timeline) {
        Object object = LOCK;
        synchronized (object) {
            if (this.runningTimelines.contains(timeline)) {
                return timeline;
            }
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void addTimeline(Timeline timeline) {
        Object object = LOCK;
        synchronized (object) {
            FullObjectID cid;
            timeline.fullObjectID = cid = new FullObjectID(timeline.getMainObject(), timeline.getSecondaryId());
            this.runningTimelines.add(timeline);
            if (DEBUG_MODE) {
                System.out.println("Added (" + timeline.id + ") on [" + timeline.fullObjectID + "]. State - " + timeline.getState().name() + ". Callback - " + (timeline.callbackChain == null ? "no" : "yes"));
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void play(Timeline timeline, boolean reset, long msToSkip) {
        Object object = LOCK;
        synchronized (object) {
            this.getAnimatorThread();
            Timeline existing = this.getRunningTimeline(timeline);
            if (existing == null) {
                Timeline.TimelineState oldState = timeline.getState();
                timeline.timeUntilPlay = timeline.getInitialDelay() - msToSkip;
                if (timeline.timeUntilPlay < 0L) {
                    timeline.durationFraction = (float)(-timeline.timeUntilPlay) / (float)timeline.getDuration();
                    this.updateAndEnforceTimelinePosition(timeline);
                    timeline.timeUntilPlay = 0L;
                } else {
                    timeline.durationFraction = 0.0f;
                    this.updateAndEnforceTimelinePosition(timeline);
                }
                timeline.pushState(Timeline.TimelineState.PLAYING_FORWARD);
                timeline.pushState(Timeline.TimelineState.READY);
                this.addTimeline(timeline);
                this.callbackCallTimelineStateChanged(timeline, oldState);
            } else {
                Timeline.TimelineState oldState = existing.getState();
                if (oldState == Timeline.TimelineState.READY) {
                    existing.popState();
                    existing.replaceState(Timeline.TimelineState.PLAYING_FORWARD);
                    existing.pushState(Timeline.TimelineState.READY);
                } else {
                    existing.replaceState(Timeline.TimelineState.PLAYING_FORWARD);
                    if (oldState != existing.getState()) {
                        this.callbackCallTimelineStateChanged(timeline, oldState);
                    }
                }
                if (reset) {
                    existing.durationFraction = 0.0f;
                    this.updateAndEnforceTimelinePosition(existing);
                    this.callbackCallTimelinePulse(existing);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void playScenario(TimelineScenario scenario) {
        Object object = LOCK;
        synchronized (object) {
            this.getAnimatorThread();
            Set<TimelineScenario.TimelineScenarioActor> readyActors = scenario.getReadyActors();
            this.runningScenarios.add(scenario);
            for (TimelineScenario.TimelineScenarioActor readyActor : readyActors) {
                readyActor.play();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void playReverse(Timeline timeline, boolean reset, long msToSkip) {
        Object object = LOCK;
        synchronized (object) {
            this.getAnimatorThread();
            if (timeline.isLooping) {
                throw new IllegalArgumentException("Timeline must not be marked as looping");
            }
            Timeline existing = this.getRunningTimeline(timeline);
            if (existing == null) {
                Timeline.TimelineState oldState = timeline.getState();
                timeline.timeUntilPlay = timeline.getInitialDelay() - msToSkip;
                if (timeline.timeUntilPlay < 0L) {
                    timeline.durationFraction = 1.0f - (float)(-timeline.timeUntilPlay) / (float)timeline.getDuration();
                    this.updateAndEnforceTimelinePosition(timeline);
                    timeline.timeUntilPlay = 0L;
                } else {
                    timeline.durationFraction = 1.0f;
                    this.updateAndEnforceTimelinePosition(timeline);
                }
                timeline.pushState(Timeline.TimelineState.PLAYING_REVERSE);
                timeline.pushState(Timeline.TimelineState.READY);
                this.addTimeline(timeline);
                this.callbackCallTimelineStateChanged(timeline, oldState);
            } else {
                Timeline.TimelineState oldState = existing.getState();
                if (oldState == Timeline.TimelineState.READY) {
                    existing.popState();
                    existing.replaceState(Timeline.TimelineState.PLAYING_REVERSE);
                    existing.pushState(Timeline.TimelineState.READY);
                } else {
                    existing.replaceState(Timeline.TimelineState.PLAYING_REVERSE);
                    if (oldState != existing.getState()) {
                        this.callbackCallTimelineStateChanged(timeline, oldState);
                    }
                }
                if (reset) {
                    existing.durationFraction = 1.0f;
                    this.updateAndEnforceTimelinePosition(existing);
                    this.callbackCallTimelinePulse(existing);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void playLoop(Timeline timeline, long msToSkip) {
        Object object = LOCK;
        synchronized (object) {
            this.getAnimatorThread();
            if (!timeline.isLooping) {
                throw new IllegalArgumentException("Timeline must be marked as looping");
            }
            Timeline existing = this.getRunningTimeline(timeline);
            if (existing == null) {
                Timeline.TimelineState oldState = timeline.getState();
                timeline.timeUntilPlay = timeline.getInitialDelay() - msToSkip;
                if (timeline.timeUntilPlay < 0L) {
                    timeline.durationFraction = (float)(-timeline.timeUntilPlay) / (float)timeline.getDuration();
                    this.updateAndEnforceTimelinePosition(timeline);
                    timeline.timeUntilPlay = 0L;
                } else {
                    timeline.durationFraction = 0.0f;
                    this.updateAndEnforceTimelinePosition(timeline);
                }
                timeline.pushState(Timeline.TimelineState.PLAYING_FORWARD);
                timeline.pushState(Timeline.TimelineState.READY);
                timeline.toCancelAtCycleBreak = false;
                this.addTimeline(timeline);
                this.callbackCallTimelineStateChanged(timeline, oldState);
            } else {
                existing.toCancelAtCycleBreak = false;
                existing.repeatCount = timeline.repeatCount;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void cancelAllTimelines() {
        Object object = LOCK;
        synchronized (object) {
            this.getAnimatorThread();
            for (Timeline timeline : this.runningTimelines) {
                Timeline.TimelineState oldState = timeline.getState();
                while (timeline.getState() != Timeline.TimelineState.IDLE) {
                    timeline.popState();
                }
                timeline.pushState(Timeline.TimelineState.CANCELLED);
                this.callbackCallTimelineStateChanged(timeline, oldState);
                timeline.popState();
                this.callbackCallTimelineStateChanged(timeline, Timeline.TimelineState.CANCELLED);
            }
            this.runningTimelines.clear();
            this.runningScenarios.clear();
        }
    }

    private TridentAnimationThread getAnimatorThread() {
        if (this.animatorThread == null) {
            this.animatorThread = new TridentAnimationThread();
            this.animatorThread.start();
        }
        return this.animatorThread;
    }

    private TimelineCallbackThread getCallbackThread() {
        if (this.callbackThread == null) {
            this.callbackThread = new TimelineCallbackThread();
            this.callbackThread.start();
        }
        return this.callbackThread;
    }

    private void cancelTimeline(Timeline timeline) {
        this.getAnimatorThread();
        if (this.runningTimelines.contains(timeline)) {
            this.runningTimelines.remove(timeline);
            Timeline.TimelineState oldState = timeline.getState();
            while (timeline.getState() != Timeline.TimelineState.IDLE) {
                timeline.popState();
            }
            timeline.pushState(Timeline.TimelineState.CANCELLED);
            this.callbackCallTimelineStateChanged(timeline, oldState);
            timeline.popState();
            this.callbackCallTimelineStateChanged(timeline, Timeline.TimelineState.CANCELLED);
        }
    }

    private void endTimeline(Timeline timeline) {
        this.getAnimatorThread();
        if (this.runningTimelines.contains(timeline)) {
            this.runningTimelines.remove(timeline);
            Timeline.TimelineState oldState = timeline.getState();
            float endPosition = timeline.timelinePosition;
            while (timeline.getState() != Timeline.TimelineState.IDLE) {
                Timeline.TimelineState state = timeline.popState();
                if (state == Timeline.TimelineState.PLAYING_FORWARD) {
                    endPosition = 1.0f;
                }
                if (state != Timeline.TimelineState.PLAYING_REVERSE) continue;
                endPosition = 0.0f;
            }
            timeline.durationFraction = endPosition;
            this.updateAndEnforceTimelinePosition(timeline);
            timeline.pushState(Timeline.TimelineState.DONE);
            this.callbackCallTimelineStateChanged(timeline, oldState);
            timeline.popState();
            this.callbackCallTimelineStateChanged(timeline, Timeline.TimelineState.DONE);
        }
    }

    private void abortTimeline(Timeline timeline) {
        this.getAnimatorThread();
        if (this.runningTimelines.contains(timeline)) {
            this.runningTimelines.remove(timeline);
            while (timeline.getState() != Timeline.TimelineState.IDLE) {
                timeline.popState();
            }
        }
    }

    private void suspendTimeline(Timeline timeline) {
        this.getAnimatorThread();
        if (this.runningTimelines.contains(timeline)) {
            Timeline.TimelineState oldState = timeline.getState();
            if (oldState != Timeline.TimelineState.PLAYING_FORWARD && oldState != Timeline.TimelineState.PLAYING_REVERSE && oldState != Timeline.TimelineState.READY) {
                return;
            }
            timeline.pushState(Timeline.TimelineState.SUSPENDED);
            this.callbackCallTimelineStateChanged(timeline, oldState);
        }
    }

    private void resumeTimeline(Timeline timeline) {
        this.getAnimatorThread();
        if (this.runningTimelines.contains(timeline)) {
            Timeline.TimelineState oldState = timeline.getState();
            if (oldState != Timeline.TimelineState.SUSPENDED) {
                return;
            }
            timeline.popState();
            this.callbackCallTimelineStateChanged(timeline, oldState);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void runTimelineOperation(Timeline timeline, TimelineOperationKind operationKind, Runnable operationRunnable) {
        Object object = LOCK;
        synchronized (object) {
            this.getAnimatorThread();
            switch (operationKind) {
                case CANCEL: {
                    this.cancelTimeline(timeline);
                    return;
                }
                case END: {
                    this.endTimeline(timeline);
                    return;
                }
                case RESUME: {
                    this.resumeTimeline(timeline);
                    return;
                }
                case SUSPEND: {
                    this.suspendTimeline(timeline);
                    return;
                }
                case ABORT: {
                    this.abortTimeline(timeline);
                    return;
                }
            }
            operationRunnable.run();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void runTimelineScenario(Runnable timelineScenarioRunnable) {
        Object object = LOCK;
        synchronized (object) {
            this.getAnimatorThread();
            timelineScenarioRunnable.run();
        }
    }

    private void updateAndEnforceTimelinePosition(Timeline timeline) {
        float durationFraction = timeline.durationFraction;
        durationFraction = Math.max(durationFraction, 0.0f);
        durationFraction = Math.min(durationFraction, 1.0f);
        timeline.timelinePosition = timeline.getEase().map(durationFraction);
        float position = timeline.timelinePosition;
        if (position < 0.0f || position > 1.0f) {
            throw new IllegalStateException("Timeline position is " + position + " but should be in the [0.0-1.0] range. Duration fraction is " + timeline.durationFraction + " and the ease function is " + timeline.getEase().getClass().getName());
        }
    }

    static {
        LOCK = new Object();
    }

    private class TimelineCallbackThread
    extends Thread {
        public TimelineCallbackThread() {
            this.setName("Trident callback thread");
            this.setDaemon(true);
        }

        @Override
        public void run() {
            while (true) {
                try {
                    while (true) {
                        Runnable runnable = (Runnable)TimelineEngine.this.callbackQueue.take();
                        runnable.run();
                    }
                }
                catch (Throwable t2) {
                    t2.printStackTrace();
                    continue;
                }
                break;
            }
        }
    }

    class TridentAnimationThread
    extends Thread {
        public TridentAnimationThread() {
            this.setName("Trident pulse source thread");
            this.setDaemon(true);
        }

        @Override
        public final void run() {
            TridentCortex.PulseSource pulseSource = TridentCortex.getPulseSource();
            TimelineEngine.this.lastIterationTimeStamp = System.currentTimeMillis();
            while (true) {
                pulseSource.waitUntilNextPulse();
                TimelineEngine.this.updateTimelines();
            }
        }

        @Override
        public void interrupt() {
            System.err.println("Interrupted");
            super.interrupt();
        }
    }

    static class FullObjectID {
        public Object mainObj;
        public Comparable subID;

        public FullObjectID(Object mainObj, Comparable subID) {
            this.mainObj = mainObj;
            this.subID = subID;
        }

        public int hashCode() {
            int result = this.mainObj.hashCode();
            if (this.subID != null) {
                result &= this.subID.hashCode();
            }
            return result;
        }

        public boolean equals(Object obj) {
            if (obj instanceof FullObjectID) {
                FullObjectID cid = (FullObjectID)obj;
                try {
                    boolean result;
                    boolean bl = result = this.mainObj == cid.mainObj;
                    result = this.subID == null ? result && cid.subID == null : result && this.subID.compareTo(cid.subID) == 0;
                    return result;
                }
                catch (Exception exc) {
                    return false;
                }
            }
            return false;
        }

        public String toString() {
            return this.mainObj.getClass().getSimpleName() + ":" + this.subID;
        }
    }

    static enum TimelineOperationKind {
        PLAY,
        CANCEL,
        RESUME,
        SUSPEND,
        ABORT,
        END;

    }
}

