/*
 * Decompiled with CFR 0.152.
 */
package org.pushingpixels.trident.api;

import java.util.ArrayList;
import java.util.List;
import java.util.Stack;
import java.util.function.Supplier;
import org.pushingpixels.trident.api.TimelineEngine;
import org.pushingpixels.trident.api.TimelinePropertyBuilder;
import org.pushingpixels.trident.api.TimelineScenario;
import org.pushingpixels.trident.api.callback.TimelineCallback;
import org.pushingpixels.trident.api.callback.TimelineCallbackAdapter;
import org.pushingpixels.trident.api.ease.Linear;
import org.pushingpixels.trident.api.ease.TimelineEase;
import org.pushingpixels.trident.api.interpolator.KeyFrames;
import org.pushingpixels.trident.api.swing.RunOnEventDispatchThread;
import org.pushingpixels.trident.internal.swing.SwingUtils;

public class Timeline
implements TimelineScenario.TimelineScenarioActor {
    public static final long DEFAULT_DURATION = 500L;
    public static final TimelineEase DEFAULT_EASE = new Linear();
    private Object mainObject;
    private Comparable<?> secondaryId;
    TimelineEngine.FullObjectID fullObjectID;
    private long duration;
    private long initialDelay;
    private long cycleDelay;
    boolean isLooping;
    int repeatCount;
    private RepeatBehavior repeatBehavior;
    private boolean mainObjectIsUiComponent;
    Chain callbackChain;
    private String name;
    private List<TimelinePropertyBuilder.AbstractFieldInfo<?>> propertiesToInterpolate;
    private static long counter;
    long id;
    float durationFraction;
    float timelinePosition;
    long timeUntilPlay;
    boolean toCancelAtCycleBreak;
    private Stack<TimelineState> stateStack;
    private TimelineEase ease;
    private int doneCount;

    public static Builder builder() {
        return new Builder();
    }

    public static Builder builder(Object mainTimelineObject) {
        return new Builder(mainTimelineObject);
    }

    protected Timeline(Object mainTimelineObject) {
        this.mainObject = mainTimelineObject;
        this.mainObjectIsUiComponent = SwingUtils.isUiComponent(this.mainObject);
        Setter setterCallback = this.mainObjectIsUiComponent ? new UISetter() : new Setter();
        this.callbackChain = new Chain(setterCallback);
        this.duration = 500L;
        this.propertiesToInterpolate = new ArrayList();
        this.id = Timeline.getId();
        this.stateStack = new Stack();
        this.stateStack.push(TimelineState.IDLE);
        this.doneCount = 0;
        this.ease = DEFAULT_EASE;
    }

    protected final void addCallback(TimelineCallback callback) {
        if (this.getState() != TimelineState.IDLE) {
            throw new IllegalArgumentException("Cannot change state of non-idle timeline [" + this.toString() + "]");
        }
        this.callbackChain.addCallback(callback);
    }

    public static <T> TimelinePropertyBuilder<T> property(String propertyName) {
        return new TimelinePropertyBuilder(propertyName);
    }

    protected boolean shouldForceUiUpdate() {
        return false;
    }

    @Override
    public void play() {
        this.playSkipping(0L);
    }

    public void playSkipping(long msToSkip) {
        if (this.initialDelay + this.duration < msToSkip) {
            throw new IllegalArgumentException("Required skip longer than initial delay + duration");
        }
        TimelineEngine.getInstance().runTimelineOperation(this, TimelineEngine.TimelineOperationKind.PLAY, () -> {
            this.isLooping = false;
            TimelineEngine.getInstance().play(this, false, msToSkip);
        });
    }

    public void playReverse() {
        this.playReverseSkipping(0L);
    }

    public void playReverseSkipping(long msToSkip) {
        if (this.initialDelay + this.duration < msToSkip) {
            throw new IllegalArgumentException("Required skip longer than initial delay + duration");
        }
        TimelineEngine.getInstance().runTimelineOperation(this, TimelineEngine.TimelineOperationKind.PLAY, () -> {
            this.isLooping = false;
            TimelineEngine.getInstance().playReverse(this, false, msToSkip);
        });
    }

    public void replay() {
        TimelineEngine.getInstance().runTimelineOperation(this, TimelineEngine.TimelineOperationKind.PLAY, () -> {
            this.isLooping = false;
            TimelineEngine.getInstance().play(this, true, 0L);
        });
    }

    public void replayReverse() {
        TimelineEngine.getInstance().runTimelineOperation(this, TimelineEngine.TimelineOperationKind.PLAY, () -> {
            this.isLooping = false;
            TimelineEngine.getInstance().playReverse(this, true, 0L);
        });
    }

    public void playLoop(RepeatBehavior repeatBehavior) {
        this.playLoop(-1, repeatBehavior);
    }

    public void playLoopSkipping(RepeatBehavior repeatBehavior, long msToSkip) {
        this.playLoopSkipping(-1, repeatBehavior, msToSkip);
    }

    public void playLoop(int loopCount, RepeatBehavior repeatBehavior) {
        this.playLoopSkipping(loopCount, repeatBehavior, 0L);
    }

    public void playLoopSkipping(int loopCount, RepeatBehavior repeatBehavior, long msToSkip) {
        if (this.initialDelay + this.duration < msToSkip) {
            throw new IllegalArgumentException("Required skip longer than initial delay + duration");
        }
        for (TimelinePropertyBuilder.AbstractFieldInfo<?> fieldInfo : this.propertiesToInterpolate) {
            if (!fieldInfo.isFromCurrent()) continue;
            throw new IllegalArgumentException("Can't loop a timeline that has at least one property with .fromCurrent()");
        }
        TimelineEngine.getInstance().runTimelineOperation(this, TimelineEngine.TimelineOperationKind.PLAY, () -> {
            this.isLooping = true;
            this.repeatCount = loopCount;
            this.repeatBehavior = repeatBehavior;
            TimelineEngine.getInstance().playLoop(this, msToSkip);
        });
    }

    public void cancel() {
        TimelineEngine.getInstance().runTimelineOperation(this, TimelineEngine.TimelineOperationKind.CANCEL, null);
    }

    public void end() {
        TimelineEngine.getInstance().runTimelineOperation(this, TimelineEngine.TimelineOperationKind.END, null);
    }

    public void abort() {
        TimelineEngine.getInstance().runTimelineOperation(this, TimelineEngine.TimelineOperationKind.ABORT, null);
    }

    public void suspend() {
        TimelineEngine.getInstance().runTimelineOperation(this, TimelineEngine.TimelineOperationKind.SUSPEND, null);
    }

    public void resume() {
        TimelineEngine.getInstance().runTimelineOperation(this, TimelineEngine.TimelineOperationKind.RESUME, null);
    }

    public void cancelAtCycleBreak() {
        if (!this.isLooping) {
            throw new IllegalArgumentException("Can only be called on looping timelines");
        }
        this.toCancelAtCycleBreak = true;
    }

    protected static synchronized long getId() {
        return counter++;
    }

    public final float getTimelinePosition() {
        return this.timelinePosition;
    }

    public final float getDurationFraction() {
        return this.durationFraction;
    }

    public final TimelineState getState() {
        return this.stateStack.peek();
    }

    @Override
    public boolean isDone() {
        return this.doneCount > 0;
    }

    @Override
    public boolean supportsReplay() {
        return true;
    }

    @Override
    public void resetDoneFlag() {
        this.doneCount = 0;
    }

    public String toString() {
        StringBuffer res = new StringBuffer();
        res.append("[" + this.id + "] ");
        if (this.name != null) {
            res.append(this.name);
        }
        if (this.mainObject != null) {
            res.append(":" + this.mainObject.getClass().getName());
        }
        if (this.secondaryId != null) {
            res.append(":" + this.secondaryId.toString());
        }
        res.append(" " + this.getState().name());
        res.append(":" + this.timelinePosition);
        res.append(" [ ");
        for (TimelinePropertyBuilder.AbstractFieldInfo<?> afi : this.propertiesToInterpolate) {
            res.append(afi.fieldName + " ");
        }
        res.append("]");
        return res.toString();
    }

    void replaceState(TimelineState state) {
        this.stateStack.pop();
        this.pushState(state);
    }

    void pushState(TimelineState state) {
        if (state == TimelineState.DONE) {
            ++this.doneCount;
        }
        this.stateStack.add(state);
    }

    TimelineState popState() {
        return this.stateStack.pop();
    }

    public final long getDuration() {
        return this.duration;
    }

    public long getInitialDelay() {
        return this.initialDelay;
    }

    public long getCycleDelay() {
        return this.cycleDelay;
    }

    public RepeatBehavior getRepeatBehavior() {
        return this.repeatBehavior;
    }

    public String getName() {
        return this.name;
    }

    public TimelineEase getEase() {
        return this.ease;
    }

    public Object getMainObject() {
        return this.mainObject;
    }

    public Comparable<?> getSecondaryId() {
        return this.secondaryId;
    }

    public static class Builder
    extends BaseBuilder<Timeline, Builder, Object> {
        public Builder() {
        }

        public Builder(Object mainObject) {
            super(mainObject);
        }

        @Override
        public Timeline build() {
            Timeline timeline = new Timeline(this.mainObject);
            this.configureBaseTimeline(timeline);
            return timeline;
        }
    }

    public static abstract class BaseBuilder<T extends Timeline, B extends BaseBuilder<?, ?, ?>, M> {
        protected M mainObject;
        protected Comparable<?> secondaryId;
        protected long duration = 500L;
        protected long initialDelay;
        protected long cycleDelay;
        protected int repeatCount;
        protected RepeatBehavior repeatBehavior;
        protected List<TimelineCallback> callbacks = new ArrayList<TimelineCallback>();
        protected String name;
        protected List<TimelinePropertyBuilder.AbstractFieldInfo<?>> propertiesToInterpolate = new ArrayList();
        protected TimelineEase ease = DEFAULT_EASE;

        public BaseBuilder() {
            this(null);
        }

        public BaseBuilder(M mainObject) {
            this.mainObject = mainObject;
        }

        protected void configureBaseTimeline(Timeline timeline) {
            timeline.secondaryId = this.secondaryId;
            timeline.duration = this.duration;
            timeline.initialDelay = this.initialDelay;
            timeline.cycleDelay = this.cycleDelay;
            timeline.repeatCount = this.repeatCount;
            timeline.repeatBehavior = this.repeatBehavior;
            timeline.name = this.name;
            timeline.ease = this.ease;
            for (TimelineCallback callback : this.callbacks) {
                timeline.callbackChain.addCallback(callback);
            }
            timeline.propertiesToInterpolate.addAll(this.propertiesToInterpolate);
        }

        public B setSecondaryId(Comparable<?> secondaryId) {
            this.secondaryId = secondaryId;
            return (B)this;
        }

        public B setDuration(long duration) {
            this.duration = duration;
            return (B)this;
        }

        public long getDuration() {
            return this.duration;
        }

        public B setInitialDelay(long initialDelay) {
            this.initialDelay = initialDelay;
            return (B)this;
        }

        public B setCycleDelay(long cycleDelay) {
            this.cycleDelay = cycleDelay;
            return (B)this;
        }

        public B setRepeatCount(int repeatCount) {
            this.repeatCount = repeatCount;
            return (B)this;
        }

        public B setRepeatBehavior(RepeatBehavior repeatBehavior) {
            this.repeatBehavior = repeatBehavior;
            return (B)this;
        }

        public B setName(String name) {
            this.name = name;
            return (B)this;
        }

        public B setEase(TimelineEase ease) {
            this.ease = ease;
            return (B)this;
        }

        public <P> B addPropertyToInterpolate(TimelinePropertyBuilder<P> propertyBuilder) {
            this.propertiesToInterpolate.add(propertyBuilder.getFieldInfo(this.mainObject));
            return (B)this;
        }

        public <P> B addPropertyToInterpolate(String propName, KeyFrames<P> keyFrames) {
            return this.addPropertyToInterpolate(Timeline.property(propName).goingThrough(keyFrames));
        }

        public <P> B addPropertyToInterpolate(String propName, P from, P to) {
            return this.addPropertyToInterpolate(Timeline.property(propName).from(from).to(to));
        }

        public <P> B addPropertyToInterpolate(String propName, Supplier<P> fromSupplier, Supplier<P> toSupplier) {
            return this.addPropertyToInterpolate(Timeline.property(propName).fromSupplier(fromSupplier).toSupplier(toSupplier));
        }

        public B addCallback(TimelineCallback callback) {
            this.callbacks.add(callback);
            return (B)this;
        }

        public abstract T build();

        public void play() {
            ((Timeline)this.build()).play();
        }

        public void playSkipping(long msToSkip) {
            ((Timeline)this.build()).playSkipping(msToSkip);
        }

        public void playReverse() {
            ((Timeline)this.build()).playReverse();
        }

        public void playReverseSkipping(long msToSkip) {
            ((Timeline)this.build()).playReverseSkipping(msToSkip);
        }

        public void playLoop(RepeatBehavior repeatBehavior) {
            ((Timeline)this.build()).playLoop(repeatBehavior);
        }

        public void playLoopSkipping(RepeatBehavior repeatBehavior, long msToSkip) {
            ((Timeline)this.build()).playLoopSkipping(repeatBehavior, msToSkip);
        }

        public void playLoop(int loopCount, RepeatBehavior repeatBehavior) {
            ((Timeline)this.build()).playLoop(loopCount, repeatBehavior);
        }

        public void playLoopSkipping(int loopCount, RepeatBehavior repeatBehavior, long msToSkip) {
            ((Timeline)this.build()).playLoopSkipping(loopCount, repeatBehavior, msToSkip);
        }
    }

    class Chain
    implements TimelineCallback {
        private TimelineCallback setterCallback;
        private List<TimelineCallback> callbacks;

        public Chain(Setter setterCallback) {
            this.setterCallback = setterCallback;
            this.callbacks = new ArrayList<TimelineCallback>();
        }

        public void addCallback(TimelineCallback callback) {
            this.callbacks.add(callback);
        }

        public void removeCallback(TimelineCallback callback) {
            this.callbacks.remove(callback);
        }

        private void handleStateChange(TimelineCallback callback, TimelineState oldState, TimelineState newState, float durationFraction, float timelinePosition) {
            boolean shouldRunOnUIThread = false;
            for (Class<?> clazz = callback.getClass(); clazz != null && !shouldRunOnUIThread; clazz = clazz.getSuperclass()) {
                shouldRunOnUIThread = clazz.isAnnotationPresent(RunOnEventDispatchThread.class);
            }
            if (shouldRunOnUIThread && Timeline.this.mainObjectIsUiComponent) {
                SwingUtils.runOnEventDispatchThread(() -> callback.onTimelineStateChanged(oldState, newState, durationFraction, timelinePosition));
            } else {
                callback.onTimelineStateChanged(oldState, newState, durationFraction, timelinePosition);
            }
        }

        @Override
        public void onTimelineStateChanged(TimelineState oldState, TimelineState newState, float durationFraction, float timelinePosition) {
            if (Timeline.this.mainObjectIsUiComponent && !Timeline.this.shouldForceUiUpdate() && !SwingUtils.isComponentInReadyState(Timeline.this.mainObject)) {
                if (TimelineEngine.DEBUG_MODE) {
                    System.out.println("Main object [" + Timeline.this.mainObject.getClass().getSimpleName() + "@" + Timeline.this.mainObject.hashCode() + "] is not in ready state for " + oldState.name() + " to " + newState.name());
                }
                return;
            }
            this.handleStateChange(this.setterCallback, oldState, newState, durationFraction, timelinePosition);
            for (int i2 = this.callbacks.size() - 1; i2 >= 0; --i2) {
                this.handleStateChange(this.callbacks.get(i2), oldState, newState, durationFraction, timelinePosition);
            }
        }

        private void handlePulse(TimelineCallback callback, float durationFraction, float timelinePosition) {
            boolean shouldRunOnUIThread = false;
            for (Class<?> clazz = callback.getClass(); clazz != null && !shouldRunOnUIThread; clazz = clazz.getSuperclass()) {
                shouldRunOnUIThread = clazz.isAnnotationPresent(RunOnEventDispatchThread.class);
            }
            if (shouldRunOnUIThread && Timeline.this.mainObjectIsUiComponent) {
                SwingUtils.runOnEventDispatchThread(() -> {
                    if (Timeline.this.getState() == TimelineState.CANCELLED) {
                        return;
                    }
                    callback.onTimelinePulse(durationFraction, timelinePosition);
                });
            } else {
                callback.onTimelinePulse(durationFraction, timelinePosition);
            }
        }

        @Override
        public void onTimelinePulse(float durationFraction, float timelinePosition) {
            if (Timeline.this.mainObjectIsUiComponent && !Timeline.this.shouldForceUiUpdate() && !SwingUtils.isComponentInReadyState(Timeline.this.mainObject)) {
                if (TimelineEngine.DEBUG_MODE) {
                    System.out.println("Main object is not in ready state for pulse " + durationFraction);
                }
                return;
            }
            this.handlePulse(this.setterCallback, durationFraction, timelinePosition);
            for (int i2 = this.callbacks.size() - 1; i2 >= 0; --i2) {
                this.handlePulse(this.callbacks.get(i2), durationFraction, timelinePosition);
            }
        }
    }

    @RunOnEventDispatchThread
    private class UISetter
    extends Setter {
        private UISetter() {
        }
    }

    private class Setter
    extends TimelineCallbackAdapter {
        private Setter() {
        }

        @Override
        public void onTimelineStateChanged(TimelineState oldState, TimelineState newState, float durationFraction, float timelinePosition) {
            if (newState == TimelineState.READY) {
                for (TimelinePropertyBuilder.AbstractFieldInfo fInfo : Timeline.this.propertiesToInterpolate) {
                    if (Timeline.this.mainObjectIsUiComponent && !SwingUtils.isComponentInReadyState(fInfo.object)) continue;
                    fInfo.onStart();
                }
            }
            if (newState == TimelineState.PLAYING_FORWARD) {
                for (TimelinePropertyBuilder.AbstractFieldInfo fInfo : Timeline.this.propertiesToInterpolate) {
                    if (Timeline.this.mainObjectIsUiComponent && !SwingUtils.isComponentInReadyState(fInfo.object)) continue;
                    fInfo.updateTo();
                }
            }
            if (newState == TimelineState.PLAYING_REVERSE) {
                for (TimelinePropertyBuilder.AbstractFieldInfo fInfo : Timeline.this.propertiesToInterpolate) {
                    if (Timeline.this.mainObjectIsUiComponent && !SwingUtils.isComponentInReadyState(fInfo.object)) continue;
                    fInfo.updateFrom();
                }
            }
            if (oldState.isActive || newState.isActive) {
                for (TimelinePropertyBuilder.AbstractFieldInfo fInfo : Timeline.this.propertiesToInterpolate) {
                    if (Timeline.this.mainObjectIsUiComponent && !SwingUtils.isComponentInReadyState(fInfo.object)) continue;
                    fInfo.updateFieldValue(timelinePosition);
                }
            }
        }

        @Override
        public void onTimelinePulse(float durationFraction, float timelinePosition) {
            for (TimelinePropertyBuilder.AbstractFieldInfo fInfo : Timeline.this.propertiesToInterpolate) {
                if (Timeline.this.mainObjectIsUiComponent && !SwingUtils.isComponentInReadyState(fInfo.object)) continue;
                fInfo.updateFieldValue(timelinePosition);
            }
        }
    }

    public static enum TimelineState {
        IDLE(false),
        READY(false),
        PLAYING_FORWARD(true),
        PLAYING_REVERSE(true),
        SUSPENDED(false),
        CANCELLED(false),
        DONE(false);

        private boolean isActive;

        private TimelineState(boolean isActive) {
            this.isActive = isActive;
        }
    }

    public static enum RepeatBehavior {
        LOOP,
        REVERSE;

    }
}

