/*
 * Decompiled with CFR 0.152.
 */
package org.pushingpixels.substance.internal.widget.tree.dnd;

import java.awt.Component;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Insets;
import javax.swing.BorderFactory;
import javax.swing.Icon;
import javax.swing.border.Border;
import org.pushingpixels.neon.api.icon.ResizableIcon;
import org.pushingpixels.substance.api.SubstanceCortex;
import org.pushingpixels.substance.api.colorscheme.SubstanceColorScheme;
import org.pushingpixels.substance.api.colorscheme.SunsetColorScheme;
import org.pushingpixels.substance.api.icon.SubstanceIconPack;
import org.pushingpixels.substance.internal.utils.SubstanceCoreUtilities;

class DnDBorderFactory {
    private Border dropAllowedBorder;
    private Border dropNotAllowedBorder;
    private Border offsetBorder;
    private Border emptyBorder;

    public DnDBorderFactory() {
        this.setDropAllowedBorder(new DropAllowedBorder());
        this.setDropNotAllowedBorder(new DropNotAllowedBorder());
        this.setOffsetBorder(new OffsetBorder());
        this.setEmptyBorder(BorderFactory.createEmptyBorder());
    }

    public Border getDropAllowedBorder() {
        return this.dropAllowedBorder;
    }

    public void setDropAllowedBorder(Border dropAllowedBorder) {
        this.dropAllowedBorder = dropAllowedBorder;
    }

    public Border getDropNotAllowedBorder() {
        return this.dropNotAllowedBorder;
    }

    public void setDropNotAllowedBorder(Border dropNotAllowedBorder) {
        this.dropNotAllowedBorder = dropNotAllowedBorder;
    }

    public Border getOffsetBorder() {
        return this.offsetBorder;
    }

    public void setOffsetBorder(Border offsetBorder) {
        this.offsetBorder = offsetBorder;
    }

    public Border getEmptyBorder() {
        return this.emptyBorder;
    }

    public void setEmptyBorder(Border anEmptyBorder) {
        this.emptyBorder = anEmptyBorder;
    }

    static class DropNotAllowedBorder
    implements Border {
        private Insets insets = new Insets(0, 0, 0, 0);
        private Icon icon = SubstanceCortex.GlobalScope.getIconPack().getNotAllowedIcon(12, new SunsetColorScheme());

        @Override
        public void paintBorder(Component c2, Graphics g2, int x2, int y2, int width, int height) {
            if (this.icon != null) {
                Graphics2D g2d = (Graphics2D)g2.create();
                g2d.translate(x2, y2 + (height - this.icon.getIconHeight()) / 2);
                this.icon.paintIcon(c2, g2d, 0, 0);
                g2d.dispose();
            }
        }

        @Override
        public Insets getBorderInsets(Component c2) {
            return this.insets;
        }

        @Override
        public boolean isBorderOpaque() {
            return false;
        }
    }

    static class OffsetBorder
    implements Border {
        private Insets insets = new Insets(5, 0, 0, 0);

        OffsetBorder() {
        }

        @Override
        public void paintBorder(Component c2, Graphics g2, int x2, int y2, int width, int height) {
        }

        @Override
        public Insets getBorderInsets(Component c2) {
            return this.insets;
        }

        @Override
        public boolean isBorderOpaque() {
            return false;
        }
    }

    static class DropAllowedBorder
    implements Border {
        private static Insets insets = new Insets(0, 0, 3, 0);

        @Override
        public void paintBorder(Component c2, Graphics g2, int x2, int y2, int width, int height) {
            int yh2 = y2 + height - 1;
            SubstanceIconPack iconPack = SubstanceCortex.GlobalScope.getIconPack();
            SubstanceColorScheme colorScheme = SubstanceCoreUtilities.getSkin(c2).getEnabledColorScheme(SubstanceCortex.ComponentOrParentChainScope.getDecorationType(c2));
            ResizableIcon icon = iconPack.getAllowedIcon(12, colorScheme);
            Graphics2D g2d = (Graphics2D)g2.create();
            g2d.translate(x2, yh2 - icon.getIconHeight());
            icon.paintIcon(c2, g2d, 0, 0);
            g2.setColor(colorScheme.getForegroundColor());
            g2.drawLine(x2 + 16, yh2 -= 4, x2 + 40, yh2);
        }

        @Override
        public Insets getBorderInsets(Component c2) {
            return insets;
        }

        @Override
        public boolean isBorderOpaque() {
            return false;
        }
    }
}

