/*
 * Decompiled with CFR 0.152.
 */
package org.pushingpixels.substance.internal.widget.text;

import java.awt.event.ActionEvent;
import java.beans.PropertyChangeListener;
import javax.swing.AbstractAction;
import javax.swing.InputMap;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;
import javax.swing.text.JTextComponent;
import org.pushingpixels.substance.api.SubstanceWidget;
import org.pushingpixels.substance.internal.utils.WidgetUtilities;

public class SelectOnEscapeWidget
extends SubstanceWidget<JTextComponent> {
    private PropertyChangeListener propertyChangeListener;
    private static final String FLIP_SELECTION_KEY = "substancelaf.internal.flipTextSelection";

    private void installTracking() {
        InputMap currMap = SwingUtilities.getUIInputMap(this.jcomp, 0);
        InputMap newMap = new InputMap();
        if (currMap != null) {
            KeyStroke[] kss;
            for (KeyStroke stroke : kss = currMap.allKeys()) {
                Object val = currMap.get(stroke);
                newMap.put(stroke, val);
            }
        }
        newMap.put(KeyStroke.getKeyStroke(27, 0), FLIP_SELECTION_KEY);
        ((JTextComponent)this.jcomp).getActionMap().put(FLIP_SELECTION_KEY, new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e2) {
                SwingUtilities.invokeLater(() -> {
                    int selectionLength = ((JTextComponent)SelectOnEscapeWidget.this.jcomp).getSelectionEnd() - ((JTextComponent)SelectOnEscapeWidget.this.jcomp).getSelectionStart();
                    if (selectionLength == 0) {
                        ((JTextComponent)SelectOnEscapeWidget.this.jcomp).selectAll();
                    } else {
                        int lastPos = ((JTextComponent)SelectOnEscapeWidget.this.jcomp).getSelectionEnd();
                        ((JTextComponent)SelectOnEscapeWidget.this.jcomp).setSelectionStart(0);
                        ((JTextComponent)SelectOnEscapeWidget.this.jcomp).setSelectionEnd(0);
                        ((JTextComponent)SelectOnEscapeWidget.this.jcomp).setCaretPosition(lastPos);
                    }
                });
            }
        });
        SwingUtilities.replaceUIInputMap(this.jcomp, 0, newMap);
    }

    private void uninstallTracking() {
        InputMap currMap = SwingUtilities.getUIInputMap(this.jcomp, 0);
        if (currMap != null) {
            KeyStroke[] kss;
            InputMap newMap = new InputMap();
            for (KeyStroke stroke : kss = currMap.allKeys()) {
                Object val = currMap.get(stroke);
                if (stroke.equals(KeyStroke.getKeyStroke(27, 0)) && FLIP_SELECTION_KEY.equals(val)) continue;
                newMap.put(stroke, val);
            }
            SwingUtilities.replaceUIInputMap(this.jcomp, 0, newMap);
        }
        ((JTextComponent)this.jcomp).getActionMap().remove(FLIP_SELECTION_KEY);
    }

    @Override
    public void installListeners() {
        this.propertyChangeListener = propertyChangeEvent -> {
            if ("substancelaf.internal.widget.textFlipSelectOnEscape".equals(propertyChangeEvent.getPropertyName())) {
                boolean hasTextFlipSelection = WidgetUtilities.hasTextFlipSelectOnEscapeProperty((JTextComponent)this.jcomp);
                if (hasTextFlipSelection) {
                    this.installTracking();
                } else {
                    this.uninstallTracking();
                }
            }
        };
        ((JTextComponent)this.jcomp).addPropertyChangeListener(this.propertyChangeListener);
    }

    @Override
    public void uninstallListeners() {
        ((JTextComponent)this.jcomp).removePropertyChangeListener(this.propertyChangeListener);
        this.propertyChangeListener = null;
    }
}

