/*
 * Decompiled with CFR 0.152.
 */
package org.pushingpixels.substance.internal.widget.text;

import java.awt.Component;
import java.awt.Graphics;
import java.awt.Insets;
import java.awt.Rectangle;
import java.beans.PropertyChangeListener;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JPasswordField;
import javax.swing.JViewport;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.border.Border;
import javax.swing.border.EmptyBorder;
import javax.swing.plaf.UIResource;
import javax.swing.text.JTextComponent;
import org.pushingpixels.substance.api.ComponentState;
import org.pushingpixels.substance.api.SubstanceWidget;
import org.pushingpixels.substance.internal.utils.SubstanceColorSchemeUtilities;
import org.pushingpixels.substance.internal.utils.SubstanceCoreUtilities;
import org.pushingpixels.substance.internal.utils.SubstanceImageCreator;
import org.pushingpixels.substance.internal.utils.border.BorderWrapper;

public class LockBorderWidget
extends SubstanceWidget<JTextComponent> {
    private PropertyChangeListener propertyChangeListener;
    private boolean isUninstalling = false;
    private static final String ORIGINAL_BORDER = "substancelaf.internal.lockBorder.original";

    @Override
    public void installListeners() {
        this.propertyChangeListener = propertyChangeEvent -> {
            if ("border".equals(propertyChangeEvent.getPropertyName())) {
                return;
            }
            if (ORIGINAL_BORDER.equals(propertyChangeEvent.getPropertyName())) {
                return;
            }
            SwingUtilities.invokeLater(() -> {
                if (this.isUninstalling) {
                    return;
                }
                boolean hasLockIcon = LockBorderWidget.hasLockIcon(this.jcomp);
                if (hasLockIcon) {
                    this.installLockBorder();
                } else {
                    this.restoreOriginalBorder();
                }
            });
        };
        ((JTextComponent)this.jcomp).addPropertyChangeListener(this.propertyChangeListener);
    }

    @Override
    public void uninstallListeners() {
        ((JTextComponent)this.jcomp).removePropertyChangeListener(this.propertyChangeListener);
        this.propertyChangeListener = null;
    }

    @Override
    public void uninstallUI() {
        this.isUninstalling = true;
        Border original = (Border)((JTextComponent)this.jcomp).getClientProperty(ORIGINAL_BORDER);
        if (original != null) {
            ((JTextComponent)this.jcomp).setBorder(original);
        }
    }

    @Override
    public void installDefaults() {
        super.installDefaults();
        if (LockBorderWidget.hasLockIcon(this.jcomp)) {
            Border currBorder = ((JTextComponent)this.jcomp).getBorder();
            ((JTextComponent)this.jcomp).putClientProperty(ORIGINAL_BORDER, currBorder);
            ((JTextComponent)this.jcomp).setBorder(new LockBorder(currBorder));
        }
    }

    @Override
    public void uninstallDefaults() {
        this.isUninstalling = true;
        ((JTextComponent)this.jcomp).putClientProperty(ORIGINAL_BORDER, null);
    }

    private void installLockBorder() {
        if (((JTextComponent)this.jcomp).getClientProperty(ORIGINAL_BORDER) instanceof Border) {
            return;
        }
        Border currBorder = ((JTextComponent)this.jcomp).getBorder();
        if (currBorder != null) {
            ((JTextComponent)this.jcomp).putClientProperty(ORIGINAL_BORDER, currBorder);
            ((JTextComponent)this.jcomp).setBorder(new LockBorder(currBorder));
        }
    }

    private void restoreOriginalBorder() {
        if (((JTextComponent)this.jcomp).getClientProperty(ORIGINAL_BORDER) instanceof Border) {
            Border originalBorder = (Border)((JTextComponent)this.jcomp).getClientProperty(ORIGINAL_BORDER);
            ((JTextComponent)this.jcomp).setBorder(originalBorder);
            ((JTextComponent)this.jcomp).putClientProperty(ORIGINAL_BORDER, null);
        }
    }

    private static boolean hasLockIcon(Component comp) {
        boolean isEditableTextComponent;
        if (!SubstanceCoreUtilities.toShowExtraWidgets(comp)) {
            return false;
        }
        if (comp instanceof JPasswordField) {
            return false;
        }
        boolean bl = isEditableTextComponent = comp instanceof JTextComponent ? ((JTextComponent)comp).isEditable() : false;
        if (comp instanceof JComponent) {
            if (!isEditableTextComponent && Boolean.TRUE.equals(((JComponent)comp).getClientProperty("substancelaf.internal.widget.hasLockIcon"))) {
                return true;
            }
            if (Boolean.FALSE.equals(((JComponent)comp).getClientProperty("substancelaf.internal.widget.hasLockIcon"))) {
                return false;
            }
        }
        return !isEditableTextComponent && Boolean.TRUE.equals(UIManager.get("substancelaf.internal.widget.hasLockIcon"));
    }

    private static class LockBorder
    implements Border,
    UIResource,
    BorderWrapper {
        private Border originalBorder;

        public LockBorder(Border originalBorder) {
            this.originalBorder = originalBorder != null ? originalBorder : new EmptyBorder(0, 0, 0, 0);
        }

        @Override
        public Insets getBorderInsets(Component c2) {
            Icon lockIcon = SubstanceImageCreator.getSmallLockIcon(SubstanceColorSchemeUtilities.getColorScheme(c2, ComponentState.ENABLED), c2);
            Insets origInsets = this.originalBorder.getBorderInsets(c2);
            if (c2.getComponentOrientation().isLeftToRight()) {
                return new Insets(origInsets.top, origInsets.left, origInsets.bottom, Math.max(origInsets.right, lockIcon.getIconWidth() + 2));
            }
            return new Insets(origInsets.top, Math.max(origInsets.left, lockIcon.getIconWidth() + 2), origInsets.bottom, origInsets.right);
        }

        @Override
        public boolean isBorderOpaque() {
            return this.originalBorder.isBorderOpaque();
        }

        @Override
        public Border getOriginalBorder() {
            return this.originalBorder;
        }

        @Override
        public void paintBorder(Component c2, Graphics g2, int x2, int y2, int width, int height) {
            this.originalBorder.paintBorder(c2, g2, x2, y2, width, height);
            Icon lockIcon = SubstanceImageCreator.getSmallLockIcon(SubstanceColorSchemeUtilities.getColorScheme(c2, ComponentState.ENABLED), c2);
            int offsetY = 1;
            if (c2.getParent() instanceof JViewport) {
                JViewport viewport = (JViewport)c2.getParent();
                if (viewport.getScrollMode() != 0) {
                    viewport.setScrollMode(0);
                }
                Rectangle viewRect = viewport.getViewRect();
                offsetY = c2.getHeight() - viewRect.y - viewRect.height;
            }
            int iconY = y2 + height - lockIcon.getIconHeight() - offsetY;
            if (c2.getComponentOrientation().isLeftToRight()) {
                lockIcon.paintIcon(c2, g2, x2 + width - lockIcon.getIconWidth(), iconY);
            } else {
                lockIcon.paintIcon(c2, g2, x2, iconY);
            }
        }
    }
}

