/*
 * Decompiled with CFR 0.152.
 */
package org.pushingpixels.substance.internal.widget.text;

import java.awt.Component;
import java.awt.Graphics;
import java.awt.Insets;
import java.awt.Toolkit;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.beans.PropertyChangeListener;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JPasswordField;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.border.Border;
import javax.swing.border.EmptyBorder;
import javax.swing.plaf.UIResource;
import org.pushingpixels.substance.api.ComponentState;
import org.pushingpixels.substance.api.SubstanceWidget;
import org.pushingpixels.substance.internal.utils.SubstanceColorSchemeUtilities;
import org.pushingpixels.substance.internal.utils.SubstanceCoreUtilities;
import org.pushingpixels.substance.internal.utils.SubstanceImageCreator;
import org.pushingpixels.substance.internal.utils.border.BorderWrapper;

public class CapsLockPasswordBorderWidget
extends SubstanceWidget<JPasswordField> {
    private PropertyChangeListener propertyChangeListener;
    private KeyAdapter keyAdapter;
    private boolean isUninstalling = false;
    private static final String ORIGINAL_BORDER = "substancelaf.internal.capsLockBorder.original";

    @Override
    public void installListeners() {
        this.propertyChangeListener = propertyChangeEvent -> {
            if ("border".equals(propertyChangeEvent.getPropertyName())) {
                return;
            }
            if (ORIGINAL_BORDER.equals(propertyChangeEvent.getPropertyName())) {
                return;
            }
            SwingUtilities.invokeLater(() -> {
                if (this.isUninstalling) {
                    return;
                }
                boolean hasCapsLockIcon = CapsLockPasswordBorderWidget.hasCapsLockIcon(this.jcomp);
                if (hasCapsLockIcon) {
                    this.installCapsLockBorder();
                } else {
                    this.restoreOriginalBorder();
                }
            });
        };
        ((JPasswordField)this.jcomp).addPropertyChangeListener(this.propertyChangeListener);
        this.keyAdapter = new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent e2) {
                ((JPasswordField)CapsLockPasswordBorderWidget.this.jcomp).repaint();
            }

            @Override
            public void keyReleased(KeyEvent e2) {
                ((JPasswordField)CapsLockPasswordBorderWidget.this.jcomp).repaint();
            }
        };
        ((JPasswordField)this.jcomp).addKeyListener(this.keyAdapter);
    }

    @Override
    public void uninstallListeners() {
        ((JPasswordField)this.jcomp).removePropertyChangeListener(this.propertyChangeListener);
        this.propertyChangeListener = null;
        ((JPasswordField)this.jcomp).removeKeyListener(this.keyAdapter);
        this.keyAdapter = null;
    }

    @Override
    public void uninstallUI() {
        this.isUninstalling = true;
        Border original = (Border)((JPasswordField)this.jcomp).getClientProperty(ORIGINAL_BORDER);
        if (original != null) {
            ((JPasswordField)this.jcomp).setBorder(original);
        }
    }

    @Override
    public void installDefaults() {
        super.installDefaults();
        if (CapsLockPasswordBorderWidget.hasCapsLockIcon(this.jcomp)) {
            Border currBorder = ((JPasswordField)this.jcomp).getBorder();
            ((JPasswordField)this.jcomp).putClientProperty(ORIGINAL_BORDER, currBorder);
            ((JPasswordField)this.jcomp).setBorder(new CapsLockBorder(currBorder));
        }
    }

    @Override
    public void uninstallDefaults() {
        this.isUninstalling = true;
        ((JPasswordField)this.jcomp).putClientProperty(ORIGINAL_BORDER, null);
    }

    private void installCapsLockBorder() {
        if (((JPasswordField)this.jcomp).getClientProperty(ORIGINAL_BORDER) instanceof Border) {
            return;
        }
        Border currBorder = ((JPasswordField)this.jcomp).getBorder();
        if (currBorder != null) {
            ((JPasswordField)this.jcomp).putClientProperty(ORIGINAL_BORDER, currBorder);
            ((JPasswordField)this.jcomp).setBorder(new CapsLockBorder(currBorder));
        }
    }

    private void restoreOriginalBorder() {
        if (((JPasswordField)this.jcomp).getClientProperty(ORIGINAL_BORDER) instanceof Border) {
            Border originalBorder = (Border)((JPasswordField)this.jcomp).getClientProperty(ORIGINAL_BORDER);
            ((JPasswordField)this.jcomp).setBorder(originalBorder);
            ((JPasswordField)this.jcomp).putClientProperty(ORIGINAL_BORDER, null);
        }
    }

    private static boolean hasCapsLockIcon(Component comp) {
        if (!SubstanceCoreUtilities.toShowExtraWidgets(comp)) {
            return false;
        }
        if (comp instanceof JComponent) {
            if (Boolean.TRUE.equals(((JComponent)comp).getClientProperty("substancelaf.internal.widget.hasCapsLockIcon"))) {
                return true;
            }
            if (Boolean.FALSE.equals(((JComponent)comp).getClientProperty("substancelaf.internal.widget.hasCapsLockIcon"))) {
                return false;
            }
        }
        return Boolean.TRUE.equals(UIManager.get("substancelaf.internal.widget.hasCapsLockIcon"));
    }

    private static class CapsLockBorder
    implements Border,
    UIResource,
    BorderWrapper {
        private Border originalBorder;

        public CapsLockBorder(Border originalBorder) {
            this.originalBorder = originalBorder != null ? originalBorder : new EmptyBorder(0, 0, 0, 0);
        }

        @Override
        public Insets getBorderInsets(Component c2) {
            Icon capsLockIcon = SubstanceImageCreator.getCapsLockIcon(SubstanceColorSchemeUtilities.getColorScheme(c2, ComponentState.ENABLED), c2);
            Insets origInsets = this.originalBorder.getBorderInsets(c2);
            if (c2.getComponentOrientation().isLeftToRight()) {
                return new Insets(origInsets.top, origInsets.left, origInsets.bottom, Math.max(origInsets.right, capsLockIcon.getIconWidth() + 6));
            }
            return new Insets(origInsets.top, Math.max(origInsets.left, capsLockIcon.getIconWidth() + 6), origInsets.bottom, origInsets.right);
        }

        @Override
        public boolean isBorderOpaque() {
            return this.originalBorder.isBorderOpaque();
        }

        @Override
        public Border getOriginalBorder() {
            return this.originalBorder;
        }

        @Override
        public void paintBorder(Component c2, Graphics g2, int x2, int y2, int width, int height) {
            this.originalBorder.paintBorder(c2, g2, x2, y2, width, height);
            if (!c2.isFocusOwner()) {
                return;
            }
            try {
                if (!Toolkit.getDefaultToolkit().getLockingKeyState(20)) {
                    return;
                }
            }
            catch (UnsupportedOperationException e2) {
                return;
            }
            Icon capsLockIcon = SubstanceImageCreator.getCapsLockIcon(SubstanceColorSchemeUtilities.getColorScheme(c2, ComponentState.ENABLED), c2);
            int iconY = y2 + (height - capsLockIcon.getIconHeight()) / 2;
            if (c2.getComponentOrientation().isLeftToRight()) {
                capsLockIcon.paintIcon(c2, g2, x2 + width - capsLockIcon.getIconWidth() - 4, iconY);
            } else {
                capsLockIcon.paintIcon(c2, g2, x2 + 4, iconY);
            }
        }
    }
}

