/*
 * Decompiled with CFR 0.152.
 */
package org.pushingpixels.substance.internal.utils.menu;

import java.awt.Component;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.util.Map;
import javax.swing.JComponent;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import org.pushingpixels.substance.api.ComponentState;
import org.pushingpixels.substance.api.SubstanceSlices;
import org.pushingpixels.substance.api.colorscheme.SubstanceColorScheme;
import org.pushingpixels.substance.internal.animation.StateTransitionTracker;
import org.pushingpixels.substance.internal.animation.TransitionAwareUI;
import org.pushingpixels.substance.internal.painter.BackgroundPaintingUtils;
import org.pushingpixels.substance.internal.painter.HighlightPainterUtils;
import org.pushingpixels.substance.internal.utils.SubstanceColorSchemeUtilities;
import org.pushingpixels.substance.internal.utils.SubstanceCoreUtilities;
import org.pushingpixels.substance.internal.utils.WidgetUtilities;
import org.pushingpixels.substance.internal.utils.menu.MenuUtilities;

public class SubstanceMenuBackgroundDelegate {
    public static void paintBackground(Graphics g2, JComponent menuItem, int textOffset) {
        if (!menuItem.isShowing()) {
            return;
        }
        int menuWidth = menuItem.getWidth();
        int menuHeight = menuItem.getHeight();
        Graphics2D graphics = (Graphics2D)g2.create();
        graphics.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_OFF);
        BackgroundPaintingUtils.update(graphics, menuItem, false);
        if (textOffset == 0) {
            return;
        }
        if (menuItem.getParent() instanceof JPopupMenu) {
            JPopupMenu parent = (JPopupMenu)menuItem.getParent();
            MenuUtilities.MenuLayoutMetrics popupMetrics = MenuUtilities.getPopupLayoutMetrics(parent, true);
            float fillAlpha = SubstanceCoreUtilities.getMenuGutterFillAlpha();
            boolean hasGutterContent = popupMetrics.maxIconWidth > 0 || popupMetrics.maxCheckIconWidth > 0;
            boolean shouldPaintGutter = hasGutterContent;
            if (shouldPaintGutter) {
                graphics.setComposite(WidgetUtilities.getAlphaComposite(menuItem, fillAlpha, g2));
                SubstanceColorScheme scheme = SubstanceColorSchemeUtilities.getColorScheme(menuItem, ComponentState.ENABLED);
                graphics.setColor(scheme.getAccentedBackgroundFillColor());
                if (menuItem.getComponentOrientation().isLeftToRight()) {
                    graphics.fillRect(0, 0, textOffset - 2, menuHeight);
                } else {
                    graphics.fillRect(textOffset - 2, 0, menuWidth, menuHeight);
                }
            }
        }
        graphics.dispose();
    }

    public static void paintHighlights(Graphics g2, JMenuItem menuItem, float borderAlpha) {
        Graphics2D graphics = (Graphics2D)g2.create();
        TransitionAwareUI transitionAwareUI = (TransitionAwareUI)((Object)menuItem.getUI());
        StateTransitionTracker stateTransitionTracker = transitionAwareUI.getTransitionTracker();
        StateTransitionTracker.ModelStateInfo modelStateInfo = stateTransitionTracker.getModelStateInfo();
        ComponentState currState = modelStateInfo.getCurrModelStateNoSelection();
        if (currState.isDisabled()) {
            return;
        }
        Map<ComponentState, StateTransitionTracker.StateContributionInfo> activeStates = modelStateInfo.getStateNoSelectionContributionMap();
        if (currState == ComponentState.ENABLED && activeStates.size() == 1) {
            return;
        }
        for (Map.Entry<ComponentState, StateTransitionTracker.StateContributionInfo> stateEntry : activeStates.entrySet()) {
            ComponentState activeState = stateEntry.getKey();
            float alpha = SubstanceColorSchemeUtilities.getHighlightAlpha(menuItem, activeState) * stateEntry.getValue().getContribution();
            if (alpha == 0.0f) continue;
            SubstanceColorScheme fillScheme = SubstanceColorSchemeUtilities.getColorScheme(menuItem, SubstanceSlices.ColorSchemeAssociationKind.HIGHLIGHT, activeState);
            SubstanceColorScheme borderScheme = SubstanceColorSchemeUtilities.getColorScheme(menuItem, SubstanceSlices.ColorSchemeAssociationKind.HIGHLIGHT_BORDER, activeState);
            graphics.setComposite(WidgetUtilities.getAlphaComposite(menuItem, alpha, g2));
            HighlightPainterUtils.paintHighlight(graphics, null, menuItem, new Rectangle(0, 0, menuItem.getWidth(), menuItem.getHeight()), borderAlpha, null, fillScheme, borderScheme);
            graphics.setComposite(WidgetUtilities.getAlphaComposite((Component)menuItem, g2));
        }
        graphics.dispose();
    }
}

