/*
 * Decompiled with CFR 0.152.
 */
package org.pushingpixels.substance.internal.utils.icon;

import java.awt.AlphaComposite;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.image.BufferedImage;
import java.util.Map;
import javax.swing.Icon;
import javax.swing.JMenuItem;
import javax.swing.plaf.UIResource;
import org.pushingpixels.substance.api.ComponentState;
import org.pushingpixels.substance.api.SubstanceSlices;
import org.pushingpixels.substance.api.colorscheme.SubstanceColorScheme;
import org.pushingpixels.substance.api.painter.border.SubstanceBorderPainter;
import org.pushingpixels.substance.api.painter.fill.SubstanceFillPainter;
import org.pushingpixels.substance.internal.animation.StateTransitionTracker;
import org.pushingpixels.substance.internal.animation.TransitionAwareUI;
import org.pushingpixels.substance.internal.utils.HashMapKey;
import org.pushingpixels.substance.internal.utils.ImageWrapperIcon;
import org.pushingpixels.substance.internal.utils.LazyResettableHashMap;
import org.pushingpixels.substance.internal.utils.SubstanceColorSchemeUtilities;
import org.pushingpixels.substance.internal.utils.SubstanceCoreUtilities;
import org.pushingpixels.substance.internal.utils.SubstanceImageCreator;
import org.pushingpixels.substance.internal.utils.SubstanceSizeUtils;

public class CheckBoxMenuItemIcon
implements Icon,
UIResource {
    private int size;
    private JMenuItem menuItem;
    private static LazyResettableHashMap<ImageWrapperIcon> iconMap = new LazyResettableHashMap("CheckBoxMenuItemIcon");

    public CheckBoxMenuItemIcon(JMenuItem menuItem, int size) {
        this.menuItem = menuItem;
        this.size = size;
    }

    private ImageWrapperIcon getIconToPaint() {
        if (this.menuItem == null) {
            return null;
        }
        TransitionAwareUI transitionAwareUI = (TransitionAwareUI)((Object)this.menuItem.getUI());
        StateTransitionTracker stateTransitionTracker = transitionAwareUI.getTransitionTracker();
        StateTransitionTracker.ModelStateInfo modelStateInfo = stateTransitionTracker.getModelStateInfo();
        Map<ComponentState, StateTransitionTracker.StateContributionInfo> activeStates = modelStateInfo.getStateContributionMap();
        SubstanceFillPainter fillPainter = SubstanceCoreUtilities.getFillPainter(this.menuItem);
        SubstanceBorderPainter borderPainter = SubstanceCoreUtilities.getBorderPainter(this.menuItem);
        ComponentState currState = modelStateInfo.getCurrModelState();
        SubstanceColorScheme baseFillColorScheme = SubstanceColorSchemeUtilities.getColorScheme(this.menuItem, SubstanceSlices.ColorSchemeAssociationKind.MARK_BOX, currState);
        SubstanceColorScheme baseMarkColorScheme = SubstanceColorSchemeUtilities.getColorScheme(this.menuItem, SubstanceSlices.ColorSchemeAssociationKind.MARK, currState);
        SubstanceColorScheme baseBorderColorScheme = SubstanceColorSchemeUtilities.getColorScheme(this.menuItem, SubstanceSlices.ColorSchemeAssociationKind.BORDER, currState);
        float visibility = stateTransitionTracker.getFacetStrength(SubstanceSlices.ComponentStateFacet.SELECTION);
        boolean isCheckMarkFadingOut = !currState.isFacetActive(SubstanceSlices.ComponentStateFacet.SELECTION);
        float alpha = SubstanceColorSchemeUtilities.getAlpha(this.menuItem, currState);
        int fontSize = SubstanceSizeUtils.getComponentFontSize(this.menuItem);
        int checkMarkSize = this.size + 3;
        HashMapKey keyBase = SubstanceCoreUtilities.getHashKey(fontSize, checkMarkSize, fillPainter.getDisplayName(), borderPainter.getDisplayName(), baseFillColorScheme.getDisplayName(), baseMarkColorScheme.getDisplayName(), baseBorderColorScheme.getDisplayName(), Float.valueOf(visibility), isCheckMarkFadingOut, Float.valueOf(alpha));
        ImageWrapperIcon iconBase = iconMap.get(keyBase);
        if (iconBase == null) {
            iconBase = new ImageWrapperIcon(SubstanceImageCreator.getCheckBox(this.menuItem, fillPainter, borderPainter, checkMarkSize, currState, baseFillColorScheme, baseMarkColorScheme, baseBorderColorScheme, visibility, isCheckMarkFadingOut, alpha));
            iconMap.put(keyBase, iconBase);
        }
        if (currState.isDisabled() || activeStates.size() == 1) {
            return iconBase;
        }
        BufferedImage result = SubstanceCoreUtilities.getBlankImage(iconBase.getIconWidth(), iconBase.getIconHeight());
        Graphics2D g2d = result.createGraphics();
        iconBase.paintIcon(this.menuItem, g2d, 0, 0);
        for (Map.Entry<ComponentState, StateTransitionTracker.StateContributionInfo> activeEntry : activeStates.entrySet()) {
            float stateContribution;
            ComponentState activeState = activeEntry.getKey();
            if (activeState == currState || !((stateContribution = activeEntry.getValue().getContribution()) > 0.0f)) continue;
            g2d.setComposite(AlphaComposite.SrcOver.derive(stateContribution));
            SubstanceColorScheme fillColorScheme = SubstanceColorSchemeUtilities.getColorScheme(this.menuItem, SubstanceSlices.ColorSchemeAssociationKind.MARK_BOX, activeState);
            SubstanceColorScheme markColorScheme = SubstanceColorSchemeUtilities.getColorScheme(this.menuItem, SubstanceSlices.ColorSchemeAssociationKind.MARK, activeState);
            SubstanceColorScheme borderColorScheme = SubstanceColorSchemeUtilities.getColorScheme(this.menuItem, SubstanceSlices.ColorSchemeAssociationKind.BORDER, activeState);
            HashMapKey keyLayer = SubstanceCoreUtilities.getHashKey(fontSize, checkMarkSize, fillPainter.getDisplayName(), borderPainter.getDisplayName(), fillColorScheme.getDisplayName(), markColorScheme.getDisplayName(), borderColorScheme.getDisplayName(), Float.valueOf(visibility), Float.valueOf(alpha));
            ImageWrapperIcon iconLayer = iconMap.get(keyLayer);
            if (iconLayer == null) {
                iconLayer = new ImageWrapperIcon(SubstanceImageCreator.getCheckBox(this.menuItem, fillPainter, borderPainter, checkMarkSize, currState, fillColorScheme, markColorScheme, borderColorScheme, visibility, isCheckMarkFadingOut, alpha));
                iconMap.put(keyLayer, iconLayer);
            }
            iconLayer.paintIcon(this.menuItem, g2d, 0, 0);
        }
        g2d.dispose();
        return new ImageWrapperIcon(result);
    }

    @Override
    public void paintIcon(Component c2, Graphics g2, int x2, int y2) {
        ImageWrapperIcon iconToDraw = this.getIconToPaint();
        if (iconToDraw != null) {
            iconToDraw.paintIcon(c2, g2, x2, y2);
        }
    }

    @Override
    public int getIconWidth() {
        ImageWrapperIcon iconToDraw = this.getIconToPaint();
        return iconToDraw == null ? 0 : iconToDraw.getIconWidth();
    }

    @Override
    public int getIconHeight() {
        ImageWrapperIcon iconToDraw = this.getIconToPaint();
        return iconToDraw == null ? 0 : iconToDraw.getIconHeight();
    }
}

