/*
 * Decompiled with CFR 0.152.
 */
package org.pushingpixels.substance.internal.utils.filters;

import java.awt.Color;
import java.awt.image.BufferedImage;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Map;
import java.util.TreeMap;
import org.pushingpixels.neon.api.filter.NeonAbstractFilter;
import org.pushingpixels.substance.api.colorscheme.SubstanceColorScheme;
import org.pushingpixels.substance.internal.utils.HashMapKey;
import org.pushingpixels.substance.internal.utils.LazyResettableHashMap;
import org.pushingpixels.substance.internal.utils.SubstanceColorUtilities;
import org.pushingpixels.substance.internal.utils.SubstanceCoreUtilities;

public class ColorSchemeFilter
extends NeonAbstractFilter {
    private int[] interpolated;
    private static final int MAPSTEPS = 512;
    private static final LazyResettableHashMap<ColorSchemeFilter> filters = new LazyResettableHashMap("ColorSchemeFilter");
    private float originalBrightnessFactor;
    private float alpha;

    public static ColorSchemeFilter getColorSchemeFilter(SubstanceColorScheme scheme, float originalBrightnessFactor, float alpha) {
        HashMapKey key = SubstanceCoreUtilities.getHashKey(scheme.getDisplayName(), Float.valueOf(originalBrightnessFactor), Float.valueOf(alpha));
        ColorSchemeFilter filter = filters.get(key);
        if (filter == null) {
            filter = new ColorSchemeFilter(scheme, originalBrightnessFactor, alpha);
        }
        return filter;
    }

    private ColorSchemeFilter(SubstanceColorScheme scheme, float originalBrightnessFactor, float alpha) {
        if (scheme == null) {
            throw new IllegalArgumentException("mixColor cannot be null");
        }
        this.originalBrightnessFactor = originalBrightnessFactor;
        this.alpha = alpha;
        TreeMap<Integer, Color> schemeColorMapping = new TreeMap<Integer, Color>();
        int ultraLight = scheme.getUltraLightColor().getRGB();
        int extraLight = scheme.getExtraLightColor().getRGB();
        int light = scheme.getLightColor().getRGB();
        int mid = scheme.getMidColor().getRGB();
        int dark = scheme.getDarkColor().getRGB();
        int ultraDark = scheme.getUltraDarkColor().getRGB();
        if (ultraLight == extraLight && ultraLight == light && ultraLight == mid && ultraLight == dark && ultraLight == ultraDark) {
            Color lighter = SubstanceColorUtilities.deriveByBrightness(scheme.getLightColor(), 0.2f);
            Color darker = SubstanceColorUtilities.deriveByBrightness(scheme.getLightColor(), -0.2f);
            schemeColorMapping.put(SubstanceColorUtilities.getColorBrightness(lighter.getRGB()), lighter);
            schemeColorMapping.put(SubstanceColorUtilities.getColorBrightness(light), scheme.getLightColor());
            schemeColorMapping.put(SubstanceColorUtilities.getColorBrightness(darker.getRGB()), darker);
        } else {
            schemeColorMapping.put(SubstanceColorUtilities.getColorBrightness(ultraLight), scheme.getUltraLightColor());
            schemeColorMapping.put(SubstanceColorUtilities.getColorBrightness(extraLight), scheme.getExtraLightColor());
            schemeColorMapping.put(SubstanceColorUtilities.getColorBrightness(light), scheme.getLightColor());
            schemeColorMapping.put(SubstanceColorUtilities.getColorBrightness(mid), scheme.getMidColor());
            schemeColorMapping.put(SubstanceColorUtilities.getColorBrightness(dark), scheme.getDarkColor());
            schemeColorMapping.put(SubstanceColorUtilities.getColorBrightness(ultraDark), scheme.getUltraDarkColor());
        }
        ArrayList schemeBrightness = new ArrayList(schemeColorMapping.keySet());
        Collections.sort(schemeBrightness);
        int lowestSchemeBrightness = (Integer)schemeBrightness.get(0);
        int highestSchemeBrightness = (Integer)schemeBrightness.get(schemeBrightness.size() - 1);
        boolean hasSameBrightness = highestSchemeBrightness == lowestSchemeBrightness;
        TreeMap stretchedColorMapping = new TreeMap();
        for (Map.Entry entry : schemeColorMapping.entrySet()) {
            int brightness = (Integer)entry.getKey();
            int stretched = hasSameBrightness ? brightness : 255 - 255 * (highestSchemeBrightness - brightness) / (highestSchemeBrightness - lowestSchemeBrightness);
            stretchedColorMapping.put(stretched, entry.getValue());
        }
        schemeBrightness = new ArrayList(stretchedColorMapping.keySet());
        Collections.sort(schemeBrightness);
        this.interpolated = new int[512];
        block1: for (int i2 = 0; i2 < 512; ++i2) {
            int brightness = (int)(256.0 * (double)i2 / 512.0);
            if (schemeBrightness.contains(brightness)) {
                this.interpolated[i2] = ((Color)stretchedColorMapping.get(brightness)).getRGB();
                continue;
            }
            if (hasSameBrightness) {
                this.interpolated[i2] = ((Color)stretchedColorMapping.get(lowestSchemeBrightness)).getRGB();
                continue;
            }
            int currIndex = 0;
            while (true) {
                int currStopValue = (Integer)schemeBrightness.get(currIndex);
                int nextStopValue = (Integer)schemeBrightness.get(currIndex + 1);
                if (brightness > currStopValue && brightness < nextStopValue) {
                    Color currStopColor = (Color)stretchedColorMapping.get(currStopValue);
                    Color nextStopColor = (Color)stretchedColorMapping.get(nextStopValue);
                    this.interpolated[i2] = SubstanceColorUtilities.getInterpolatedRGB(currStopColor, nextStopColor, 1.0 - (double)(brightness - currStopValue) / (double)(nextStopValue - currStopValue));
                    continue block1;
                }
                ++currIndex;
            }
        }
    }

    @Override
    public BufferedImage filter(BufferedImage src, BufferedImage dst) {
        if (dst == null) {
            dst = this.createCompatibleDestImage(src, null);
        }
        int width = src.getWidth();
        int height = src.getHeight();
        int[] pixels = new int[width * height];
        this.getPixels(src, 0, 0, width, height, pixels);
        this.mixColor(pixels);
        this.setPixels(dst, 0, 0, width, height, pixels);
        return dst;
    }

    private void mixColor(int[] pixels) {
        for (int i2 = 0; i2 < pixels.length; ++i2) {
            int argb = pixels[i2];
            int brightness = SubstanceColorUtilities.getColorBrightness(argb);
            int a2 = argb >>> 24 & 0xFF;
            int r2 = argb >>> 16 & 0xFF;
            int g2 = argb >>> 8 & 0xFF;
            int b2 = argb >>> 0 & 0xFF;
            float[] hsb = Color.RGBtoHSB(r2, g2, b2, null);
            int pixelColor = this.interpolated[brightness * 512 / 256];
            int ri2 = pixelColor >>> 16 & 0xFF;
            int gi2 = pixelColor >>> 8 & 0xFF;
            int bi2 = pixelColor >>> 0 & 0xFF;
            float[] hsbi = Color.RGBtoHSB(ri2, gi2, bi2, null);
            hsb[0] = hsbi[0];
            hsb[1] = hsbi[1];
            hsb[2] = this.originalBrightnessFactor >= 0.0f ? this.originalBrightnessFactor * hsb[2] + (1.0f - this.originalBrightnessFactor) * hsbi[2] : hsb[2] * hsbi[2] * (1.0f + this.originalBrightnessFactor);
            int result = Color.HSBtoRGB(hsb[0], hsb[1], hsb[2]);
            int finalAlpha = (int)((float)a2 * this.alpha);
            pixels[i2] = finalAlpha << 24 | (result >> 16 & 0xFF) << 16 | (result >> 8 & 0xFF) << 8 | result & 0xFF;
        }
    }
}

