/*
 * Decompiled with CFR 0.152.
 */
package org.pushingpixels.substance.internal.utils.filters;

import java.awt.image.BufferedImage;
import org.pushingpixels.neon.api.filter.NeonAbstractFilter;

public class AlphaFilter
extends NeonAbstractFilter {
    private double alpha;

    public AlphaFilter(double alpha) {
        if (alpha < 0.0 || alpha > 1.0) {
            throw new IllegalArgumentException("Alpha must be in 0.0-1.0 range");
        }
        this.alpha = alpha;
    }

    @Override
    public BufferedImage filter(BufferedImage src, BufferedImage dst) {
        if (dst == null) {
            dst = this.createCompatibleDestImage(src, null);
        }
        int width = src.getWidth();
        int height = src.getHeight();
        int[] pixels = new int[width * height];
        this.getPixels(src, 0, 0, width, height, pixels);
        this.translucentColor(pixels);
        this.setPixels(dst, 0, 0, width, height, pixels);
        return dst;
    }

    private void translucentColor(int[] pixels) {
        for (int i2 = 0; i2 < pixels.length; ++i2) {
            int argb = pixels[i2];
            int transp = (int)(this.alpha * (double)(argb >>> 24 & 0xFF));
            int r2 = argb >>> 16 & 0xFF;
            int g2 = argb >>> 8 & 0xFF;
            int b2 = argb >>> 0 & 0xFF;
            pixels[i2] = transp << 24 | r2 << 16 | g2 << 8 | b2;
        }
    }
}

