/*
 * Decompiled with CFR 0.152.
 */
package org.pushingpixels.substance.internal.utils.border;

import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.RenderingHints;
import java.awt.geom.Rectangle2D;
import javax.swing.border.Border;
import javax.swing.plaf.UIResource;
import org.pushingpixels.substance.api.ComponentState;
import org.pushingpixels.substance.api.SubstanceSlices;
import org.pushingpixels.substance.api.colorscheme.SubstanceColorScheme;
import org.pushingpixels.substance.api.painter.border.SubstanceBorderPainter;
import org.pushingpixels.substance.internal.utils.SubstanceColorSchemeUtilities;
import org.pushingpixels.substance.internal.utils.SubstanceCoreUtilities;
import org.pushingpixels.substance.internal.utils.SubstanceSizeUtils;

public class SubstancePopupMenuBorder
implements Border,
UIResource {
    @Override
    public void paintBorder(Component c2, Graphics g2, int x2, int y2, int width, int height) {
        SubstanceColorScheme borderScheme = SubstanceColorSchemeUtilities.getColorScheme(c2, SubstanceSlices.ColorSchemeAssociationKind.BORDER, ComponentState.ENABLED);
        Graphics2D g2d = (Graphics2D)g2.create();
        float borderThickness = SubstanceSizeUtils.getBorderStrokeWidth();
        float borderDelta = borderThickness / 2.0f;
        g2d.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        g2d.setRenderingHint(RenderingHints.KEY_STROKE_CONTROL, RenderingHints.VALUE_STROKE_PURE);
        g2d.setStroke(new BasicStroke(borderThickness, 0, 1));
        g2d.translate(x2, y2);
        SubstanceBorderPainter borderPainter = SubstanceCoreUtilities.getBorderPainter(c2);
        Color outline = borderPainter.getRepresentativeColor(borderScheme);
        g2d.setColor(outline);
        g2d.draw(new Rectangle2D.Float(borderDelta, borderDelta, (float)width - borderThickness, (float)height - borderThickness));
        g2d.dispose();
    }

    @Override
    public Insets getBorderInsets(Component c2) {
        return new Insets(1, 1, 1, 1);
    }

    @Override
    public boolean isBorderOpaque() {
        return false;
    }
}

