/*
 * Decompiled with CFR 0.152.
 */
package org.pushingpixels.substance.internal.utils.border;

import java.awt.BasicStroke;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Insets;
import javax.swing.JComponent;
import javax.swing.SwingUtilities;
import javax.swing.border.AbstractBorder;
import javax.swing.plaf.UIResource;
import org.pushingpixels.neon.api.NeonCortex;
import org.pushingpixels.substance.api.ComponentState;
import org.pushingpixels.substance.api.SubstanceSkin;
import org.pushingpixels.substance.api.SubstanceSlices;
import org.pushingpixels.substance.api.colorscheme.SubstanceColorScheme;
import org.pushingpixels.substance.internal.utils.SubstanceCoreUtilities;

public class SubstancePaneBorder
extends AbstractBorder
implements UIResource {
    private static final int BORDER_THICKNESS = 4;
    private static final Insets INSETS = new Insets(4, 4, 4, 4);

    @Override
    public void paintBorder(Component c2, Graphics g2, int x2, int y2, int w2, int h2) {
        SubstanceSkin skin = SubstanceCoreUtilities.getSkin(c2);
        if (skin == null) {
            return;
        }
        SubstanceColorScheme scheme = skin.getBackgroundColorScheme(SubstanceSlices.DecorationAreaType.PRIMARY_TITLE_PANE);
        JComponent titlePaneComp = SubstanceCoreUtilities.getTitlePaneComponent(SwingUtilities.windowForComponent(c2));
        SubstanceColorScheme borderScheme = skin.getColorScheme(titlePaneComp, SubstanceSlices.ColorSchemeAssociationKind.BORDER, ComponentState.ENABLED);
        Graphics2D graphics = (Graphics2D)g2.create();
        double scaleFactor = NeonCortex.getScaleFactor();
        float strokeWidth = scaleFactor <= 2.0 ? 0.5f + (float)scaleFactor / 2.0f : (float)scaleFactor;
        graphics.setStroke(new BasicStroke(strokeWidth, 2, 0));
        graphics.setColor(borderScheme.getUltraDarkColor());
        graphics.drawLine(x2, y2 + h2 - 1, x2 + w2 - 1, y2 + h2 - 1);
        graphics.drawLine(x2 + w2 - 1, y2, x2 + w2 - 1, y2 + h2 - 1);
        graphics.setColor(borderScheme.getDarkColor());
        graphics.drawLine(x2, y2, x2 + w2 - 2, y2);
        graphics.drawLine(x2, y2, x2, y2 + h2 - 2);
        graphics.setColor(scheme.getMidColor());
        graphics.drawLine(x2 + 1, y2 + h2 - 2, x2 + w2 - 2, y2 + h2 - 2);
        graphics.drawLine(x2 + w2 - 2, y2 + 1, x2 + w2 - 2, y2 + h2 - 2);
        graphics.setColor(scheme.getMidColor());
        graphics.drawLine(x2 + 1, y2 + 1, x2 + w2 - 3, y2 + 1);
        graphics.drawLine(x2 + 1, y2 + 1, x2 + 1, y2 + h2 - 3);
        graphics.setColor(scheme.getLightColor());
        graphics.drawRect(x2 + 2, y2 + 2, w2 - 5, h2 - 5);
        graphics.drawRect(x2 + 3, y2 + 3, w2 - 7, h2 - 7);
        graphics.dispose();
    }

    @Override
    public Insets getBorderInsets(Component c2) {
        return INSETS;
    }

    @Override
    public Insets getBorderInsets(Component c2, Insets newInsets) {
        newInsets.top = SubstancePaneBorder.INSETS.top;
        newInsets.left = SubstancePaneBorder.INSETS.left;
        newInsets.bottom = SubstancePaneBorder.INSETS.bottom;
        newInsets.right = SubstancePaneBorder.INSETS.right;
        return newInsets;
    }

    @Override
    public boolean isBorderOpaque() {
        return false;
    }
}

