/*
 * Decompiled with CFR 0.152.
 */
package org.pushingpixels.substance.internal.utils.border;

import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.RenderingHints;
import java.awt.geom.Line2D;
import java.awt.geom.Rectangle2D;
import javax.swing.border.Border;
import org.pushingpixels.neon.api.NeonCortex;
import org.pushingpixels.substance.api.ComponentState;
import org.pushingpixels.substance.api.SubstanceSlices;
import org.pushingpixels.substance.api.colorscheme.SubstanceColorScheme;
import org.pushingpixels.substance.internal.utils.SubstanceColorSchemeUtilities;
import org.pushingpixels.substance.internal.utils.SubstanceSizeUtils;

public class SubstanceEtchedBorder
implements Border {
    public Color getHighlightColor(Component c2) {
        SubstanceColorScheme colorScheme = SubstanceColorSchemeUtilities.getColorScheme(c2, SubstanceSlices.ColorSchemeAssociationKind.SEPARATOR, ComponentState.ENABLED);
        return colorScheme.getSeparatorPrimaryColor();
    }

    public Color getShadowColor(Component c2) {
        SubstanceColorScheme colorScheme = SubstanceColorSchemeUtilities.getColorScheme(c2, SubstanceSlices.ColorSchemeAssociationKind.SEPARATOR, ComponentState.ENABLED);
        return colorScheme.getSeparatorSecondaryColor();
    }

    @Override
    public boolean isBorderOpaque() {
        return false;
    }

    @Override
    public void paintBorder(Component c2, Graphics g2, int x2, int y2, int width, int height) {
        int w2 = width;
        int h2 = height;
        Graphics2D g2d = (Graphics2D)g2.create();
        float strokeWidth = SubstanceSizeUtils.getBorderStrokeWidth();
        g2d.setStroke(new BasicStroke(strokeWidth, 0, 1));
        g2d.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        g2d.setRenderingHint(RenderingHints.KEY_STROKE_CONTROL, RenderingHints.VALUE_STROKE_PURE);
        g2d.translate(x2, y2);
        g2d.setColor(this.getShadowColor(c2));
        float delta = strokeWidth / 2.0f;
        g2d.draw(new Rectangle2D.Float(delta, delta, (float)w2 - delta - 2.0f * strokeWidth, (float)h2 - delta - 2.0f * strokeWidth));
        g2d.setColor(this.getHighlightColor(c2));
        g2d.draw(new Line2D.Float(strokeWidth, (float)h2 - 3.0f * strokeWidth, strokeWidth, strokeWidth));
        g2d.draw(new Line2D.Float(delta + strokeWidth, delta + strokeWidth, (float)w2 - delta - 3.0f * strokeWidth, delta + strokeWidth));
        g2d.draw(new Line2D.Float(delta, (float)h2 - delta - strokeWidth, (float)w2 - delta - strokeWidth, (float)h2 - delta - strokeWidth));
        g2d.draw(new Line2D.Float((float)w2 - delta - strokeWidth, (float)h2 - delta - strokeWidth, (float)w2 - delta - strokeWidth, delta));
        g2d.dispose();
        NeonCortex.installDesktopHints((Graphics2D)g2, c2.getFont());
    }

    @Override
    public Insets getBorderInsets(Component c2) {
        float borderStrokeWidth = SubstanceSizeUtils.getBorderStrokeWidth();
        int prefSize = (int)Math.ceil(2.0 * (double)borderStrokeWidth);
        return new Insets(prefSize, prefSize, prefSize, prefSize);
    }
}

