/*
 * Decompiled with CFR 0.152.
 */
package org.pushingpixels.substance.internal.utils;

import java.awt.AlphaComposite;
import java.awt.Component;
import java.awt.Composite;
import java.awt.Container;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.Map;
import javax.swing.AbstractButton;
import javax.swing.ButtonModel;
import javax.swing.CellRendererPane;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JMenuItem;
import javax.swing.JPasswordField;
import javax.swing.JScrollPane;
import javax.swing.JTree;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.text.JTextComponent;
import org.pushingpixels.substance.api.SubstanceSlices;
import org.pushingpixels.substance.api.painter.preview.PreviewPainter;
import org.pushingpixels.substance.api.password.PasswordStrengthChecker;
import org.pushingpixels.substance.internal.AnimationConfigurationManager;

public class WidgetUtilities {
    public static final String PREVIEW_MODE = "substance.widget.internal.previewMode";

    private WidgetUtilities() {
    }

    public static void makePreviewable(Component comp, Map<Component, Boolean> dbSnapshot) {
        if (comp instanceof JComponent) {
            JComponent jcomp = (JComponent)comp;
            dbSnapshot.put(jcomp, jcomp.isDoubleBuffered());
            jcomp.setDoubleBuffered(false);
            jcomp.putClientProperty(PREVIEW_MODE, Boolean.TRUE);
        }
        if (comp instanceof Container) {
            Container cont = (Container)comp;
            for (int i2 = 0; i2 < cont.getComponentCount(); ++i2) {
                WidgetUtilities.makePreviewable(cont.getComponent(i2), dbSnapshot);
            }
        }
    }

    public static void restorePreviewable(Component comp, Map<Component, Boolean> dbSnapshot) {
        if (comp instanceof JComponent) {
            JComponent jcomp = (JComponent)comp;
            if (dbSnapshot.containsKey(comp)) {
                jcomp.setDoubleBuffered(dbSnapshot.get(comp));
                jcomp.putClientProperty(PREVIEW_MODE, null);
            } else {
                Container parent = comp.getParent();
                if (parent instanceof JComponent) {
                    jcomp.setDoubleBuffered(dbSnapshot.get(parent));
                    jcomp.putClientProperty(PREVIEW_MODE, null);
                }
            }
        }
        if (comp instanceof Container) {
            Container cont = (Container)comp;
            for (int i2 = 0; i2 < cont.getComponentCount(); ++i2) {
                WidgetUtilities.restorePreviewable(cont.getComponent(i2), dbSnapshot);
            }
        }
    }

    public static boolean hasTextFocusSelectAllProperty(JTextComponent textComp) {
        for (Container comp = textComp; comp != null; comp = comp.getParent()) {
            if (!(comp instanceof JComponent)) continue;
            Object textFocusSelectAllProperty = ((JComponent)comp).getClientProperty("substancelaf.internal.widget.textSelectAllOnFocus");
            if (Boolean.TRUE.equals(textFocusSelectAllProperty)) {
                return true;
            }
            if (!Boolean.FALSE.equals(textFocusSelectAllProperty)) continue;
            return false;
        }
        return Boolean.TRUE.equals(UIManager.get("substancelaf.internal.widget.textSelectAllOnFocus"));
    }

    public static boolean hasTextFlipSelectOnEscapeProperty(JTextComponent textComp) {
        Object textFocusSelectAllProperty = textComp.getClientProperty("substancelaf.internal.widget.textFlipSelectOnEscape");
        return Boolean.TRUE.equals(textFocusSelectAllProperty);
    }

    public static boolean hasTextEditContextMenu(JTextComponent textComp) {
        Object textEditContextMenuProperty = textComp.getClientProperty("substancelaf.internal.widget.textEditContextMenu");
        if (Boolean.TRUE.equals(textEditContextMenuProperty)) {
            return true;
        }
        if (Boolean.FALSE.equals(textEditContextMenuProperty)) {
            return false;
        }
        return Boolean.TRUE.equals(UIManager.get("substancelaf.internal.widget.textEditContextMenu"));
    }

    public static boolean hasAutoScroll(JScrollPane scrollPane) {
        Object compProperty = scrollPane.getClientProperty("substancelaf.internal.widget.autoScroll");
        if (Boolean.TRUE.equals(compProperty)) {
            return true;
        }
        if (Boolean.FALSE.equals(compProperty)) {
            return false;
        }
        return Boolean.TRUE.equals(UIManager.get("substancelaf.internal.widget.autoScroll"));
    }

    public static boolean hasAutomaticDnDSupport(JTree tree) {
        Object dndProperty = tree.getClientProperty("substancelaf.internal.widget.treeAutoDnDSupport");
        if (Boolean.TRUE.equals(dndProperty)) {
            return true;
        }
        if (Boolean.FALSE.equals(dndProperty)) {
            return false;
        }
        return Boolean.TRUE.equals(UIManager.get("substancelaf.internal.widget.treeAutoDnDSupport"));
    }

    public static boolean hasNoAnimations(Component comp, SubstanceSlices.AnimationFacet animationFacet) {
        return !AnimationConfigurationManager.getInstance().isAnimationAllowed(animationFacet, comp);
    }

    public static Icon getIcon(AbstractButton b2) {
        Icon icon = b2.getIcon();
        if (icon == null) {
            return null;
        }
        ButtonModel model = b2.getModel();
        Icon tmpIcon = null;
        if (icon != null) {
            if (!model.isEnabled()) {
                tmpIcon = model.isSelected() ? b2.getDisabledSelectedIcon() : b2.getDisabledIcon();
            } else if (model.isPressed() && model.isArmed()) {
                tmpIcon = b2.getPressedIcon();
            } else if (b2.isRolloverEnabled() && model.isRollover()) {
                tmpIcon = model.isSelected() ? b2.getRolloverSelectedIcon() : b2.getRolloverIcon();
            } else if (model.isSelected()) {
                tmpIcon = b2.getSelectedIcon();
            }
            if (tmpIcon != null) {
                icon = tmpIcon;
            }
        }
        return icon;
    }

    public static boolean toIgnoreAnimations(Component comp) {
        if (comp instanceof JMenuItem) {
            return false;
        }
        return SwingUtilities.getAncestorOfClass(CellRendererPane.class, comp) != null;
    }

    public static void firePropertyChangeEvent(JComponent component, String propertyName, Object oldValue, Object newValue) {
        PropertyChangeEvent pce = new PropertyChangeEvent(component, propertyName, oldValue, newValue);
        for (PropertyChangeListener general : component.getPropertyChangeListeners()) {
            general.propertyChange(pce);
        }
        for (PropertyChangeListener specific : component.getPropertyChangeListeners(propertyName)) {
            specific.propertyChange(pce);
        }
    }

    public static Composite getAlphaComposite(Component c2, float translucency, Graphics g2) {
        float finalAlpha;
        AlphaComposite ac2;
        Graphics2D g2d;
        Composite existingComposite;
        float xFactor = 1.0f;
        if (g2 instanceof Graphics2D && (existingComposite = (g2d = (Graphics2D)g2).getComposite()) instanceof AlphaComposite && (ac2 = (AlphaComposite)existingComposite).getRule() == 3) {
            xFactor = ac2.getAlpha();
        }
        if ((finalAlpha = translucency * xFactor) < 0.0f) {
            finalAlpha = 0.0f;
        }
        if (finalAlpha > 1.0f) {
            finalAlpha = 1.0f;
        }
        if (finalAlpha == 1.0f) {
            return AlphaComposite.SrcOver;
        }
        return AlphaComposite.SrcOver.derive(finalAlpha);
    }

    public static Composite getAlphaComposite(Component c2, float translucency) {
        return WidgetUtilities.getAlphaComposite(c2, translucency, null);
    }

    public static Composite getAlphaComposite(Component c2, Graphics g2) {
        return WidgetUtilities.getAlphaComposite(c2, 1.0f, g2);
    }

    public static Composite getAlphaComposite(Component c2) {
        return WidgetUtilities.getAlphaComposite(c2, 1.0f, null);
    }

    public static PreviewPainter getComponentPreviewPainter(Component comp) {
        Object parentProp;
        Object compProp;
        if (comp == null) {
            return null;
        }
        if (comp instanceof JComponent && (compProp = ((JComponent)comp).getClientProperty("substancelaf.internal.widget.componentPreviewPainter")) instanceof PreviewPainter) {
            return (PreviewPainter)compProp;
        }
        Container parent = comp.getParent();
        if (parent instanceof JComponent && (parentProp = ((JComponent)parent).getClientProperty("substancelaf.internal.widget.componentPreviewPainter")) instanceof PreviewPainter) {
            return (PreviewPainter)parentProp;
        }
        Object globProp = UIManager.get("substancelaf.internal.widget.componentPreviewPainter");
        if (globProp instanceof PreviewPainter) {
            return (PreviewPainter)globProp;
        }
        return null;
    }

    public static PasswordStrengthChecker getPasswordStrengthChecker(JPasswordField jpf) {
        Object obj = jpf.getClientProperty("substancelaf.internal.widget.passwordStrengthChecker");
        if (obj instanceof PasswordStrengthChecker) {
            return (PasswordStrengthChecker)obj;
        }
        return null;
    }
}

