/*
 * Decompiled with CFR 0.152.
 */
package org.pushingpixels.substance.internal.utils;

import java.awt.Component;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.util.EnumSet;
import javax.swing.JButton;
import javax.swing.JSpinner;
import javax.swing.border.Border;
import org.pushingpixels.substance.api.SubstanceCortex;
import org.pushingpixels.substance.api.SubstanceSlices;
import org.pushingpixels.substance.api.shaper.ClassicButtonShaper;
import org.pushingpixels.substance.internal.AnimationConfigurationManager;
import org.pushingpixels.substance.internal.utils.SubstanceCoreUtilities;
import org.pushingpixels.substance.internal.utils.SubstanceInternalArrowButton;
import org.pushingpixels.substance.internal.utils.SubstanceInternalButton;
import org.pushingpixels.substance.internal.utils.SubstanceSizeUtils;
import org.pushingpixels.substance.internal.utils.border.SubstanceButtonBorder;

@SubstanceInternalButton
@SubstanceInternalArrowButton
public class SubstanceSpinnerButton
extends JButton {
    public SubstanceSpinnerButton(JSpinner spinner, final int orientation) {
        this.setEnabled(spinner.isEnabled());
        this.setFocusable(false);
        this.setRequestFocusEnabled(false);
        super.setBorder(new SpinnerButtonBorder(ClassicButtonShaper.class){

            @Override
            public Insets getBorderInsets(Component c2) {
                int extraPadding = SubstanceSizeUtils.getExtraPadding(SubstanceSizeUtils.getComponentFontSize(c2));
                int delta = SubstanceSizeUtils.getAdjustedSize(SubstanceSizeUtils.getComponentFontSize(c2), 3, 3, 1, false);
                int deltaTop = orientation == 1 ? delta : 0;
                int deltaBottom = orientation == 1 ? 0 : delta;
                return new Insets(extraPadding + deltaTop, extraPadding, extraPadding + deltaBottom, extraPadding);
            }
        });
        SubstanceCoreUtilities.markButtonAsFlat(this);
        SubstanceCortex.ComponentScope.setButtonStraightSides(this, EnumSet.allOf(SubstanceSlices.Side.class));
    }

    @Override
    public void setBorder(Border border) {
    }

    @Override
    public boolean isFocusable() {
        return false;
    }

    @Override
    public void paint(Graphics g2) {
        Graphics2D g2d = (Graphics2D)g2.create();
        int width = this.getWidth();
        int height = this.getHeight();
        int clipDelta = (int)SubstanceSizeUtils.getBorderStrokeWidth();
        if (this.getComponentOrientation().isLeftToRight()) {
            g2d.clipRect(clipDelta, 0, width - clipDelta, height);
        } else {
            g2d.clipRect(0, 0, width - clipDelta, height);
        }
        super.paint(g2d);
        g2d.dispose();
    }

    static {
        AnimationConfigurationManager.getInstance().disallowAnimations(SubstanceSlices.AnimationFacet.GHOSTING_BUTTON_PRESS, SubstanceSpinnerButton.class);
        AnimationConfigurationManager.getInstance().disallowAnimations(SubstanceSlices.AnimationFacet.GHOSTING_ICON_ROLLOVER, SubstanceSpinnerButton.class);
    }

    private static abstract class SpinnerButtonBorder
    extends SubstanceButtonBorder {
        public SpinnerButtonBorder(Class<?> buttonShaperClass) {
            super(buttonShaperClass);
        }
    }
}

