/*
 * Decompiled with CFR 0.152.
 */
package org.pushingpixels.substance.internal.utils;

public class PerlinNoiseGenerator {
    static final int[] p = new int[512];
    static final int[] permutation = new int[]{151, 160, 137, 91, 90, 15, 131, 13, 201, 95, 96, 53, 194, 233, 7, 225, 140, 36, 103, 30, 69, 142, 8, 99, 37, 240, 21, 10, 23, 190, 6, 148, 247, 120, 234, 75, 0, 26, 197, 62, 94, 252, 219, 203, 117, 35, 11, 32, 57, 177, 33, 88, 237, 149, 56, 87, 174, 20, 125, 136, 171, 168, 68, 175, 74, 165, 71, 134, 139, 48, 27, 166, 77, 146, 158, 231, 83, 111, 229, 122, 60, 211, 133, 230, 220, 105, 92, 41, 55, 46, 245, 40, 244, 102, 143, 54, 65, 25, 63, 161, 1, 216, 80, 73, 209, 76, 132, 187, 208, 89, 18, 169, 200, 196, 135, 130, 116, 188, 159, 86, 164, 100, 109, 198, 173, 186, 3, 64, 52, 217, 226, 250, 124, 123, 5, 202, 38, 147, 118, 126, 255, 82, 85, 212, 207, 206, 59, 227, 47, 16, 58, 17, 182, 189, 28, 42, 223, 183, 170, 213, 119, 248, 152, 2, 44, 154, 163, 70, 221, 153, 101, 155, 167, 43, 172, 9, 129, 22, 39, 253, 19, 98, 108, 110, 79, 113, 224, 232, 178, 185, 112, 104, 218, 246, 97, 228, 251, 34, 242, 193, 238, 210, 144, 12, 191, 179, 162, 241, 81, 51, 145, 235, 249, 14, 239, 107, 49, 192, 214, 31, 181, 199, 106, 157, 184, 84, 204, 176, 115, 121, 50, 45, 127, 4, 150, 254, 138, 236, 205, 93, 222, 114, 67, 29, 24, 72, 243, 141, 128, 195, 78, 66, 215, 61, 156, 180};

    public static double noise(double x2, double y2, double z2) {
        int X2 = (int)Math.floor(x2) & 0xFF;
        int Y2 = (int)Math.floor(y2) & 0xFF;
        int Z2 = (int)Math.floor(z2) & 0xFF;
        x2 -= Math.floor(x2);
        y2 -= Math.floor(y2);
        z2 -= Math.floor(z2);
        double u2 = PerlinNoiseGenerator.fade(x2);
        double v2 = PerlinNoiseGenerator.fade(y2);
        double w2 = PerlinNoiseGenerator.fade(z2);
        int A2 = p[X2] + Y2;
        int AA2 = p[A2] + Z2;
        int AB2 = p[A2 + 1] + Z2;
        int B2 = p[X2 + 1] + Y2;
        int BA2 = p[B2] + Z2;
        int BB2 = p[B2 + 1] + Z2;
        return PerlinNoiseGenerator.lerp(w2, PerlinNoiseGenerator.lerp(v2, PerlinNoiseGenerator.lerp(u2, PerlinNoiseGenerator.grad(p[AA2], x2, y2, z2), PerlinNoiseGenerator.grad(p[BA2], x2 - 1.0, y2, z2)), PerlinNoiseGenerator.lerp(u2, PerlinNoiseGenerator.grad(p[AB2], x2, y2 - 1.0, z2), PerlinNoiseGenerator.grad(p[BB2], x2 - 1.0, y2 - 1.0, z2))), PerlinNoiseGenerator.lerp(v2, PerlinNoiseGenerator.lerp(u2, PerlinNoiseGenerator.grad(p[AA2 + 1], x2, y2, z2 - 1.0), PerlinNoiseGenerator.grad(p[BA2 + 1], x2 - 1.0, y2, z2 - 1.0)), PerlinNoiseGenerator.lerp(u2, PerlinNoiseGenerator.grad(p[AB2 + 1], x2, y2 - 1.0, z2 - 1.0), PerlinNoiseGenerator.grad(p[BB2 + 1], x2 - 1.0, y2 - 1.0, z2 - 1.0))));
    }

    static double fade(double t2) {
        return t2 * t2 * t2 * (t2 * (t2 * 6.0 - 15.0) + 10.0);
    }

    static double lerp(double t2, double a2, double b2) {
        return a2 + t2 * (b2 - a2);
    }

    static double grad(int hash, double x2, double y2, double z2) {
        double u2;
        int h2 = hash & 0xF;
        double d2 = u2 = h2 < 8 ? x2 : y2;
        double v2 = h2 < 4 ? y2 : (h2 == 12 || h2 == 14 ? x2 : z2);
        return ((h2 & 1) == 0 ? u2 : -u2) + ((h2 & 2) == 0 ? v2 : -v2);
    }

    static {
        for (int i2 = 0; i2 < 256; ++i2) {
            PerlinNoiseGenerator.p[256 + i2] = PerlinNoiseGenerator.p[i2] = permutation[i2];
        }
    }
}

