/*
 * Decompiled with CFR 0.152.
 */
package org.pushingpixels.substance.internal.utils;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.RenderingHints;
import java.awt.image.BufferedImage;
import javax.swing.plaf.UIResource;
import org.pushingpixels.neon.api.NeonCortex;
import org.pushingpixels.neon.api.icon.ResizableIcon;

public class ImageWrapperIcon
implements ResizableIcon,
UIResource {
    private final double factor;
    private BufferedImage imageSource;
    private int width;
    private int height;

    public ImageWrapperIcon(BufferedImage image) {
        this.imageSource = image;
        this.factor = NeonCortex.getScaleFactor();
        this.width = this.getInternalWidth();
        this.height = this.getInternalHeight();
    }

    @Override
    public void setDimension(Dimension newDimension) {
        this.width = newDimension.width;
        this.height = newDimension.height;
    }

    @Override
    public synchronized void paintIcon(Component c2, Graphics g2, int x2, int y2) {
        Graphics2D g2d = (Graphics2D)g2.create();
        int dx = (this.width - this.getInternalWidth()) / 2;
        int dy = (this.height - this.getInternalHeight()) / 2;
        g2d.translate(x2 + dx, y2 + dy);
        g2d.setRenderingHint(RenderingHints.KEY_INTERPOLATION, RenderingHints.VALUE_INTERPOLATION_BICUBIC);
        g2d.drawImage(this.imageSource, 0, 0, (int)((double)this.imageSource.getWidth() / this.factor), (int)((double)this.imageSource.getHeight() / this.factor), null);
        g2d.dispose();
    }

    private int getInternalWidth() {
        return (int)((double)this.imageSource.getWidth() / this.factor);
    }

    @Override
    public int getIconWidth() {
        return this.width;
    }

    private int getInternalHeight() {
        return (int)((double)this.imageSource.getHeight() / this.factor);
    }

    @Override
    public int getIconHeight() {
        return this.height;
    }
}

