/*
 * Decompiled with CFR 0.152.
 */
package org.pushingpixels.substance.internal.ui;

import java.awt.Color;
import java.awt.Graphics;
import javax.swing.JComponent;
import javax.swing.plaf.ColorUIResource;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.UIResource;
import javax.swing.plaf.basic.BasicViewportUI;
import org.pushingpixels.substance.internal.painter.BackgroundPaintingUtils;
import org.pushingpixels.substance.internal.utils.SubstanceColorUtilities;
import org.pushingpixels.substance.internal.utils.SubstanceCoreUtilities;

public class SubstanceViewportUI
extends BasicViewportUI {
    public static ComponentUI createUI(JComponent comp) {
        SubstanceCoreUtilities.testComponentCreationThreadingViolation(comp);
        return new SubstanceViewportUI();
    }

    private SubstanceViewportUI() {
    }

    @Override
    protected void installDefaults(JComponent c2) {
        Color backgroundFillColor;
        super.installDefaults(c2);
        Color backgr = c2.getBackground();
        if ((backgr == null || backgr instanceof UIResource) && (backgroundFillColor = SubstanceColorUtilities.getBackgroundFillColor(c2)) != null) {
            c2.setBackground(new ColorUIResource(backgroundFillColor));
        }
    }

    @Override
    public void update(Graphics g2, JComponent c2) {
        if (!SubstanceCoreUtilities.isCurrentLookAndFeel()) {
            return;
        }
        if (this.toPaintBackground(c2)) {
            BackgroundPaintingUtils.update(g2, c2, false);
        }
        super.paint(g2, c2);
    }

    private boolean toPaintBackground(JComponent c2) {
        return SubstanceCoreUtilities.isOpaque(c2);
    }
}

