/*
 * Decompiled with CFR 0.152.
 */
package org.pushingpixels.substance.internal.ui;

import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.Rectangle;
import javax.swing.JComponent;
import javax.swing.JToolTip;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.basic.BasicToolTipUI;
import javax.swing.text.View;
import org.pushingpixels.neon.api.NeonCortex;
import org.pushingpixels.substance.internal.utils.SubstanceCoreUtilities;
import org.pushingpixels.substance.internal.utils.SubstanceMetricsUtilities;
import org.pushingpixels.substance.internal.utils.SubstanceTextUtilities;

public class SubstanceToolTipUI
extends BasicToolTipUI {
    public static ComponentUI createUI(JComponent comp) {
        SubstanceCoreUtilities.testComponentCreationThreadingViolation(comp);
        return new SubstanceToolTipUI();
    }

    private SubstanceToolTipUI() {
    }

    @Override
    public void paint(Graphics g2, JComponent c2) {
        Font font = c2.getFont();
        Dimension size = c2.getSize();
        if (c2.isOpaque()) {
            g2.setColor(c2.getBackground());
            g2.fillRect(0, 0, size.width, size.height);
        }
        g2.setColor(c2.getForeground());
        g2.setFont(font);
        String tipText = ((JToolTip)c2).getTipText();
        if (tipText == null) {
            tipText = "";
        }
        Insets insets = c2.getInsets();
        Rectangle paintTextR = new Rectangle(insets.left + 3, insets.top + 1, size.width - (insets.left + insets.right + 6), size.height - (insets.top + insets.bottom + 1));
        View v2 = (View)c2.getClientProperty("html");
        if (v2 != null) {
            v2.paint(g2, paintTextR);
        } else {
            SubstanceTextUtilities.paintText(g2, paintTextR, tipText, -1, font, c2.getForeground(), null);
        }
    }

    @Override
    public Dimension getPreferredSize(JComponent c2) {
        Font font = c2.getFont();
        Insets insets = c2.getInsets();
        Dimension prefSize = new Dimension(insets.left + insets.right, insets.top + insets.bottom);
        String text = ((JToolTip)c2).getTipText();
        if (text == null || text.equals("")) {
            text = "";
        } else {
            View v2;
            View view = v2 = c2 != null ? (View)c2.getClientProperty("html") : null;
            if (v2 != null) {
                prefSize.width += (int)(v2.getPreferredSpan(0) + 6.0f);
                prefSize.height += (int)(v2.getPreferredSpan(1) + 2.0f);
            } else {
                FontMetrics fm = SubstanceMetricsUtilities.getFontMetrics(font);
                prefSize.width += fm.stringWidth(text) + 6;
                prefSize.height += fm.getHeight() + 2;
            }
        }
        return prefSize;
    }

    @Override
    public void update(Graphics g2, JComponent c2) {
        Graphics2D g2d = (Graphics2D)g2.create();
        NeonCortex.installDesktopHints(g2d, c2.getFont());
        super.update(g2d, c2);
        g2d.dispose();
    }
}

