/*
 * Decompiled with CFR 0.152.
 */
package org.pushingpixels.substance.internal.ui;

import java.awt.Component;
import java.awt.Graphics;
import javax.swing.JComponent;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.basic.BasicToolBarUI;
import org.pushingpixels.substance.api.SubstanceCortex;
import org.pushingpixels.substance.api.SubstanceSlices;
import org.pushingpixels.substance.internal.painter.BackgroundPaintingUtils;
import org.pushingpixels.substance.internal.painter.DecorationPainterUtils;
import org.pushingpixels.substance.internal.utils.SubstanceCoreUtilities;
import org.pushingpixels.substance.internal.widget.animation.effects.GhostPaintingUtils;

public class SubstanceToolBarUI
extends BasicToolBarUI {
    public static ComponentUI createUI(JComponent comp) {
        SubstanceCoreUtilities.testComponentCreationThreadingViolation(comp);
        return new SubstanceToolBarUI();
    }

    private SubstanceToolBarUI() {
    }

    @Override
    protected void installDefaults() {
        super.installDefaults();
        SubstanceCortex.ComponentOrParentChainScope.setDecorationType(this.toolBar, SubstanceSlices.DecorationAreaType.TOOLBAR);
    }

    @Override
    protected void uninstallDefaults() {
        DecorationPainterUtils.clearDecorationType(this.toolBar);
        super.uninstallDefaults();
    }

    @Override
    public void update(Graphics g2, JComponent c2) {
        boolean isOpaque = SubstanceCoreUtilities.isOpaque(c2);
        if (isOpaque) {
            BackgroundPaintingUtils.update(g2, c2, false);
        } else {
            super.update(g2, c2);
        }
        GhostPaintingUtils.paintGhostImages(c2, g2);
    }

    @Override
    protected void setBorderToRollover(Component c2) {
    }

    @Override
    protected void setBorderToNonRollover(Component c2) {
    }

    @Override
    protected void setBorderToNormal(Component c2) {
    }
}

