/*
 * Decompiled with CFR 0.152.
 */
package org.pushingpixels.substance.internal.ui;

import java.awt.Container;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import javax.swing.JComponent;
import javax.swing.JPopupMenu;
import javax.swing.JSeparator;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.basic.BasicSeparatorUI;
import org.pushingpixels.substance.internal.painter.SeparatorPainterUtils;
import org.pushingpixels.substance.internal.utils.SubstanceCoreUtilities;
import org.pushingpixels.substance.internal.utils.SubstanceSizeUtils;
import org.pushingpixels.substance.internal.utils.WidgetUtilities;
import org.pushingpixels.substance.internal.utils.menu.MenuUtilities;
import org.pushingpixels.substance.internal.utils.menu.SubstanceMenuBackgroundDelegate;

public class SubstanceSeparatorUI
extends BasicSeparatorUI {
    public static ComponentUI createUI(JComponent comp) {
        SubstanceCoreUtilities.testComponentCreationThreadingViolation(comp);
        return new SubstanceSeparatorUI();
    }

    private SubstanceSeparatorUI() {
    }

    @Override
    public void paint(Graphics g2, JComponent c2) {
        int width;
        int startX;
        Container parent = c2.getParent();
        if (!(parent instanceof JPopupMenu)) {
            SeparatorPainterUtils.paintSeparator(c2, g2, c2.getWidth(), c2.getHeight(), ((JSeparator)c2).getOrientation());
            return;
        }
        Graphics2D graphics = (Graphics2D)g2.create();
        int xOffset = MenuUtilities.getTextOffset(c2, parent);
        SubstanceMenuBackgroundDelegate.paintBackground(graphics, c2, xOffset);
        Dimension s2 = c2.getSize();
        if (parent.getComponentOrientation().isLeftToRight()) {
            startX = xOffset - 2;
            width = s2.width - startX;
        } else {
            startX = 0;
            width = xOffset - 4;
        }
        graphics.translate(startX, 0);
        graphics.setComposite(WidgetUtilities.getAlphaComposite(parent));
        SeparatorPainterUtils.paintSeparator(c2, graphics, width, s2.height, ((JSeparator)c2).getOrientation(), true, 2);
        graphics.dispose();
    }

    @Override
    public Dimension getPreferredSize(JComponent c2) {
        float borderStrokeWidth = SubstanceSizeUtils.getBorderStrokeWidth();
        int prefSize = (int)Math.ceil(2.0 * (double)borderStrokeWidth);
        if (((JSeparator)c2).getOrientation() == 1) {
            return new Dimension(prefSize, 0);
        }
        return new Dimension(0, prefSize);
    }
}

