/*
 * Decompiled with CFR 0.152.
 */
package org.pushingpixels.substance.internal.ui;

import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.LayoutManager;
import java.awt.Point;
import java.awt.Rectangle;
import java.beans.PropertyChangeListener;
import java.util.HashSet;
import java.util.Set;
import javax.swing.JComponent;
import javax.swing.JScrollBar;
import javax.swing.JScrollPane;
import javax.swing.JTree;
import javax.swing.JViewport;
import javax.swing.ScrollPaneLayout;
import javax.swing.SwingUtilities;
import javax.swing.event.ChangeListener;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.TableHeaderUI;
import javax.swing.plaf.UIResource;
import javax.swing.plaf.basic.BasicScrollPaneUI;
import javax.swing.table.JTableHeader;
import org.pushingpixels.substance.api.SubstanceSlices;
import org.pushingpixels.substance.api.SubstanceWidget;
import org.pushingpixels.substance.internal.AnimationConfigurationManager;
import org.pushingpixels.substance.internal.SubstanceWidgetRepository;
import org.pushingpixels.substance.internal.painter.BackgroundPaintingUtils;
import org.pushingpixels.substance.internal.ui.SubstanceTableHeaderUI;
import org.pushingpixels.substance.internal.ui.SubstanceTreeUI;
import org.pushingpixels.substance.internal.utils.SubstanceColorUtilities;
import org.pushingpixels.substance.internal.utils.SubstanceCoreUtilities;
import org.pushingpixels.trident.api.Timeline;
import org.pushingpixels.trident.api.swing.EventDispatchThreadTimelineCallbackAdapter;
import org.pushingpixels.trident.api.swing.SwingComponentTimeline;

public class SubstanceScrollPaneUI
extends BasicScrollPaneUI {
    private PropertyChangeListener substancePropertyChangeListener;
    private ChangeListener substanceVerticalScrollbarChangeListener;
    private Timeline horizontalScrollTimeline;
    private Set<SubstanceWidget<JComponent>> lafWidgets;

    public static ComponentUI createUI(JComponent comp) {
        SubstanceCoreUtilities.testComponentCreationThreadingViolation(comp);
        return new SubstanceScrollPaneUI();
    }

    private SubstanceScrollPaneUI() {
    }

    @Override
    public void installUI(JComponent c2) {
        this.lafWidgets = SubstanceWidgetRepository.getRepository().getMatchingWidgets(c2);
        super.installUI(c2);
        for (SubstanceWidget<JComponent> lafWidget : this.lafWidgets) {
            lafWidget.installUI();
        }
    }

    @Override
    public void uninstallUI(JComponent c2) {
        for (SubstanceWidget<JComponent> lafWidget : this.lafWidgets) {
            lafWidget.uninstallUI();
        }
        super.uninstallUI(c2);
    }

    @Override
    protected void installDefaults(JScrollPane scrollpane) {
        super.installDefaults(scrollpane);
        SwingUtilities.invokeLater(() -> this.installTableHeaderCornerFiller(scrollpane));
        for (SubstanceWidget<JComponent> lafWidget : this.lafWidgets) {
            lafWidget.installDefaults();
        }
    }

    @Override
    protected void uninstallDefaults(JScrollPane c2) {
        Component upperLeft;
        Component upperRight = c2.getCorner("UPPER_RIGHT_CORNER");
        if (upperRight instanceof UIResource) {
            c2.setCorner("UPPER_RIGHT_CORNER", null);
        }
        if ((upperLeft = c2.getCorner("UPPER_LEFT_CORNER")) instanceof UIResource) {
            c2.setCorner("UPPER_LEFT_CORNER", null);
        }
        for (SubstanceWidget<JComponent> lafWidget : this.lafWidgets) {
            lafWidget.uninstallDefaults();
        }
        super.uninstallDefaults(c2);
    }

    @Override
    protected void installListeners(final JScrollPane c2) {
        super.installListeners(c2);
        this.substancePropertyChangeListener = propertyChangeEvent -> {
            Color newBackgr;
            if ("background".equals(propertyChangeEvent.getPropertyName()) && !((newBackgr = (Color)propertyChangeEvent.getNewValue()) instanceof UIResource)) {
                JScrollBar horizontal;
                JScrollBar vertical = this.scrollpane.getVerticalScrollBar();
                if (vertical != null && vertical.getBackground() instanceof UIResource) {
                    vertical.setBackground(newBackgr);
                }
                if ((horizontal = this.scrollpane.getHorizontalScrollBar()) != null && horizontal.getBackground() instanceof UIResource) {
                    horizontal.setBackground(newBackgr);
                }
            }
            if ("columnHeader".equals(propertyChangeEvent.getPropertyName()) || "componentOrientation".equals(propertyChangeEvent.getPropertyName()) || "ancestor".equals(propertyChangeEvent.getPropertyName())) {
                SwingUtilities.invokeLater(() -> {
                    if (this.scrollpane != null) {
                        this.installTableHeaderCornerFiller(this.scrollpane);
                    }
                });
            }
        };
        c2.addPropertyChangeListener(this.substancePropertyChangeListener);
        this.substanceVerticalScrollbarChangeListener = changeEvent -> {
            if (c2.getHorizontalScrollBar() != null && c2.getHorizontalScrollBar().isVisible() && c2.getViewport().getView() instanceof JTree) {
                JTree tree = (JTree)c2.getViewport().getView();
                if (AnimationConfigurationManager.getInstance().isAnimationAllowed(SubstanceSlices.AnimationFacet.TREE_SMART_SCROLL_ANIMATION, tree)) {
                    int finalDelta;
                    int currPivotX;
                    Rectangle viewportRect;
                    SubstanceTreeUI treeUI = (SubstanceTreeUI)tree.getUI();
                    int pivotX = treeUI.getPivotRendererX(viewportRect = c2.getViewport().getViewRect());
                    int delta = pivotX - (currPivotX = viewportRect.x);
                    int finalX = viewportRect.x + delta;
                    if (finalX < 0) {
                        delta -= finalX;
                    }
                    if (Math.abs(finalDelta = delta) > viewportRect.width / 6) {
                        if (this.horizontalScrollTimeline != null) {
                            this.horizontalScrollTimeline.abort();
                        }
                        this.horizontalScrollTimeline = ((SwingComponentTimeline.Builder)((SwingComponentTimeline.Builder)((SwingComponentTimeline.Builder)SwingComponentTimeline.componentBuilder(tree).addCallback(new EventDispatchThreadTimelineCallbackAdapter(){

                            @Override
                            public void onTimelinePulse(float durationFraction, float timelinePosition) {
                                if ((double)timelinePosition >= 0.5) {
                                    int nudge = (int)((double)finalDelta * ((double)timelinePosition - 0.5));
                                    c2.getViewport().setViewPosition(new Point(viewportRect.x + nudge, viewportRect.y));
                                }
                            }
                        })).setEase(durationFraction -> {
                            if ((double)durationFraction < 0.5) {
                                return 0.5f * durationFraction;
                            }
                            return 0.25f + (durationFraction - 0.5f) * 0.75f / 0.5f;
                        })).setDuration(2L * AnimationConfigurationManager.getInstance().getTimelineDuration())).build();
                        this.horizontalScrollTimeline.play();
                    }
                }
            }
        };
        c2.getVerticalScrollBar().getModel().addChangeListener(this.substanceVerticalScrollbarChangeListener);
        for (SubstanceWidget<JComponent> lafWidget : this.lafWidgets) {
            lafWidget.installListeners();
        }
    }

    @Override
    protected void uninstallListeners(JComponent c2) {
        c2.removePropertyChangeListener(this.substancePropertyChangeListener);
        this.substancePropertyChangeListener = null;
        JScrollPane jsp = (JScrollPane)c2;
        jsp.getVerticalScrollBar().getModel().removeChangeListener(this.substanceVerticalScrollbarChangeListener);
        this.substanceVerticalScrollbarChangeListener = null;
        for (SubstanceWidget<JComponent> lafWidget : this.lafWidgets) {
            lafWidget.uninstallListeners();
        }
        super.uninstallListeners(c2);
    }

    @Override
    public void update(Graphics g2, JComponent c2) {
        BackgroundPaintingUtils.updateIfOpaque(g2, c2);
        JScrollPane jsp = (JScrollPane)c2;
        LayoutManager lm = jsp.getLayout();
        ScrollPaneLayout scrollLm = null;
        if (lm instanceof ScrollPaneLayout) {
            scrollLm = (ScrollPaneLayout)lm;
        }
        if (scrollLm != null) {
            HashSet<Component> corners = new HashSet<Component>();
            if (scrollLm.getCorner("LOWER_LEFT_CORNER") != null) {
                corners.add(scrollLm.getCorner("LOWER_LEFT_CORNER"));
            }
            if (scrollLm.getCorner("LOWER_RIGHT_CORNER") != null) {
                corners.add(scrollLm.getCorner("LOWER_RIGHT_CORNER"));
            }
            if (scrollLm.getCorner("UPPER_LEFT_CORNER") != null) {
                corners.add(scrollLm.getCorner("UPPER_LEFT_CORNER"));
            }
            if (scrollLm.getCorner("UPPER_RIGHT_CORNER") != null) {
                corners.add(scrollLm.getCorner("UPPER_RIGHT_CORNER"));
            }
            if (SubstanceCoreUtilities.isOpaque(c2)) {
                Graphics2D g2d = (Graphics2D)g2.create();
                g2d.setColor(SubstanceColorUtilities.getBackgroundFillColorScrollBar(this.scrollpane.getVerticalScrollBar()));
                for (Component corner : corners) {
                    g2d.fill(corner.getBounds());
                }
                JScrollBar horizontal = this.scrollpane.getHorizontalScrollBar();
                JScrollBar vertical = this.scrollpane.getVerticalScrollBar();
                if (horizontal != null && vertical != null) {
                    if (this.scrollpane.getComponentOrientation().isLeftToRight()) {
                        if (scrollLm.getCorner("LOWER_RIGHT_CORNER") == null) {
                            g2d.fillRect(horizontal.getX() + horizontal.getWidth(), horizontal.getY(), vertical.getWidth(), horizontal.getHeight());
                        }
                    } else if (scrollLm.getCorner("LOWER_LEFT_CORNER") == null) {
                        g2d.fillRect(0, horizontal.getY(), vertical.getWidth(), horizontal.getHeight());
                    }
                }
            }
        }
        super.paint(g2, c2);
    }

    private void installTableHeaderCornerFiller(JScrollPane scrollpane) {
        boolean canReplace;
        JViewport columnHeader = scrollpane.getColumnHeader();
        if (columnHeader == null) {
            return;
        }
        Component columnHeaderComp = columnHeader.getView();
        if (!(columnHeaderComp instanceof JTableHeader)) {
            return;
        }
        JTableHeader tableHeader = (JTableHeader)columnHeaderComp;
        TableHeaderUI tableHeaderUI = tableHeader.getUI();
        if (!(tableHeaderUI instanceof SubstanceTableHeaderUI)) {
            return;
        }
        SubstanceTableHeaderUI ui2 = (SubstanceTableHeaderUI)tableHeaderUI;
        JComponent scrollPaneCornerFiller = ui2.getScrollPaneCornerFiller();
        String cornerKey = scrollpane.getComponentOrientation().isLeftToRight() ? "UPPER_RIGHT_CORNER" : "UPPER_LEFT_CORNER";
        Component cornerComp = scrollpane.getCorner(cornerKey);
        boolean bl = canReplace = cornerComp == null || cornerComp instanceof UIResource;
        if (canReplace) {
            scrollpane.setCorner(cornerKey, scrollPaneCornerFiller);
        }
    }
}

