/*
 * Decompiled with CFR 0.152.
 */
package org.pushingpixels.substance.internal.ui;

import java.awt.AlphaComposite;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.Rectangle;
import java.awt.Shape;
import java.awt.event.AdjustmentListener;
import java.awt.event.MouseEvent;
import java.awt.image.BufferedImage;
import java.beans.PropertyChangeListener;
import java.util.Map;
import java.util.Set;
import javax.swing.BoundedRangeModel;
import javax.swing.ButtonModel;
import javax.swing.DefaultButtonModel;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JScrollBar;
import javax.swing.JScrollPane;
import javax.swing.SwingUtilities;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.basic.BasicScrollBarUI;
import org.pushingpixels.neon.api.NeonCortex;
import org.pushingpixels.substance.api.ComponentState;
import org.pushingpixels.substance.api.SubstanceSlices;
import org.pushingpixels.substance.api.SubstanceWidget;
import org.pushingpixels.substance.api.colorscheme.SubstanceColorScheme;
import org.pushingpixels.substance.api.painter.border.SubstanceBorderPainter;
import org.pushingpixels.substance.api.painter.fill.SubstanceFillPainter;
import org.pushingpixels.substance.api.shaper.SubstanceButtonShaper;
import org.pushingpixels.substance.internal.SubstanceWidgetRepository;
import org.pushingpixels.substance.internal.animation.StateTransitionTracker;
import org.pushingpixels.substance.internal.animation.TransitionAwareUI;
import org.pushingpixels.substance.internal.painter.BackgroundPaintingUtils;
import org.pushingpixels.substance.internal.utils.HashMapKey;
import org.pushingpixels.substance.internal.utils.LazyResettableHashMap;
import org.pushingpixels.substance.internal.utils.RolloverControlListener;
import org.pushingpixels.substance.internal.utils.SubstanceColorSchemeUtilities;
import org.pushingpixels.substance.internal.utils.SubstanceColorUtilities;
import org.pushingpixels.substance.internal.utils.SubstanceCoreUtilities;
import org.pushingpixels.substance.internal.utils.SubstanceImageCreator;
import org.pushingpixels.substance.internal.utils.SubstanceOutlineUtilities;
import org.pushingpixels.substance.internal.utils.SubstanceSizeUtils;
import org.pushingpixels.substance.internal.utils.WidgetUtilities;
import org.pushingpixels.substance.internal.widget.animation.effects.GhostPaintingUtils;

public class SubstanceScrollBarUI
extends BasicScrollBarUI
implements TransitionAwareUI {
    private ButtonModel thumbModel = new DefaultButtonModel();
    private static LazyResettableHashMap<BufferedImage> thumbVerticalMap = new LazyResettableHashMap("SubstanceScrollBarUI.thumbVertical");
    private static LazyResettableHashMap<BufferedImage> thumbHorizontalMap = new LazyResettableHashMap("SubstanceScrollBarUI.thumbHorizontal");
    private RolloverControlListener substanceThumbRolloverListener;
    private StateTransitionTracker compositeStateTransitionTracker;
    private PropertyChangeListener substancePropertyListener;
    private int scrollBarWidth;
    private AdjustmentListener substanceAdjustmentListener;
    private Set<SubstanceWidget<JComponent>> lafWidgets;
    private static int THUMB_DELTA = 2;

    public static ComponentUI createUI(JComponent comp) {
        SubstanceCoreUtilities.testComponentCreationThreadingViolation(comp);
        return new SubstanceScrollBarUI(comp);
    }

    private SubstanceScrollBarUI(JComponent b2) {
        this.thumbModel.setArmed(false);
        this.thumbModel.setSelected(false);
        this.thumbModel.setPressed(false);
        this.thumbModel.setRollover(false);
        b2.setOpaque(false);
    }

    @Override
    public void installUI(JComponent c2) {
        this.lafWidgets = SubstanceWidgetRepository.getRepository().getMatchingWidgets(c2);
        super.installUI(c2);
        for (SubstanceWidget<JComponent> lafWidget : this.lafWidgets) {
            lafWidget.installUI();
        }
    }

    @Override
    public void uninstallUI(JComponent c2) {
        for (SubstanceWidget<JComponent> lafWidget : this.lafWidgets) {
            lafWidget.uninstallUI();
        }
        super.uninstallUI(c2);
    }

    @Override
    protected JButton createDecreaseButton(int orientation) {
        return null;
    }

    @Override
    protected JButton createIncreaseButton(int orientation) {
        return null;
    }

    private BufferedImage getThumbVertical(Rectangle thumbBounds) {
        int width = Math.max(1, thumbBounds.width);
        int delta = Math.max(0, (int)(0.4 * (double)width));
        if (delta % 2 == 1) {
            --delta;
        }
        int height = Math.max(1, thumbBounds.height);
        StateTransitionTracker.ModelStateInfo modelStateInfo = this.compositeStateTransitionTracker.getModelStateInfo();
        ComponentState currState = modelStateInfo.getCurrModelState();
        SubstanceColorScheme baseFillScheme = currState != ComponentState.ENABLED ? SubstanceColorSchemeUtilities.getColorScheme(this.scrollbar, currState) : SubstanceColorSchemeUtilities.getActiveColorScheme(this.scrollbar, currState);
        SubstanceColorScheme baseBorderScheme = SubstanceColorSchemeUtilities.getColorScheme(this.scrollbar, SubstanceSlices.ColorSchemeAssociationKind.BORDER, currState);
        BufferedImage baseLayer = SubstanceScrollBarUI.getThumbVertical(this.scrollbar, width -= delta, height, baseFillScheme, baseBorderScheme);
        Map<ComponentState, StateTransitionTracker.StateContributionInfo> activeStates = modelStateInfo.getStateContributionMap();
        if (currState.isDisabled() || activeStates.size() == 1) {
            return baseLayer;
        }
        BufferedImage result = SubstanceCoreUtilities.getBlankUnscaledImage(baseLayer);
        Graphics2D g2d = result.createGraphics();
        g2d.drawImage(baseLayer, 0, 0, baseLayer.getWidth(), baseLayer.getHeight(), null);
        for (Map.Entry<ComponentState, StateTransitionTracker.StateContributionInfo> activeEntry : activeStates.entrySet()) {
            float contribution;
            ComponentState activeState = activeEntry.getKey();
            if (activeState == modelStateInfo.getCurrModelState() || (contribution = activeEntry.getValue().getContribution()) == 0.0f) continue;
            g2d.setComposite(AlphaComposite.SrcOver.derive(contribution));
            SubstanceColorScheme fillScheme = activeState != ComponentState.ENABLED ? SubstanceColorSchemeUtilities.getColorScheme(this.scrollbar, activeState) : SubstanceColorSchemeUtilities.getActiveColorScheme(this.scrollbar, activeState);
            SubstanceColorScheme borderScheme = SubstanceColorSchemeUtilities.getColorScheme(this.scrollbar, SubstanceSlices.ColorSchemeAssociationKind.BORDER, activeState);
            BufferedImage layer = SubstanceScrollBarUI.getThumbVertical(this.scrollbar, width, height, fillScheme, borderScheme);
            g2d.drawImage(layer, 0, 0, layer.getWidth(), layer.getHeight(), null);
        }
        g2d.dispose();
        return result;
    }

    private static BufferedImage getThumbVertical(JScrollBar scrollBar, int width, int height, SubstanceColorScheme scheme, SubstanceColorScheme borderScheme) {
        SubstanceFillPainter painter = SubstanceCoreUtilities.getFillPainter(scrollBar);
        SubstanceButtonShaper shaper = SubstanceCoreUtilities.getButtonShaper(scrollBar);
        SubstanceBorderPainter borderPainter = SubstanceCoreUtilities.getBorderPainter(scrollBar);
        HashMapKey key = SubstanceCoreUtilities.getHashKey(width, height, scheme.getDisplayName(), borderScheme.getDisplayName(), painter.getDisplayName(), shaper.getDisplayName(), borderPainter.getDisplayName());
        BufferedImage result = thumbVerticalMap.get(key);
        if (result == null) {
            float radius = width / 2;
            float borderDelta = SubstanceSizeUtils.getBorderStrokeWidth() / 2.0f;
            Shape contour = SubstanceOutlineUtilities.getBaseOutline(height, width, radius, null, borderDelta);
            result = SubstanceCoreUtilities.getBlankImage(height, width);
            painter.paintContourBackground(result.createGraphics(), scrollBar, height, width, contour, false, scheme, true);
            borderPainter.paintBorder(result.getGraphics(), scrollBar, height, width, contour, null, borderScheme);
            result = SubstanceImageCreator.getRotated(result, 3);
            thumbVerticalMap.put(key, result);
        }
        return result;
    }

    private BufferedImage getThumbHorizontal(Rectangle thumbBounds) {
        StateTransitionTracker.ModelStateInfo modelStateInfo;
        ComponentState currState;
        int width = Math.max(1, thumbBounds.width);
        int height = Math.max(1, thumbBounds.height);
        int delta = Math.max(0, (int)(0.4 * (double)height));
        if (delta % 2 == 1) {
            --delta;
        }
        SubstanceColorScheme baseFillScheme = (currState = (modelStateInfo = this.compositeStateTransitionTracker.getModelStateInfo()).getCurrModelState()) != ComponentState.ENABLED ? SubstanceColorSchemeUtilities.getColorScheme(this.scrollbar, currState) : SubstanceColorSchemeUtilities.getActiveColorScheme(this.scrollbar, currState);
        SubstanceColorScheme baseBorderScheme = SubstanceColorSchemeUtilities.getColorScheme(this.scrollbar, SubstanceSlices.ColorSchemeAssociationKind.BORDER, currState);
        BufferedImage baseLayer = SubstanceScrollBarUI.getThumbHorizontal(this.scrollbar, width, height -= delta, baseFillScheme, baseBorderScheme);
        Map<ComponentState, StateTransitionTracker.StateContributionInfo> activeStates = modelStateInfo.getStateContributionMap();
        if (currState.isDisabled() || activeStates.size() == 1) {
            return baseLayer;
        }
        BufferedImage result = SubstanceCoreUtilities.getBlankUnscaledImage(baseLayer);
        Graphics2D g2d = result.createGraphics();
        g2d.drawImage(baseLayer, 0, 0, baseLayer.getWidth(), baseLayer.getHeight(), null);
        for (Map.Entry<ComponentState, StateTransitionTracker.StateContributionInfo> activeEntry : activeStates.entrySet()) {
            float contribution;
            ComponentState activeState = activeEntry.getKey();
            if (activeState == modelStateInfo.getCurrModelState() || (contribution = activeEntry.getValue().getContribution()) == 0.0f) continue;
            g2d.setComposite(AlphaComposite.SrcOver.derive(contribution));
            SubstanceColorScheme fillScheme = activeState != ComponentState.ENABLED ? SubstanceColorSchemeUtilities.getColorScheme(this.scrollbar, activeState) : SubstanceColorSchemeUtilities.getActiveColorScheme(this.scrollbar, activeState);
            SubstanceColorScheme borderScheme = SubstanceColorSchemeUtilities.getColorScheme(this.scrollbar, SubstanceSlices.ColorSchemeAssociationKind.BORDER, activeState);
            BufferedImage layer = SubstanceScrollBarUI.getThumbHorizontal(this.scrollbar, width, height, fillScheme, borderScheme);
            g2d.drawImage(layer, 0, 0, layer.getWidth(), layer.getHeight(), null);
        }
        g2d.dispose();
        return result;
    }

    private static BufferedImage getThumbHorizontal(JScrollBar scrollBar, int width, int height, SubstanceColorScheme scheme, SubstanceColorScheme borderScheme) {
        SubstanceFillPainter painter = SubstanceCoreUtilities.getFillPainter(scrollBar);
        SubstanceButtonShaper shaper = SubstanceCoreUtilities.getButtonShaper(scrollBar);
        SubstanceBorderPainter borderPainter = SubstanceCoreUtilities.getBorderPainter(scrollBar);
        HashMapKey key = SubstanceCoreUtilities.getHashKey(width, height, scheme.getDisplayName(), borderScheme.getDisplayName(), painter.getDisplayName(), shaper.getDisplayName(), borderPainter.getDisplayName());
        float radius = height / 2;
        float borderDelta = SubstanceSizeUtils.getBorderStrokeWidth() / 2.0f;
        Shape contour = SubstanceOutlineUtilities.getBaseOutline(width, height, radius, null, borderDelta);
        BufferedImage opaque = thumbHorizontalMap.get(key);
        if (opaque == null) {
            opaque = SubstanceCoreUtilities.getBlankImage(width, height);
            painter.paintContourBackground(opaque.createGraphics(), scrollBar, width, height, contour, false, scheme, true);
            borderPainter.paintBorder(opaque.getGraphics(), scrollBar, width, height, contour, null, borderScheme);
            thumbHorizontalMap.put(key, opaque);
        }
        return opaque;
    }

    protected ComponentState getState(JButton scrollButton) {
        if (scrollButton == null) {
            return null;
        }
        ComponentState result = ((TransitionAwareUI)((Object)scrollButton.getUI())).getTransitionTracker().getModelStateInfo().getCurrModelState();
        if (result == ComponentState.ENABLED && SubstanceCoreUtilities.hasFlatAppearance(this.scrollbar, false)) {
            result = null;
        }
        if (SubstanceCoreUtilities.isButtonNeverPainted(scrollButton)) {
            result = null;
        }
        return result;
    }

    @Override
    protected void paintTrack(Graphics g2, JComponent c2, Rectangle trackBounds) {
        Graphics2D graphics = (Graphics2D)g2.create();
        if (this.scrollbar.getOrientation() == 1) {
            graphics.translate(trackBounds.x, trackBounds.y - THUMB_DELTA);
        } else {
            graphics.translate(trackBounds.x - THUMB_DELTA, trackBounds.y);
        }
        graphics.setColor(SubstanceColorUtilities.getBackgroundFillColorScrollBar(this.scrollbar));
        graphics.fillRect(0, 0, this.scrollbar.getWidth(), this.scrollbar.getHeight());
        GhostPaintingUtils.paintGhostImages(this.scrollbar, g2);
        graphics.dispose();
    }

    @Override
    protected void paintThumb(Graphics g2, JComponent c2, Rectangle thumbBounds) {
        boolean isVertical;
        Graphics2D graphics = (Graphics2D)g2.create();
        this.thumbModel.setSelected(this.thumbModel.isSelected() || this.isDragging);
        this.thumbModel.setEnabled(c2.isEnabled());
        double scaleFactor = NeonCortex.getScaleFactor();
        boolean bl = isVertical = this.scrollbar.getOrientation() == 1;
        if (isVertical) {
            Rectangle adjustedBounds = new Rectangle(thumbBounds.x, thumbBounds.y, thumbBounds.width, thumbBounds.height);
            BufferedImage thumbImage = this.getThumbVertical(adjustedBounds);
            int xdelta = (thumbBounds.width - (int)((double)thumbImage.getWidth() / scaleFactor)) / 2;
            NeonCortex.drawImage(graphics, thumbImage, adjustedBounds.x + xdelta, adjustedBounds.y);
        } else {
            Rectangle adjustedBounds = new Rectangle(thumbBounds.x, thumbBounds.y, thumbBounds.width, thumbBounds.height);
            BufferedImage thumbImage = this.getThumbHorizontal(adjustedBounds);
            int ydelta = (thumbBounds.height - (int)((double)thumbImage.getHeight() / scaleFactor)) / 2;
            NeonCortex.drawImage(graphics, thumbImage, adjustedBounds.x, adjustedBounds.y + ydelta);
        }
        graphics.dispose();
    }

    @Override
    public void paint(Graphics g2, JComponent c2) {
        Graphics2D graphics = (Graphics2D)g2.create();
        BackgroundPaintingUtils.update(graphics, c2, false);
        float alpha = SubstanceColorSchemeUtilities.getAlpha(this.scrollbar, ComponentState.getState(this.thumbModel, this.scrollbar));
        graphics.setComposite(WidgetUtilities.getAlphaComposite(c2, alpha, g2));
        super.paint(graphics, c2);
        graphics.dispose();
    }

    @Override
    protected void installDefaults() {
        super.installDefaults();
        this.scrollBarWidth = SubstanceSizeUtils.getScrollBarWidth(SubstanceSizeUtils.getComponentFontSize(this.scrollbar));
        for (SubstanceWidget<JComponent> lafWidget : this.lafWidgets) {
            lafWidget.installDefaults();
        }
    }

    @Override
    protected void uninstallDefaults() {
        for (SubstanceWidget<JComponent> lafWidget : this.lafWidgets) {
            lafWidget.uninstallDefaults();
        }
        super.uninstallDefaults();
    }

    @Override
    protected void installComponents() {
        this.compositeStateTransitionTracker = new StateTransitionTracker(this.scrollbar, this.thumbModel);
        this.compositeStateTransitionTracker.registerModelListeners();
        for (SubstanceWidget<JComponent> lafWidget : this.lafWidgets) {
            lafWidget.installComponents();
        }
    }

    @Override
    protected void uninstallComponents() {
        this.compositeStateTransitionTracker.unregisterModelListeners();
        for (SubstanceWidget<JComponent> lafWidget : this.lafWidgets) {
            lafWidget.uninstallComponents();
        }
    }

    @Override
    protected void installListeners() {
        super.installListeners();
        this.substanceThumbRolloverListener = new RolloverControlListener(this, this.thumbModel);
        this.scrollbar.addMouseListener(this.substanceThumbRolloverListener);
        this.scrollbar.addMouseMotionListener(this.substanceThumbRolloverListener);
        this.substancePropertyListener = propertyChangeEvent -> {
            if ("font".equals(propertyChangeEvent.getPropertyName())) {
                SwingUtilities.invokeLater(() -> this.scrollbar.updateUI());
            }
        };
        this.scrollbar.addPropertyChangeListener(this.substancePropertyListener);
        this.substanceAdjustmentListener = adjustmentEvent -> {
            SubstanceCoreUtilities.testComponentStateChangeThreadingViolation(this.scrollbar);
            Container parent = this.scrollbar.getParent();
            if (parent instanceof JScrollPane) {
                JScrollPane jsp = (JScrollPane)parent;
                JScrollBar hor = jsp.getHorizontalScrollBar();
                JScrollBar ver = jsp.getVerticalScrollBar();
                JScrollBar other = null;
                if (this.scrollbar == hor) {
                    other = ver;
                }
                if (this.scrollbar == ver) {
                    other = hor;
                }
                if (other != null && other.isVisible()) {
                    other.repaint();
                }
                this.scrollbar.repaint();
            }
        };
        this.scrollbar.addAdjustmentListener(this.substanceAdjustmentListener);
        for (SubstanceWidget<JComponent> lafWidget : this.lafWidgets) {
            lafWidget.installListeners();
        }
    }

    @Override
    protected void uninstallListeners() {
        this.scrollbar.removeMouseListener(this.substanceThumbRolloverListener);
        this.scrollbar.removeMouseMotionListener(this.substanceThumbRolloverListener);
        this.substanceThumbRolloverListener = null;
        this.scrollbar.removePropertyChangeListener(this.substancePropertyListener);
        this.substancePropertyListener = null;
        this.scrollbar.removeAdjustmentListener(this.substanceAdjustmentListener);
        this.substanceAdjustmentListener = null;
        for (SubstanceWidget<JComponent> lafWidget : this.lafWidgets) {
            lafWidget.uninstallListeners();
        }
        super.uninstallListeners();
    }

    @Override
    public boolean isInside(MouseEvent me2) {
        Rectangle trackB = this.getTrackBounds();
        if (trackB == null) {
            return false;
        }
        return trackB.contains(me2.getX(), me2.getY());
    }

    @Override
    public StateTransitionTracker getTransitionTracker() {
        return this.compositeStateTransitionTracker;
    }

    @Override
    public void scrollByBlock(int direction) {
        int oldValue = this.scrollbar.getValue();
        int blockIncrement = this.scrollbar.getBlockIncrement(direction);
        int delta = blockIncrement * (direction > 0 ? 1 : -1);
        int newValue = oldValue + delta;
        if (delta > 0 && newValue < oldValue) {
            newValue = this.scrollbar.getMaximum();
        } else if (delta < 0 && newValue > oldValue) {
            newValue = this.scrollbar.getMinimum();
        }
        this.scrollbar.setValue(newValue);
    }

    public void scrollByUnits(int direction, int units) {
        for (int i2 = 0; i2 < units; ++i2) {
            int delta = direction > 0 ? this.scrollbar.getUnitIncrement(direction) : -this.scrollbar.getUnitIncrement(direction);
            int oldValue = this.scrollbar.getValue();
            int newValue = oldValue + delta;
            if (delta > 0 && newValue < oldValue) {
                newValue = this.scrollbar.getMaximum();
            } else if (delta < 0 && newValue > oldValue) {
                newValue = this.scrollbar.getMinimum();
            }
            if (oldValue == newValue) break;
            this.scrollbar.setValue(newValue);
        }
    }

    @Override
    protected void layoutVScrollbar(JScrollBar sb2) {
        this.layoutVScrollbarNone(sb2);
    }

    @Override
    protected void layoutHScrollbar(JScrollBar sb2) {
        this.layoutHScrollbarNone(sb2);
    }

    protected void layoutVScrollbarNone(JScrollBar sb2) {
        Dimension sbSize = sb2.getSize();
        Insets sbInsets = sb2.getInsets();
        int itemW = sbSize.width - (sbInsets.left + sbInsets.right);
        int itemX = sbInsets.left;
        int incrButtonY = sbSize.height - sbInsets.bottom - THUMB_DELTA;
        int sbInsetsH = sbInsets.top + sbInsets.bottom;
        float trackH = sbSize.height - sbInsetsH - THUMB_DELTA;
        float min = sb2.getMinimum();
        float extent = sb2.getVisibleAmount();
        float range = (float)sb2.getMaximum() - min;
        float value = sb2.getValue();
        int thumbH = range <= 0.0f ? this.getMaximumThumbSize().height : (int)(trackH * (extent / range));
        thumbH = Math.max(thumbH, this.getMinimumThumbSize().height);
        thumbH = Math.min(thumbH, this.getMaximumThumbSize().height);
        int thumbY = incrButtonY - (thumbH -= THUMB_DELTA) + THUMB_DELTA;
        if (value < (float)(sb2.getMaximum() - sb2.getVisibleAmount())) {
            float thumbRange = trackH - (float)thumbH;
            thumbY = THUMB_DELTA + (int)(0.5f + thumbRange * ((value - min) / (range - extent)));
        }
        int itrackY = THUMB_DELTA;
        int itrackH = incrButtonY - itrackY - 2 * THUMB_DELTA;
        this.trackRect.setBounds(itemX, itrackY, itemW, itrackH);
        if (thumbH >= (int)trackH) {
            this.setThumbBounds(0, 0, 0, 0);
        } else {
            if (thumbY + thumbH > incrButtonY) {
                thumbY = incrButtonY - thumbH;
            }
            if (thumbY < 0) {
                thumbY = 0;
            }
            this.setThumbBounds(itemX, thumbY, itemW, thumbH);
        }
    }

    protected void layoutHScrollbarNone(JScrollBar sb2) {
        int thumbX;
        Dimension sbSize = sb2.getSize();
        Insets sbInsets = sb2.getInsets();
        int itemH = sbSize.height - (sbInsets.top + sbInsets.bottom);
        int itemY = sbInsets.top;
        boolean ltr = sb2.getComponentOrientation().isLeftToRight();
        int incrButtonX = ltr ? sbSize.width - sbInsets.right - THUMB_DELTA : sbInsets.left + THUMB_DELTA;
        int sbInsetsW = sbInsets.left + sbInsets.right;
        float trackW = sbSize.width - sbInsetsW - THUMB_DELTA;
        float min = sb2.getMinimum();
        float max = sb2.getMaximum();
        float extent = sb2.getVisibleAmount();
        float range = max - min;
        float value = sb2.getValue();
        int thumbW = range <= 0.0f ? this.getMaximumThumbSize().width : (int)(trackW * (extent / range));
        thumbW = Math.max(thumbW, this.getMinimumThumbSize().width);
        thumbW = Math.min(thumbW, this.getMaximumThumbSize().width);
        int n2 = thumbX = ltr ? incrButtonX - (thumbW -= THUMB_DELTA) + THUMB_DELTA : sbInsets.left + THUMB_DELTA;
        if (value < max - (float)sb2.getVisibleAmount()) {
            float thumbRange = trackW - (float)thumbW;
            thumbX = ltr ? THUMB_DELTA + (int)(0.5f + thumbRange * ((value - min) / (range - extent))) : THUMB_DELTA + (int)(0.5f + thumbRange * ((max - extent - value) / (range - extent)));
        }
        if (ltr) {
            int itrackX = sbInsets.left + THUMB_DELTA;
            int itrackW = incrButtonX - itrackX - 2 * THUMB_DELTA;
            this.trackRect.setBounds(itrackX, itemY, itrackW, itemH);
        } else {
            int itrackX = incrButtonX + THUMB_DELTA;
            int itrackW = sbSize.width - itrackX - 2 * THUMB_DELTA;
            this.trackRect.setBounds(itrackX, itemY, itrackW, itemH);
        }
        if (thumbW >= (int)trackW) {
            this.setThumbBounds(0, 0, 0, 0);
        } else {
            if (ltr) {
                if (thumbX + thumbW > incrButtonX) {
                    thumbX = incrButtonX - thumbW;
                }
                if (thumbX < 0) {
                    thumbX = 1;
                }
            } else if (thumbX + thumbW > sbSize.width - sbInsets.left) {
                thumbX = sbSize.width - sbInsets.left - thumbW;
            }
            this.setThumbBounds(thumbX, itemY, thumbW, itemH);
        }
    }

    @Override
    protected BasicScrollBarUI.TrackListener createTrackListener() {
        return new SubstanceTrackListener();
    }

    @Override
    protected BasicScrollBarUI.ArrowButtonListener createArrowButtonListener() {
        return null;
    }

    private void updateThumbState(int x2, int y2) {
        Rectangle rect = this.getThumbBounds();
        this.setThumbRollover(rect.contains(x2, y2));
    }

    @Override
    public Dimension getPreferredSize(JComponent c2) {
        if (this.scrollbar.getOrientation() == 1) {
            return new Dimension(this.scrollBarWidth, Math.max(48, 5 * this.scrollBarWidth));
        }
        return new Dimension(Math.max(48, 5 * this.scrollBarWidth), this.scrollBarWidth);
    }

    @Override
    public void update(Graphics g2, JComponent c2) {
        super.update(g2, c2);
        GhostPaintingUtils.paintGhostImages(c2, g2);
    }

    protected class SubstanceTrackListener
    extends BasicScrollBarUI.TrackListener {
        private transient int direction;

        protected SubstanceTrackListener() {
            super(SubstanceScrollBarUI.this);
            this.direction = 1;
        }

        @Override
        public void mouseReleased(MouseEvent e2) {
            if (SubstanceScrollBarUI.this.isDragging) {
                SubstanceScrollBarUI.this.updateThumbState(e2.getX(), e2.getY());
            }
            if (SwingUtilities.isRightMouseButton(e2) || !SubstanceScrollBarUI.this.getSupportsAbsolutePositioning() && SwingUtilities.isMiddleMouseButton(e2)) {
                return;
            }
            if (!SubstanceScrollBarUI.this.scrollbar.isEnabled()) {
                return;
            }
            Rectangle r2 = SubstanceScrollBarUI.this.getTrackBounds();
            SubstanceScrollBarUI.this.scrollbar.repaint(r2.x, r2.y, r2.width, r2.height);
            SubstanceScrollBarUI.this.trackHighlight = 0;
            SubstanceScrollBarUI.this.isDragging = false;
            this.offset = 0;
            SubstanceScrollBarUI.this.scrollTimer.stop();
            SubstanceScrollBarUI.this.scrollbar.setValueIsAdjusting(false);
        }

        @Override
        public void mousePressed(MouseEvent e2) {
            if (SwingUtilities.isRightMouseButton(e2) || !SubstanceScrollBarUI.this.getSupportsAbsolutePositioning() && SwingUtilities.isMiddleMouseButton(e2)) {
                return;
            }
            if (!SubstanceScrollBarUI.this.scrollbar.isEnabled()) {
                return;
            }
            if (!SubstanceScrollBarUI.this.scrollbar.hasFocus() && SubstanceScrollBarUI.this.scrollbar.isRequestFocusEnabled()) {
                SubstanceScrollBarUI.this.scrollbar.requestFocus();
            }
            SubstanceScrollBarUI.this.scrollbar.setValueIsAdjusting(true);
            this.currentMouseX = e2.getX();
            this.currentMouseY = e2.getY();
            if (SubstanceScrollBarUI.this.getThumbBounds().contains(this.currentMouseX, this.currentMouseY)) {
                switch (SubstanceScrollBarUI.this.scrollbar.getOrientation()) {
                    case 1: {
                        this.offset = this.currentMouseY - ((SubstanceScrollBarUI)SubstanceScrollBarUI.this).getThumbBounds().y;
                        break;
                    }
                    case 0: {
                        this.offset = this.currentMouseX - ((SubstanceScrollBarUI)SubstanceScrollBarUI.this).getThumbBounds().x;
                    }
                }
                SubstanceScrollBarUI.this.isDragging = true;
                return;
            }
            if (SubstanceScrollBarUI.this.getSupportsAbsolutePositioning() && SwingUtilities.isMiddleMouseButton(e2)) {
                switch (SubstanceScrollBarUI.this.scrollbar.getOrientation()) {
                    case 1: {
                        this.offset = ((SubstanceScrollBarUI)SubstanceScrollBarUI.this).getThumbBounds().height / 2;
                        break;
                    }
                    case 0: {
                        this.offset = ((SubstanceScrollBarUI)SubstanceScrollBarUI.this).getThumbBounds().width / 2;
                    }
                }
                SubstanceScrollBarUI.this.isDragging = true;
                this.setValueFrom(e2);
                return;
            }
            SubstanceScrollBarUI.this.isDragging = false;
            Dimension sbSize = SubstanceScrollBarUI.this.scrollbar.getSize();
            this.direction = 1;
            switch (SubstanceScrollBarUI.this.scrollbar.getOrientation()) {
                case 1: {
                    if (SubstanceScrollBarUI.this.getThumbBounds().isEmpty()) {
                        int scrollbarCenter = sbSize.height / 2;
                        this.direction = this.currentMouseY < scrollbarCenter ? -1 : 1;
                        break;
                    }
                    int thumbY = ((SubstanceScrollBarUI)SubstanceScrollBarUI.this).getThumbBounds().y;
                    this.direction = this.currentMouseY < thumbY ? -1 : 1;
                    break;
                }
                case 0: {
                    if (SubstanceScrollBarUI.this.getThumbBounds().isEmpty()) {
                        int scrollbarCenter = sbSize.width / 2;
                        this.direction = this.currentMouseX < scrollbarCenter ? -1 : 1;
                    } else {
                        int thumbX = ((SubstanceScrollBarUI)SubstanceScrollBarUI.this).getThumbBounds().x;
                        int n2 = this.direction = this.currentMouseX < thumbX ? -1 : 1;
                    }
                    if (SubstanceScrollBarUI.this.scrollbar.getComponentOrientation().isLeftToRight()) break;
                    this.direction = -this.direction;
                }
            }
            SubstanceScrollBarUI.this.scrollByBlock(this.direction);
            SubstanceScrollBarUI.this.scrollTimer.stop();
            SubstanceScrollBarUI.this.scrollListener.setDirection(this.direction);
            SubstanceScrollBarUI.this.scrollListener.setScrollByBlock(true);
            this.startScrollTimerIfNecessary();
        }

        @Override
        public void mouseDragged(MouseEvent e2) {
            if (SwingUtilities.isRightMouseButton(e2) || !SubstanceScrollBarUI.this.getSupportsAbsolutePositioning() && SwingUtilities.isMiddleMouseButton(e2)) {
                return;
            }
            if (!SubstanceScrollBarUI.this.scrollbar.isEnabled() || SubstanceScrollBarUI.this.getThumbBounds().isEmpty()) {
                return;
            }
            if (SubstanceScrollBarUI.this.isDragging) {
                this.setValueFrom(e2);
            } else {
                this.currentMouseX = e2.getX();
                this.currentMouseY = e2.getY();
                SubstanceScrollBarUI.this.updateThumbState(this.currentMouseX, this.currentMouseY);
                this.startScrollTimerIfNecessary();
            }
        }

        private void setValueFrom(MouseEvent e2) {
            int thumbPos;
            boolean active = SubstanceScrollBarUI.this.isThumbRollover();
            BoundedRangeModel model = SubstanceScrollBarUI.this.scrollbar.getModel();
            Rectangle thumbR = SubstanceScrollBarUI.this.getThumbBounds();
            int thumbMin = 0;
            int thumbMax = 0;
            if (SubstanceScrollBarUI.this.scrollbar.getOrientation() == 1) {
                thumbMin = THUMB_DELTA;
                thumbMax = ((SubstanceScrollBarUI)SubstanceScrollBarUI.this).scrollbar.getSize().height - ((SubstanceScrollBarUI)SubstanceScrollBarUI.this).scrollbar.getInsets().bottom - thumbR.height - THUMB_DELTA;
                thumbPos = Math.min(thumbMax, Math.max(thumbMin, e2.getY() - this.offset));
                SubstanceScrollBarUI.this.setThumbBounds(thumbR.x, thumbPos, thumbR.width, thumbR.height);
            } else {
                thumbMin = THUMB_DELTA;
                thumbMax = ((SubstanceScrollBarUI)SubstanceScrollBarUI.this).scrollbar.getSize().width - ((SubstanceScrollBarUI)SubstanceScrollBarUI.this).scrollbar.getInsets().right - thumbR.width - THUMB_DELTA;
                thumbPos = Math.min(thumbMax, Math.max(thumbMin, e2.getX() - this.offset));
                SubstanceScrollBarUI.this.setThumbBounds(thumbPos, thumbR.y, thumbR.width, thumbR.height);
            }
            if (thumbPos == thumbMax) {
                if (SubstanceScrollBarUI.this.scrollbar.getOrientation() == 1 || SubstanceScrollBarUI.this.scrollbar.getComponentOrientation().isLeftToRight()) {
                    SubstanceScrollBarUI.this.scrollbar.setValue(model.getMaximum() - model.getExtent());
                } else {
                    SubstanceScrollBarUI.this.scrollbar.setValue(model.getMinimum());
                }
            } else {
                float valueMax = model.getMaximum() - model.getExtent();
                float valueRange = valueMax - (float)model.getMinimum();
                float thumbValue = thumbPos - thumbMin;
                float thumbRange = thumbMax - thumbMin;
                int value = SubstanceScrollBarUI.this.scrollbar.getOrientation() == 1 || SubstanceScrollBarUI.this.scrollbar.getComponentOrientation().isLeftToRight() ? (int)(0.5 + (double)(thumbValue / thumbRange * valueRange)) : (int)(0.5 + (double)((float)(thumbMax - thumbPos) / thumbRange * valueRange));
                SubstanceScrollBarUI.this.scrollbar.setValue(value + model.getMinimum());
            }
            SubstanceScrollBarUI.this.setThumbRollover(active);
        }

        private void startScrollTimerIfNecessary() {
            if (SubstanceScrollBarUI.this.scrollTimer.isRunning()) {
                return;
            }
            switch (SubstanceScrollBarUI.this.scrollbar.getOrientation()) {
                case 1: {
                    if (this.direction > 0) {
                        if (((SubstanceScrollBarUI)SubstanceScrollBarUI.this).getThumbBounds().y + ((SubstanceScrollBarUI)SubstanceScrollBarUI.this).getThumbBounds().height >= ((SubstanceTrackListener)((SubstanceScrollBarUI)SubstanceScrollBarUI.this).trackListener).currentMouseY) break;
                        SubstanceScrollBarUI.this.scrollTimer.start();
                        break;
                    }
                    if (((SubstanceScrollBarUI)SubstanceScrollBarUI.this).getThumbBounds().y <= ((SubstanceTrackListener)((SubstanceScrollBarUI)SubstanceScrollBarUI.this).trackListener).currentMouseY) break;
                    SubstanceScrollBarUI.this.scrollTimer.start();
                    break;
                }
                case 0: {
                    if (this.direction > 0) {
                        if (((SubstanceScrollBarUI)SubstanceScrollBarUI.this).getThumbBounds().x + ((SubstanceScrollBarUI)SubstanceScrollBarUI.this).getThumbBounds().width >= ((SubstanceTrackListener)((SubstanceScrollBarUI)SubstanceScrollBarUI.this).trackListener).currentMouseX) break;
                        SubstanceScrollBarUI.this.scrollTimer.start();
                        break;
                    }
                    if (((SubstanceScrollBarUI)SubstanceScrollBarUI.this).getThumbBounds().x <= ((SubstanceTrackListener)((SubstanceScrollBarUI)SubstanceScrollBarUI.this).trackListener).currentMouseX) break;
                    SubstanceScrollBarUI.this.scrollTimer.start();
                }
            }
        }

        @Override
        public void mouseMoved(MouseEvent e2) {
            if (!SubstanceScrollBarUI.this.isDragging) {
                SubstanceScrollBarUI.this.updateThumbState(e2.getX(), e2.getY());
            }
        }

        @Override
        public void mouseExited(MouseEvent e2) {
            if (!SubstanceScrollBarUI.this.isDragging) {
                SubstanceScrollBarUI.this.setThumbRollover(false);
            }
        }
    }
}

