/*
 * Decompiled with CFR 0.152.
 */
package org.pushingpixels.substance.internal.ui;

import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Cursor;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.Graphics;
import java.awt.GraphicsConfiguration;
import java.awt.GraphicsDevice;
import java.awt.GraphicsEnvironment;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.LayoutManager2;
import java.awt.MouseInfo;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.awt.Window;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.ComponentListener;
import java.awt.event.HierarchyListener;
import java.awt.event.MouseEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.security.AccessController;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.util.Set;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JFrame;
import javax.swing.JInternalFrame;
import javax.swing.JLayeredPane;
import javax.swing.JRootPane;
import javax.swing.LookAndFeel;
import javax.swing.SwingUtilities;
import javax.swing.event.MouseInputAdapter;
import javax.swing.event.MouseInputListener;
import javax.swing.plaf.ColorUIResource;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.UIResource;
import javax.swing.plaf.basic.BasicRootPaneUI;
import org.pushingpixels.substance.api.SubstanceSkin;
import org.pushingpixels.substance.api.SubstanceWidget;
import org.pushingpixels.substance.internal.SubstanceWidgetRepository;
import org.pushingpixels.substance.internal.painter.BackgroundPaintingUtils;
import org.pushingpixels.substance.internal.ui.SubstanceInternalFrameUI;
import org.pushingpixels.substance.internal.utils.MemoryAnalyzer;
import org.pushingpixels.substance.internal.utils.SubstanceColorUtilities;
import org.pushingpixels.substance.internal.utils.SubstanceCoreUtilities;
import org.pushingpixels.substance.internal.utils.SubstanceTitlePane;
import org.pushingpixels.substance.internal.utils.SubstanceTitlePaneUtilities;

public class SubstanceRootPaneUI
extends BasicRootPaneUI {
    private static final int CORNER_DRAG_WIDTH = 16;
    private static final int BORDER_DRAG_THICKNESS = 5;
    private Window window;
    private SubstanceTitlePane titlePane;
    private boolean isContentExtendingIntoTitlePane;
    private MouseInputListener substanceMouseInputListener;
    private MouseInputListener substanceTitleMouseInputListener;
    private LayoutManager layoutManager;
    private LayoutManager savedOldLayout;
    private JRootPane root;
    private WindowListener substanceWindowListener;
    private Window substanceCurrentWindow;
    private HierarchyListener substanceHierarchyListener;
    private ComponentListener substanceWindowComponentListener;
    private GraphicsConfiguration currentRootPaneGC;
    private PropertyChangeListener substancePropertyChangeListener;
    private Cursor lastCursor = Cursor.getPredefinedCursor(0);
    private static int rootPanesWithCustomSkin = 0;
    private Set<SubstanceWidget<JComponent>> lafWidgets;
    private static final int[] cursorMapping = new int[]{6, 6, 8, 7, 7, 6, 0, 0, 0, 7, 10, 0, 0, 0, 11, 4, 0, 0, 0, 5, 4, 4, 9, 5, 5};

    public static ComponentUI createUI(JComponent comp) {
        SubstanceCoreUtilities.testComponentCreationThreadingViolation(comp);
        return new SubstanceRootPaneUI();
    }

    protected SubstanceRootPaneUI() {
    }

    @Override
    public void installUI(JComponent c2) {
        this.lafWidgets = SubstanceWidgetRepository.getRepository().getMatchingWidgets(c2);
        super.installUI(c2);
        this.root = (JRootPane)c2;
        int style = this.root.getWindowDecorationStyle();
        if (style != 0) {
            this.installClientDecorations(this.root);
        }
        if (SubstanceCoreUtilities.isRootPaneModified(this.root)) {
            this.propagateModificationState();
        }
        if (this.root.getClientProperty("substancelaf.internal.rootPaneSkin") instanceof SubstanceSkin) {
            ++rootPanesWithCustomSkin;
        }
        for (SubstanceWidget<JComponent> lafWidget : this.lafWidgets) {
            lafWidget.installUI();
        }
    }

    @Override
    public void uninstallUI(JComponent c2) {
        super.uninstallUI(c2);
        this.uninstallClientDecorations(this.root);
        this.layoutManager = null;
        this.substanceMouseInputListener = null;
        if (this.root.getClientProperty("substancelaf.internal.rootPaneSkin") instanceof SubstanceSkin) {
            --rootPanesWithCustomSkin;
        }
        this.root = null;
        for (SubstanceWidget<JComponent> lafWidget : this.lafWidgets) {
            lafWidget.uninstallUI();
        }
    }

    public void installBorder(JRootPane root) {
        int style = root.getWindowDecorationStyle();
        if (style == 0) {
            LookAndFeel.uninstallBorder(root);
        } else {
            LookAndFeel.installBorder(root, "RootPane.border");
        }
    }

    private void uninstallBorder(JRootPane root) {
        LookAndFeel.uninstallBorder(root);
    }

    @Override
    protected void installDefaults(JRootPane c2) {
        Color backgroundFillColor;
        super.installDefaults(c2);
        Color backgr = c2.getBackground();
        if ((backgr == null || backgr instanceof UIResource) && (backgroundFillColor = SubstanceColorUtilities.getBackgroundFillColor(c2)) != null) {
            c2.setBackground(new ColorUIResource(backgroundFillColor));
        }
        for (SubstanceWidget<JComponent> lafWidget : this.lafWidgets) {
            lafWidget.installDefaults();
        }
    }

    @Override
    protected void uninstallDefaults(JRootPane root) {
        for (SubstanceWidget<JComponent> lafWidget : this.lafWidgets) {
            lafWidget.uninstallDefaults();
        }
        super.uninstallDefaults(root);
    }

    @Override
    public void update(Graphics g2, JComponent c2) {
        if (!SubstanceCoreUtilities.isCurrentLookAndFeel()) {
            return;
        }
        if (SubstanceCoreUtilities.isOpaque(c2)) {
            BackgroundPaintingUtils.update(g2, c2, false);
        }
        super.paint(g2, c2);
    }

    private void installWindowListeners(JRootPane root, Component parent) {
        this.window = parent instanceof Window ? (Window)parent : SwingUtilities.getWindowAncestor(parent);
        if (this.window != null) {
            if (this.substanceMouseInputListener == null) {
                this.substanceMouseInputListener = this.createWindowMouseInputListener(root);
            }
            this.window.addMouseListener(this.substanceMouseInputListener);
            this.window.addMouseMotionListener(this.substanceMouseInputListener);
            if (this.titlePane != null) {
                if (this.substanceTitleMouseInputListener == null) {
                    this.substanceTitleMouseInputListener = new TitleMouseInputHandler();
                }
                this.titlePane.addMouseMotionListener(this.substanceTitleMouseInputListener);
                this.titlePane.addMouseListener(this.substanceTitleMouseInputListener);
            }
        }
    }

    private void uninstallWindowListeners(JRootPane root) {
        if (this.window != null) {
            this.window.removeMouseListener(this.substanceMouseInputListener);
            this.window.removeMouseMotionListener(this.substanceMouseInputListener);
        }
        if (this.titlePane != null) {
            this.titlePane.removeMouseListener(this.substanceTitleMouseInputListener);
            this.titlePane.removeMouseMotionListener(this.substanceTitleMouseInputListener);
        }
    }

    private void installLayout(JRootPane root) {
        if (this.layoutManager == null) {
            this.layoutManager = this.createLayoutManager();
        }
        this.savedOldLayout = root.getLayout();
        root.setLayout(this.layoutManager);
    }

    @Override
    protected void installListeners(JRootPane root) {
        super.installListeners(root);
        this.substanceHierarchyListener = hierarchyEvent -> {
            Container parent = root.getParent();
            if (parent == null) {
                return;
            }
            if (MemoryAnalyzer.isRunning()) {
                MemoryAnalyzer.enqueueUsage("Root pane @" + root.hashCode() + "\n" + SubstanceCoreUtilities.getHierarchy(parent));
            }
            if (parent.getClass().getName().startsWith("org.jdesktop.jdic.tray") || parent.getClass().getName().compareTo("javax.swing.Popup$HeavyWeightWindow") == 0) {
                SwingUtilities.invokeLater(() -> {
                    root.removeHierarchyListener(this.substanceHierarchyListener);
                    this.substanceHierarchyListener = null;
                });
            }
            Window currWindow = null;
            currWindow = parent instanceof Window ? (Window)parent : SwingUtilities.getWindowAncestor(parent);
            if (this.substanceWindowListener != null) {
                this.substanceCurrentWindow.removeWindowListener(this.substanceWindowListener);
                this.substanceWindowListener = null;
            }
            if (this.substanceWindowComponentListener != null) {
                this.substanceCurrentWindow.removeComponentListener(this.substanceWindowComponentListener);
                this.substanceWindowComponentListener = null;
            }
            if (currWindow != null) {
                this.substanceWindowListener = new WindowAdapter(){

                    @Override
                    public void windowClosed(WindowEvent e2) {
                        SubstanceCoreUtilities.testWindowCloseThreadingViolation(e2.getWindow());
                        SwingUtilities.invokeLater(() -> {
                            Frame[] frames;
                            for (Frame frame : frames = Frame.getFrames()) {
                                if (!frame.isDisplayable()) continue;
                                return;
                            }
                            SubstanceCoreUtilities.stopThreads();
                        });
                    }
                };
                if (!(parent instanceof JInternalFrame)) {
                    currWindow.addWindowListener(this.substanceWindowListener);
                }
                this.substanceWindowComponentListener = new ComponentAdapter(){

                    @Override
                    public void componentMoved(ComponentEvent e2) {
                        this.processNewPosition();
                    }

                    @Override
                    public void componentResized(ComponentEvent e2) {
                        this.processNewPosition();
                    }

                    protected void processNewPosition() {
                        SwingUtilities.invokeLater(() -> {
                            if (SubstanceRootPaneUI.this.window == null) {
                                return;
                            }
                            if (!SubstanceRootPaneUI.this.window.isShowing() || !SubstanceRootPaneUI.this.window.isDisplayable()) {
                                SubstanceRootPaneUI.this.currentRootPaneGC = null;
                                return;
                            }
                            GraphicsEnvironment ge2 = GraphicsEnvironment.getLocalGraphicsEnvironment();
                            GraphicsDevice[] gds = ge2.getScreenDevices();
                            if (gds.length == 1) {
                                return;
                            }
                            Point midLoc = new Point(((SubstanceRootPaneUI)SubstanceRootPaneUI.this).window.getLocationOnScreen().x + SubstanceRootPaneUI.this.window.getWidth() / 2, ((SubstanceRootPaneUI)SubstanceRootPaneUI.this).window.getLocationOnScreen().y + SubstanceRootPaneUI.this.window.getHeight() / 2);
                            for (GraphicsDevice gd2 : gds) {
                                GraphicsConfiguration gc2 = gd2.getDefaultConfiguration();
                                Rectangle bounds = gc2.getBounds();
                                if (!bounds.contains(midLoc)) continue;
                                if (gc2 == SubstanceRootPaneUI.this.currentRootPaneGC) break;
                                SubstanceRootPaneUI.this.currentRootPaneGC = gc2;
                                break;
                            }
                        });
                    }
                };
                if (parent instanceof JFrame) {
                    currWindow.addComponentListener(this.substanceWindowComponentListener);
                }
                this.window = currWindow;
            }
            this.substanceCurrentWindow = currWindow;
        };
        root.addHierarchyListener(this.substanceHierarchyListener);
        this.substancePropertyChangeListener = propertyChangeEvent -> {
            if ("substancelaf.internal.contentsModified".equals(propertyChangeEvent.getPropertyName())) {
                this.propagateModificationState();
            }
        };
        root.addPropertyChangeListener(this.substancePropertyChangeListener);
        for (SubstanceWidget<JComponent> lafWidget : this.lafWidgets) {
            lafWidget.installListeners();
        }
    }

    @Override
    protected void uninstallListeners(JRootPane root) {
        if (this.window != null) {
            this.window.removeWindowListener(this.substanceWindowListener);
            this.substanceWindowListener = null;
            this.window.removeComponentListener(this.substanceWindowComponentListener);
            this.substanceWindowComponentListener = null;
        }
        root.removeHierarchyListener(this.substanceHierarchyListener);
        this.substanceHierarchyListener = null;
        root.removePropertyChangeListener(this.substancePropertyChangeListener);
        this.substancePropertyChangeListener = null;
        for (SubstanceWidget<JComponent> lafWidget : this.lafWidgets) {
            lafWidget.uninstallListeners();
        }
        super.uninstallListeners(root);
    }

    @Override
    protected void installComponents(JRootPane root) {
        super.installComponents(root);
        for (SubstanceWidget<JComponent> lafWidget : this.lafWidgets) {
            lafWidget.installComponents();
        }
    }

    @Override
    protected void uninstallComponents(JRootPane root) {
        for (SubstanceWidget<JComponent> lafWidget : this.lafWidgets) {
            lafWidget.uninstallComponents();
        }
        super.uninstallComponents(root);
    }

    private void uninstallLayout(JRootPane root) {
        if (this.savedOldLayout != null) {
            root.setLayout(this.savedOldLayout);
            this.savedOldLayout = null;
        }
    }

    private void installClientDecorations(JRootPane root) {
        Object preferredTitlePaneHeight;
        this.installBorder(root);
        SubstanceTitlePane titlePane = this.createTitlePane(root);
        this.setTitlePane(root, titlePane);
        if (Boolean.TRUE.equals(root.getClientProperty("substancelaf.internal.rootPaneContentExtendsIntoTitlePane"))) {
            this.extendContentIntoTitlePane();
        }
        if ((preferredTitlePaneHeight = root.getClientProperty("substancelaf.internal.rootPanePreferredTitlePaneHeight")) != null) {
            this.setPreferredTitlePaneHeight((Integer)preferredTitlePaneHeight);
        }
        this.installWindowListeners(root, root.getParent());
        this.installLayout(root);
        if (this.window != null) {
            root.revalidate();
            root.repaint();
        }
    }

    private void uninstallClientDecorations(JRootPane root) {
        this.uninstallBorder(root);
        this.uninstallWindowListeners(root);
        this.setTitlePane(root, null);
        this.uninstallLayout(root);
        int style = root.getWindowDecorationStyle();
        if (style == 0) {
            root.repaint();
            root.revalidate();
        }
        if (this.window != null) {
            this.window.setCursor(Cursor.getPredefinedCursor(0));
        }
        this.window = null;
    }

    protected SubstanceTitlePane createTitlePane(JRootPane root) {
        return new SubstanceTitlePane(root, this);
    }

    private MouseInputListener createWindowMouseInputListener(JRootPane root) {
        return new MouseInputHandler();
    }

    protected LayoutManager createLayoutManager() {
        return new SubstanceRootLayout();
    }

    private void setTitlePane(JRootPane root, SubstanceTitlePane titlePane) {
        JLayeredPane layeredPane = root.getLayeredPane();
        if (this.titlePane != null) {
            this.titlePane.uninstall();
            layeredPane.remove(this.titlePane);
        }
        if (titlePane != null) {
            layeredPane.add((Component)titlePane, JLayeredPane.FRAME_CONTENT_LAYER);
            titlePane.setVisible(true);
        }
        this.titlePane = titlePane;
    }

    public JComponent getTitlePane() {
        return this.titlePane;
    }

    public JButton createTitlePaneControlButton() {
        if (this.titlePane == null) {
            return null;
        }
        return this.titlePane.createControlButton();
    }

    public Insets getTitlePaneControlInsets() {
        if (this.titlePane == null) {
            return null;
        }
        return this.titlePane.getControlInsets();
    }

    public void extendContentIntoTitlePane() {
        if (this.titlePane == null) {
            throw new IllegalStateException("This root pane has not been marked to be decorated");
        }
        this.isContentExtendingIntoTitlePane = true;
        this.titlePane.setControlOnlyMode();
        Container titlePaneParent = this.titlePane.getParent();
        titlePaneParent.setComponentZOrder(this.titlePane, 0);
        titlePaneParent.invalidate();
    }

    public void setPreferredTitlePaneHeight(int preferredTitlePaneHeight) {
        if (this.titlePane == null) {
            throw new IllegalStateException("This root pane has not been marked to be decorated");
        }
        this.titlePane.setPreferredHeight(preferredTitlePaneHeight);
        this.titlePane.getParent().invalidate();
    }

    protected JRootPane getRootPane() {
        return this.root;
    }

    @Override
    public void propertyChange(PropertyChangeEvent e2) {
        super.propertyChange(e2);
        String propertyName = e2.getPropertyName();
        if (propertyName == null) {
            return;
        }
        if (propertyName.equals("windowDecorationStyle")) {
            JRootPane root = (JRootPane)e2.getSource();
            int style = root.getWindowDecorationStyle();
            this.uninstallClientDecorations(root);
            if (style != 0) {
                this.installClientDecorations(root);
            }
        }
        if (propertyName.equals("ancestor")) {
            this.uninstallWindowListeners(this.root);
            if (((JRootPane)e2.getSource()).getWindowDecorationStyle() != 0) {
                this.installWindowListeners(this.root, this.root.getParent());
            }
        }
        if (propertyName.equals("background")) {
            SubstanceCoreUtilities.getTitlePaneComponent(this.window).setBackground((Color)e2.getNewValue());
        }
        if (propertyName.equals("substancelaf.internal.rootPaneSkin")) {
            SubstanceSkin oldValue = (SubstanceSkin)e2.getOldValue();
            SubstanceSkin newValue = (SubstanceSkin)e2.getNewValue();
            if (oldValue == null && newValue != null) {
                ++rootPanesWithCustomSkin;
            }
            if (oldValue != null && newValue == null) {
                --rootPanesWithCustomSkin;
            }
        }
    }

    private void propagateModificationState() {
        if (this.titlePane != null) {
            this.titlePane.getCloseButton().putClientProperty("substancelaf.internal.contentsModified", this.root.getClientProperty("substancelaf.internal.contentsModified"));
            return;
        }
        JInternalFrame jif = (JInternalFrame)SwingUtilities.getAncestorOfClass(JInternalFrame.class, this.root);
        if (jif != null) {
            SubstanceInternalFrameUI internalFrameUI = (SubstanceInternalFrameUI)jif.getUI();
            internalFrameUI.setWindowModified(Boolean.TRUE.equals(this.root.getClientProperty("substancelaf.internal.contentsModified")));
        }
    }

    public static boolean hasCustomSkinOnAtLeastOneRootPane() {
        return rootPanesWithCustomSkin > 0;
    }

    private boolean isMouseEventInExtendedTitlePane(MouseEvent ev) {
        Point point = ev.getPoint();
        Component source = (Component)ev.getSource();
        if (this.titlePane == null) {
            return false;
        }
        if (!this.isContentExtendingIntoTitlePane) {
            return this.titlePane != null && this.titlePane.contains(SwingUtilities.convertPoint(source, point, this.titlePane));
        }
        JLayeredPane layeredPane = this.root.getLayeredPane();
        Insets layeredPaneInsets = layeredPane.getInsets();
        Point convertedPoint = SwingUtilities.convertPoint(source, point, layeredPane);
        convertedPoint.x += layeredPaneInsets.left;
        convertedPoint.y += layeredPaneInsets.top;
        Rectangle titlePaneRect = new Rectangle(0, 0, layeredPane.getWidth() - layeredPaneInsets.left - layeredPaneInsets.right, this.titlePane.getHeight());
        return titlePaneRect.contains(convertedPoint);
    }

    private class TitleMouseInputHandler
    extends MouseInputAdapter {
        private Point dragOffset = new Point(0, 0);

        private TitleMouseInputHandler() {
        }

        @Override
        public void mousePressed(MouseEvent ev) {
            JRootPane rootPane = SubstanceRootPaneUI.this.getRootPane();
            if (rootPane.getWindowDecorationStyle() == 0) {
                return;
            }
            Point dragWindowOffset = ev.getPoint();
            Component source = (Component)ev.getSource();
            dragWindowOffset = SwingUtilities.convertPoint(source, dragWindowOffset, SubstanceRootPaneUI.this.window);
            if (SubstanceRootPaneUI.this.isMouseEventInExtendedTitlePane(ev) && SubstanceRootPaneUI.this.window != null) {
                SubstanceRootPaneUI.this.window.toFront();
                this.dragOffset = dragWindowOffset;
            }
        }

        @Override
        public void mouseDragged(MouseEvent ev) {
            Component source = (Component)ev.getSource();
            Point eventLocationOnScreen = ev.getLocationOnScreen();
            if (eventLocationOnScreen == null) {
                eventLocationOnScreen = new Point(ev.getX() + source.getLocationOnScreen().x, ev.getY() + source.getLocationOnScreen().y);
            }
            if (SubstanceRootPaneUI.this.window instanceof Frame) {
                int frameState;
                Frame f2 = (Frame)SubstanceRootPaneUI.this.window;
                int n2 = frameState = f2 != null ? f2.getExtendedState() : 0;
                if (f2 != null && (frameState & 6) == 0) {
                    SubstanceRootPaneUI.this.window.setLocation(eventLocationOnScreen.x - this.dragOffset.x, eventLocationOnScreen.y - this.dragOffset.y);
                }
            } else {
                SubstanceRootPaneUI.this.window.setLocation(eventLocationOnScreen.x - this.dragOffset.x, eventLocationOnScreen.y - this.dragOffset.y);
            }
        }

        @Override
        public void mouseClicked(MouseEvent ev) {
            Frame f2 = null;
            if (!(SubstanceRootPaneUI.this.window instanceof Frame)) {
                return;
            }
            f2 = (Frame)SubstanceRootPaneUI.this.window;
            int state = f2.getExtendedState();
            if (SubstanceRootPaneUI.this.isMouseEventInExtendedTitlePane(ev) && ev.getClickCount() % 2 == 0 && ev.getButton() == 1 && f2.isResizable()) {
                if ((state & 6) != 0) {
                    f2.setExtendedState(state & 0xFFFFFFF9);
                } else {
                    f2.setExtendedState(state | 6);
                }
                return;
            }
        }
    }

    private class MouseInputHandler
    implements MouseInputListener {
        private boolean isMovingWindow;
        private boolean isMousePressed;
        private int dragCursor;
        private int dragOffsetX;
        private int dragOffsetY;
        private int dragWidth;
        private int dragHeight;
        private final PrivilegedExceptionAction<Point> getLocationAction = () -> MouseInfo.getPointerInfo().getLocation();
        private CursorState cursorState = CursorState.NIL;

        private MouseInputHandler() {
        }

        @Override
        public void mousePressed(MouseEvent ev) {
            int frameState;
            JRootPane rootPane = SubstanceRootPaneUI.this.getRootPane();
            this.isMousePressed = true;
            if (SubstanceRootPaneUI.this.titlePane == null || rootPane.getWindowDecorationStyle() == 0) {
                return;
            }
            Point dragWindowOffset = ev.getPoint();
            Window w2 = (Window)ev.getSource();
            if (w2 != null) {
                w2.toFront();
            }
            Frame f2 = null;
            Dialog d2 = null;
            if (w2 instanceof Frame) {
                f2 = (Frame)w2;
            } else if (w2 instanceof Dialog) {
                d2 = (Dialog)w2;
            }
            int n2 = frameState = f2 != null ? f2.getExtendedState() : 0;
            if (SubstanceRootPaneUI.this.isMouseEventInExtendedTitlePane(ev)) {
                if ((f2 != null && (frameState & 6) == 0 || d2 != null) && dragWindowOffset.y >= 5 && dragWindowOffset.x >= 5 && dragWindowOffset.x < w2.getWidth() - 5) {
                    this.isMovingWindow = true;
                    this.dragOffsetX = dragWindowOffset.x;
                    this.dragOffsetY = dragWindowOffset.y;
                }
            } else if (f2 != null && f2.isResizable() && (frameState & 6) == 0 || d2 != null && d2.isResizable()) {
                this.dragOffsetX = dragWindowOffset.x;
                this.dragOffsetY = dragWindowOffset.y;
                this.dragWidth = w2.getWidth();
                this.dragHeight = w2.getHeight();
                this.dragCursor = this.getCursor(this.calculateCorner(w2, dragWindowOffset.x, dragWindowOffset.y));
            }
        }

        @Override
        public void mouseReleased(MouseEvent ev) {
            if (this.dragCursor != 0 && SubstanceRootPaneUI.this.window != null && !SubstanceRootPaneUI.this.window.isValid()) {
                SubstanceRootPaneUI.this.window.validate();
                SubstanceRootPaneUI.this.getRootPane().repaint();
            }
            this.isMousePressed = false;
            this.isMovingWindow = false;
            this.dragCursor = 0;
        }

        @Override
        public void mouseMoved(MouseEvent ev) {
            boolean isDialogResizable;
            JRootPane root = SubstanceRootPaneUI.this.getRootPane();
            if (root.getWindowDecorationStyle() == 0) {
                return;
            }
            Window w2 = (Window)ev.getSource();
            Frame f2 = null;
            Dialog d2 = null;
            if (w2 instanceof Frame) {
                f2 = (Frame)w2;
            } else if (w2 instanceof Dialog) {
                d2 = (Dialog)w2;
            }
            int cursor = this.getCursor(this.calculateCorner(w2, ev.getX(), ev.getY()));
            boolean isFrameResizable = f2 != null && f2.isResizable() && (f2.getExtendedState() & 6) == 0;
            boolean bl = isDialogResizable = d2 != null && d2.isResizable();
            if (cursor != 0 && (isFrameResizable || isDialogResizable)) {
                w2.setCursor(Cursor.getPredefinedCursor(cursor));
            } else {
                w2.setCursor(SubstanceRootPaneUI.this.lastCursor);
                SubstanceRootPaneUI.this.lastCursor = null;
            }
        }

        private void adjust(Rectangle bounds, Dimension min, int deltaX, int deltaY, int deltaWidth, int deltaHeight) {
            bounds.x += deltaX;
            bounds.y += deltaY;
            bounds.width += deltaWidth;
            bounds.height += deltaHeight;
            if (min != null) {
                int correction;
                if (bounds.width < min.width) {
                    correction = min.width - bounds.width;
                    if (deltaX != 0) {
                        bounds.x -= correction;
                    }
                    bounds.width = min.width;
                }
                if (bounds.height < min.height) {
                    correction = min.height - bounds.height;
                    if (deltaY != 0) {
                        bounds.y -= correction;
                    }
                    bounds.height = min.height;
                }
            }
        }

        @Override
        public void mouseDragged(MouseEvent ev) {
            Window w2 = (Window)ev.getSource();
            Point pt = ev.getPoint();
            if (this.isMovingWindow) {
                try {
                    Point windowPt = AccessController.doPrivileged(this.getLocationAction);
                    windowPt.x -= this.dragOffsetX;
                    windowPt.y -= this.dragOffsetY;
                    w2.setLocation(windowPt);
                }
                catch (PrivilegedActionException privilegedActionException) {}
            } else if (this.dragCursor != 0) {
                Rectangle r2 = w2.getBounds();
                Rectangle startBounds = new Rectangle(r2);
                Dimension min = w2.getMinimumSize();
                switch (this.dragCursor) {
                    case 11: {
                        this.adjust(r2, min, 0, 0, pt.x + (this.dragWidth - this.dragOffsetX) - r2.width, 0);
                        break;
                    }
                    case 9: {
                        this.adjust(r2, min, 0, 0, 0, pt.y + (this.dragHeight - this.dragOffsetY) - r2.height);
                        break;
                    }
                    case 8: {
                        this.adjust(r2, min, 0, pt.y - this.dragOffsetY, 0, -(pt.y - this.dragOffsetY));
                        break;
                    }
                    case 10: {
                        this.adjust(r2, min, pt.x - this.dragOffsetX, 0, -(pt.x - this.dragOffsetX), 0);
                        break;
                    }
                    case 7: {
                        this.adjust(r2, min, 0, pt.y - this.dragOffsetY, pt.x + (this.dragWidth - this.dragOffsetX) - r2.width, -(pt.y - this.dragOffsetY));
                        break;
                    }
                    case 5: {
                        this.adjust(r2, min, 0, 0, pt.x + (this.dragWidth - this.dragOffsetX) - r2.width, pt.y + (this.dragHeight - this.dragOffsetY) - r2.height);
                        break;
                    }
                    case 6: {
                        this.adjust(r2, min, pt.x - this.dragOffsetX, pt.y - this.dragOffsetY, -(pt.x - this.dragOffsetX), -(pt.y - this.dragOffsetY));
                        break;
                    }
                    case 4: {
                        this.adjust(r2, min, pt.x - this.dragOffsetX, 0, -(pt.x - this.dragOffsetX), pt.y + (this.dragHeight - this.dragOffsetY) - r2.height);
                        break;
                    }
                }
                if (!r2.equals(startBounds)) {
                    w2.setBounds(r2);
                    if (Toolkit.getDefaultToolkit().isDynamicLayoutActive()) {
                        w2.validate();
                        SubstanceRootPaneUI.this.getRootPane().repaint();
                    }
                }
            }
        }

        @Override
        public void mouseEntered(MouseEvent ev) {
            if (this.isMousePressed) {
                return;
            }
            Window w2 = (Window)ev.getSource();
            if (SubstanceRootPaneUI.this.lastCursor == null && this.cursorState != CursorState.ENTERED) {
                SubstanceRootPaneUI.this.lastCursor = w2.getCursor();
            }
            this.cursorState = CursorState.ENTERED;
            this.mouseMoved(ev);
        }

        @Override
        public void mouseExited(MouseEvent ev) {
            if (this.isMousePressed) {
                return;
            }
            Window w2 = (Window)ev.getSource();
            w2.setCursor(SubstanceRootPaneUI.this.lastCursor);
            SubstanceRootPaneUI.this.lastCursor = null;
            this.cursorState = CursorState.EXITED;
        }

        @Override
        public void mouseClicked(MouseEvent ev) {
            Window w2 = (Window)ev.getSource();
            Frame f2 = null;
            if (!(w2 instanceof Frame)) {
                return;
            }
            f2 = (Frame)w2;
            if (SubstanceRootPaneUI.this.titlePane == null) {
                return;
            }
            int state = f2.getExtendedState();
            if (SubstanceRootPaneUI.this.isMouseEventInExtendedTitlePane(ev) && ev.getClickCount() % 2 == 0 && ev.getButton() == 1 && f2.isResizable()) {
                if ((state & 6) != 0) {
                    f2.setExtendedState(state & 0xFFFFFFF9);
                } else {
                    f2.setExtendedState(state | 6);
                }
            }
        }

        private int calculateCorner(Window w2, int x2, int y2) {
            Insets insets = w2.getInsets();
            int xPosition = this.calculatePosition(x2 - insets.left, w2.getWidth() - insets.left - insets.right);
            int yPosition = this.calculatePosition(y2 - insets.top, w2.getHeight() - insets.top - insets.bottom);
            if (xPosition == -1 || yPosition == -1) {
                return -1;
            }
            return yPosition * 5 + xPosition;
        }

        private int getCursor(int corner) {
            if (corner == -1) {
                return 0;
            }
            return cursorMapping[corner];
        }

        private int calculatePosition(int spot, int width) {
            if (spot < 5) {
                return 0;
            }
            if (spot < 16) {
                return 1;
            }
            if (spot >= width - 5) {
                return 4;
            }
            if (spot >= width - 16) {
                return 3;
            }
            return 2;
        }
    }

    protected class SubstanceRootLayout
    implements LayoutManager2 {
        protected SubstanceRootLayout() {
        }

        @Override
        public Dimension preferredLayoutSize(Container parent) {
            Dimension tpd;
            JComponent titlePane;
            Dimension mbd;
            int cpWidth = 0;
            int cpHeight = 0;
            int mbWidth = 0;
            int mbHeight = 0;
            int tpWidth = 0;
            int tpHeight = 0;
            Insets i2 = parent.getInsets();
            JRootPane root = (JRootPane)parent;
            Dimension cpd = root.getContentPane() != null ? root.getContentPane().getPreferredSize() : root.getSize();
            if (cpd != null) {
                cpWidth = cpd.width;
                cpHeight = cpd.height;
            }
            if (root.getJMenuBar() != null && (mbd = root.getJMenuBar().getPreferredSize()) != null) {
                mbWidth = mbd.width;
                mbHeight = mbd.height;
            }
            if (root.getWindowDecorationStyle() != 0 && root.getUI() instanceof SubstanceRootPaneUI && (titlePane = ((SubstanceRootPaneUI)root.getUI()).getTitlePane()) != null && (tpd = titlePane.getPreferredSize()) != null) {
                tpWidth = tpd.width;
                tpHeight = tpd.height;
            }
            return new Dimension(Math.max(Math.max(cpWidth, mbWidth), tpWidth) + i2.left + i2.right, cpHeight + mbHeight + tpHeight + i2.top + i2.bottom);
        }

        @Override
        public Dimension minimumLayoutSize(Container parent) {
            Dimension tpd;
            JComponent titlePane;
            Dimension mbd;
            int cpWidth = 0;
            int cpHeight = 0;
            int mbWidth = 0;
            int mbHeight = 0;
            int tpWidth = 0;
            int tpHeight = 0;
            Insets i2 = parent.getInsets();
            JRootPane root = (JRootPane)parent;
            Dimension cpd = root.getContentPane() != null ? root.getContentPane().getMinimumSize() : root.getSize();
            if (cpd != null) {
                cpWidth = cpd.width;
                cpHeight = cpd.height;
            }
            if (root.getJMenuBar() != null && (mbd = root.getJMenuBar().getMinimumSize()) != null) {
                mbWidth = mbd.width;
                mbHeight = mbd.height;
            }
            if (root.getWindowDecorationStyle() != 0 && root.getUI() instanceof SubstanceRootPaneUI && (titlePane = ((SubstanceRootPaneUI)root.getUI()).getTitlePane()) != null && (tpd = titlePane.getMinimumSize()) != null) {
                tpWidth = tpd.width;
                tpHeight = tpd.height;
            }
            return new Dimension(Math.max(Math.max(cpWidth, mbWidth), tpWidth) + i2.left + i2.right, cpHeight + mbHeight + tpHeight + i2.top + i2.bottom);
        }

        @Override
        public Dimension maximumLayoutSize(Container target) {
            int maxWidth;
            int maxHeight;
            Dimension tpd;
            JComponent titlePane;
            Dimension mbd;
            Dimension cpd;
            int cpWidth = Integer.MAX_VALUE;
            int cpHeight = Integer.MAX_VALUE;
            int mbWidth = Integer.MAX_VALUE;
            int mbHeight = Integer.MAX_VALUE;
            int tpWidth = Integer.MAX_VALUE;
            int tpHeight = Integer.MAX_VALUE;
            Insets i2 = target.getInsets();
            JRootPane root = (JRootPane)target;
            if (root.getContentPane() != null && (cpd = root.getContentPane().getMaximumSize()) != null) {
                cpWidth = cpd.width;
                cpHeight = cpd.height;
            }
            if (root.getJMenuBar() != null && (mbd = root.getJMenuBar().getMaximumSize()) != null) {
                mbWidth = mbd.width;
                mbHeight = mbd.height;
            }
            if (root.getWindowDecorationStyle() != 0 && root.getUI() instanceof SubstanceRootPaneUI && (titlePane = ((SubstanceRootPaneUI)root.getUI()).getTitlePane()) != null && (tpd = titlePane.getMaximumSize()) != null) {
                tpWidth = tpd.width;
                tpHeight = tpd.height;
            }
            if ((maxHeight = Math.max(Math.max(cpHeight, mbHeight), tpHeight)) != Integer.MAX_VALUE) {
                maxHeight = cpHeight + mbHeight + tpHeight + i2.top + i2.bottom;
            }
            if ((maxWidth = Math.max(Math.max(cpWidth, mbWidth), tpWidth)) != Integer.MAX_VALUE) {
                maxWidth += i2.left + i2.right;
            }
            return new Dimension(maxWidth, maxHeight);
        }

        @Override
        public void layoutContainer(Container parent) {
            Dimension tpd;
            JRootPane root = (JRootPane)parent;
            Rectangle b2 = root.getBounds();
            Insets i2 = root.getInsets();
            int nextY = 0;
            int w2 = b2.width - i2.right - i2.left;
            int h2 = b2.height - i2.top - i2.bottom;
            if (root.getLayeredPane() != null) {
                root.getLayeredPane().setBounds(i2.left, i2.top, w2, h2);
            }
            if (root.getGlassPane() != null) {
                root.getGlassPane().setBounds(i2.left, i2.top, w2, h2);
            }
            if (root.getWindowDecorationStyle() != 0 && root.getUI() instanceof SubstanceRootPaneUI && SubstanceRootPaneUI.this.titlePane != null && (tpd = SubstanceRootPaneUI.this.titlePane.getPreferredSize()) != null) {
                int tpHeight = tpd.height;
                if (!SubstanceRootPaneUI.this.isContentExtendingIntoTitlePane) {
                    SubstanceRootPaneUI.this.titlePane.setBounds(0, 0, w2, tpHeight);
                    nextY += tpHeight;
                } else {
                    boolean controlButtonsOnRight = SubstanceTitlePaneUtilities.areTitlePaneControlButtonsOnRight(root);
                    Insets titlePaneControlInsets = SubstanceRootPaneUI.this.titlePane.getControlInsets();
                    int titlePaneWidth = controlButtonsOnRight ? titlePaneControlInsets.right : titlePaneControlInsets.left;
                    int titlePaneX = controlButtonsOnRight ? w2 - titlePaneWidth : 0;
                    SubstanceRootPaneUI.this.titlePane.setBounds(titlePaneX, 0, titlePaneWidth, tpHeight);
                }
            }
            if (root.getJMenuBar() != null) {
                Dimension mbd = root.getJMenuBar().getPreferredSize();
                root.getJMenuBar().setBounds(0, nextY, w2, mbd.height);
                nextY += mbd.height;
            }
            if (root.getContentPane() != null) {
                root.getContentPane().setBounds(0, nextY, w2, h2 < nextY ? 0 : h2 - nextY);
            }
        }

        @Override
        public void addLayoutComponent(String name, Component comp) {
        }

        @Override
        public void removeLayoutComponent(Component comp) {
        }

        @Override
        public void addLayoutComponent(Component comp, Object constraints) {
        }

        @Override
        public float getLayoutAlignmentX(Container target) {
            return 0.0f;
        }

        @Override
        public float getLayoutAlignmentY(Container target) {
            return 0.0f;
        }

        @Override
        public void invalidateLayout(Container target) {
        }
    }

    private static enum CursorState {
        EXITED,
        ENTERED,
        NIL;

    }
}

