/*
 * Decompiled with CFR 0.152.
 */
package org.pushingpixels.substance.internal.ui;

import java.awt.Color;
import java.awt.Graphics;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.plaf.ColorUIResource;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.UIResource;
import javax.swing.plaf.basic.BasicPanelUI;
import org.pushingpixels.substance.internal.painter.BackgroundPaintingUtils;
import org.pushingpixels.substance.internal.utils.SubstanceColorUtilities;
import org.pushingpixels.substance.internal.utils.SubstanceCoreUtilities;
import org.pushingpixels.substance.internal.widget.animation.effects.GhostPaintingUtils;

public class SubstancePanelUI
extends BasicPanelUI {
    public static ComponentUI createUI(JComponent comp) {
        SubstanceCoreUtilities.testComponentCreationThreadingViolation(comp);
        return new SubstancePanelUI();
    }

    private SubstancePanelUI() {
    }

    @Override
    protected void installDefaults(JPanel p2) {
        Color backgroundFillColor;
        super.installDefaults(p2);
        Color backgr = p2.getBackground();
        if ((backgr == null || backgr instanceof UIResource) && (backgroundFillColor = SubstanceColorUtilities.getBackgroundFillColor(p2)) != null) {
            p2.setBackground(new ColorUIResource(backgroundFillColor));
        }
    }

    @Override
    public void update(Graphics g2, JComponent c2) {
        if (!SubstanceCoreUtilities.isCurrentLookAndFeel()) {
            return;
        }
        if (this.toPaintBackground(c2)) {
            BackgroundPaintingUtils.update(g2, c2, false);
        }
        super.paint(g2, c2);
        GhostPaintingUtils.paintGhostImages(c2, g2);
    }

    private boolean toPaintBackground(JComponent c2) {
        return SubstanceCoreUtilities.isOpaque(c2);
    }
}

