/*
 * Decompiled with CFR 0.152.
 */
package org.pushingpixels.substance.internal.ui;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.beans.PropertyChangeListener;
import javax.swing.ButtonModel;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.LookAndFeel;
import javax.swing.MenuElement;
import javax.swing.MenuSelectionManager;
import javax.swing.SwingUtilities;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.basic.BasicMenuUI;
import org.pushingpixels.neon.api.NeonCortex;
import org.pushingpixels.substance.api.SubstanceCortex;
import org.pushingpixels.substance.api.SubstanceSlices;
import org.pushingpixels.substance.internal.animation.StateTransitionTracker;
import org.pushingpixels.substance.internal.animation.TransitionAwareUI;
import org.pushingpixels.substance.internal.utils.SubstanceCoreUtilities;
import org.pushingpixels.substance.internal.utils.SubstanceSizeUtils;
import org.pushingpixels.substance.internal.utils.icon.MenuArrowIcon;
import org.pushingpixels.substance.internal.utils.menu.MenuUtilities;
import org.pushingpixels.substance.internal.utils.menu.SubstanceMenu;
import org.pushingpixels.substance.internal.widget.animation.effects.GhostPaintingUtils;

public class SubstanceMenuUI
extends BasicMenuUI
implements SubstanceMenu,
TransitionAwareUI {
    private MouseListener substanceMouseListener;
    private StateTransitionTracker stateTransitionTracker;
    private MenuUtilities.MenuPropertyListener substanceMenuPropertyListener;
    private PropertyChangeListener substancePropertyListener;
    private FocusListener substanceFocusListener;

    public static ComponentUI createUI(JComponent comp) {
        SubstanceCoreUtilities.testComponentCreationThreadingViolation(comp);
        return new SubstanceMenuUI((JMenu)comp);
    }

    private SubstanceMenuUI(JMenu menuItem) {
        this.stateTransitionTracker = new StateTransitionTracker(menuItem, menuItem.getModel());
    }

    @Override
    protected void installDefaults() {
        super.installDefaults();
        this.menuItem.setRolloverEnabled(true);
        this.arrowIcon = new MenuArrowIcon((JMenu)this.menuItem);
        this.defaultTextIconGap = SubstanceSizeUtils.getTextIconGap(SubstanceSizeUtils.getComponentFontSize(this.menuItem));
        SubstanceCortex.ComponentOrParentScope.setBackgroundAppearanceStrategy(this.menuItem, SubstanceSlices.BackgroundAppearanceStrategy.FLAT);
        LookAndFeel.installProperty(this.menuItem, "opaque", Boolean.FALSE);
    }

    @Override
    protected void installListeners() {
        super.installListeners();
        this.substanceMenuPropertyListener = new MenuUtilities.MenuPropertyListener(this.menuItem);
        this.substanceMenuPropertyListener.install();
        this.stateTransitionTracker.registerModelListeners();
        this.substanceMouseListener = new MouseAdapter(){

            private boolean toRepaint() {
                MenuElement[] selectedMenuPath;
                for (MenuElement elem : selectedMenuPath = MenuSelectionManager.defaultManager().getSelectedPath()) {
                    if (elem != SubstanceMenuUI.this.menuItem) continue;
                    return true;
                }
                return selectedMenuPath.length == 0;
            }

            @Override
            public void mouseEntered(MouseEvent e2) {
                if (this.toRepaint()) {
                    SubstanceMenuUI.this.stateTransitionTracker.turnOffModelChangeTracking();
                    SubstanceMenuUI.this.menuItem.getModel().setRollover(true);
                    SubstanceMenuUI.this.stateTransitionTracker.onModelStateChanged();
                    Rectangle bounds = SubstanceMenuUI.this.menuItem.getBounds();
                    SubstanceMenuUI.this.menuItem.getParent().repaint(bounds.x, bounds.y, bounds.width, bounds.height);
                }
            }

            @Override
            public void mouseExited(MouseEvent e2) {
                if (this.toRepaint()) {
                    SubstanceMenuUI.this.stateTransitionTracker.turnOffModelChangeTracking();
                    SubstanceMenuUI.this.menuItem.getModel().setRollover(false);
                    SubstanceMenuUI.this.stateTransitionTracker.onModelStateChanged();
                    Rectangle bounds = SubstanceMenuUI.this.menuItem.getBounds();
                    SubstanceMenuUI.this.menuItem.getParent().repaint(bounds.x, bounds.y, bounds.width, bounds.height);
                }
            }
        };
        this.menuItem.addMouseListener(this.substanceMouseListener);
        this.substanceFocusListener = new FocusAdapter(){

            private boolean toRepaint() {
                MenuElement[] selectedMenuPath;
                for (MenuElement elem : selectedMenuPath = MenuSelectionManager.defaultManager().getSelectedPath()) {
                    if (elem != SubstanceMenuUI.this.menuItem) continue;
                    return true;
                }
                return selectedMenuPath.length == 0;
            }

            @Override
            public void focusLost(FocusEvent e2) {
                if (this.toRepaint()) {
                    SubstanceMenuUI.this.stateTransitionTracker.turnOffModelChangeTracking();
                    SubstanceMenuUI.this.menuItem.getModel().setRollover(false);
                    SubstanceMenuUI.this.stateTransitionTracker.onModelStateChanged();
                    Rectangle bounds = SubstanceMenuUI.this.menuItem.getBounds();
                    SubstanceMenuUI.this.menuItem.getParent().repaint(bounds.x, bounds.y, bounds.width, bounds.height);
                }
            }
        };
        this.menuItem.addFocusListener(this.substanceFocusListener);
        this.substancePropertyListener = propertyChangeEvent -> {
            if ("model".equals(propertyChangeEvent.getPropertyName())) {
                this.stateTransitionTracker.setModel((ButtonModel)propertyChangeEvent.getNewValue());
            }
            if ("font".equals(propertyChangeEvent.getPropertyName())) {
                SwingUtilities.invokeLater(() -> {
                    if (this.menuItem != null) {
                        this.menuItem.updateUI();
                    }
                });
            }
        };
        this.menuItem.addPropertyChangeListener(this.substancePropertyListener);
    }

    @Override
    protected void uninstallListeners() {
        super.uninstallListeners();
        this.substanceMenuPropertyListener.uninstall();
        this.substanceMenuPropertyListener = null;
        this.menuItem.removeMouseListener(this.substanceMouseListener);
        this.substanceMouseListener = null;
        this.menuItem.removeFocusListener(this.substanceFocusListener);
        this.substanceFocusListener = null;
        this.menuItem.removePropertyChangeListener(this.substancePropertyListener);
        this.substancePropertyListener = null;
        this.stateTransitionTracker.unregisterModelListeners();
    }

    @Override
    public JMenuItem getAssociatedMenuItem() {
        return this.menuItem;
    }

    @Override
    public Font getAcceleratorFont() {
        return this.acceleratorFont;
    }

    @Override
    public Icon getArrowIcon() {
        return this.arrowIcon;
    }

    @Override
    public Icon getCheckIcon() {
        return null;
    }

    @Override
    public int getDefaultTextIconGap() {
        return this.defaultTextIconGap;
    }

    @Override
    protected Dimension getPreferredMenuItemSize(JComponent c2, Icon checkIcon, Icon arrowIcon, int defaultTextIconGap) {
        Dimension superDim = super.getPreferredMenuItemSize(c2, checkIcon, arrowIcon, defaultTextIconGap);
        if (MenuUtilities.getPopupLayoutMetrics(this.menuItem, false) != null) {
            return new Dimension(MenuUtilities.getPreferredWidth(this.menuItem), superDim.height);
        }
        return superDim;
    }

    @Override
    protected void paintMenuItem(Graphics g2, JComponent c2, Icon checkIcon, Icon arrowIcon, Color background, Color foreground, int defaultTextIconGap) {
        MenuUtilities.paintMenuItem(g2, this.menuItem, checkIcon, arrowIcon);
    }

    @Override
    public StateTransitionTracker getTransitionTracker() {
        return this.stateTransitionTracker;
    }

    @Override
    public boolean isInside(MouseEvent me2) {
        return true;
    }

    @Override
    public void update(Graphics g2, JComponent c2) {
        Graphics2D g2d = (Graphics2D)g2.create();
        NeonCortex.installDesktopHints(g2d, c2.getFont());
        super.update(g2d, c2);
        GhostPaintingUtils.paintGhostImages(c2, g2d);
        g2d.dispose();
    }

    @Override
    public void updateCheckIconIfNeeded() {
    }
}

