/*
 * Decompiled with CFR 0.152.
 */
package org.pushingpixels.substance.internal.ui;

import java.awt.Graphics;
import java.util.Set;
import javax.swing.JComponent;
import javax.swing.JMenuBar;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.basic.BasicMenuBarUI;
import org.pushingpixels.substance.api.SubstanceCortex;
import org.pushingpixels.substance.api.SubstanceSlices;
import org.pushingpixels.substance.api.SubstanceWidget;
import org.pushingpixels.substance.internal.SubstanceWidgetRepository;
import org.pushingpixels.substance.internal.painter.BackgroundPaintingUtils;
import org.pushingpixels.substance.internal.painter.DecorationPainterUtils;
import org.pushingpixels.substance.internal.utils.SubstanceCoreUtilities;
import org.pushingpixels.substance.internal.widget.animation.effects.GhostPaintingUtils;

public class SubstanceMenuBarUI
extends BasicMenuBarUI {
    private Set<SubstanceWidget<JComponent>> lafWidgets;

    public static ComponentUI createUI(JComponent comp) {
        SubstanceCoreUtilities.testComponentCreationThreadingViolation(comp);
        return new SubstanceMenuBarUI();
    }

    private SubstanceMenuBarUI() {
    }

    @Override
    public void installUI(JComponent c2) {
        this.lafWidgets = SubstanceWidgetRepository.getRepository().getMatchingWidgets(c2);
        super.installUI(c2);
        for (SubstanceWidget<JComponent> lafWidget : this.lafWidgets) {
            lafWidget.installUI();
        }
    }

    @Override
    public void uninstallUI(JComponent c2) {
        for (SubstanceWidget<JComponent> lafWidget : this.lafWidgets) {
            lafWidget.uninstallUI();
        }
        super.uninstallUI(c2);
    }

    @Override
    protected void installDefaults() {
        super.installDefaults();
        SubstanceCortex.ComponentOrParentChainScope.setDecorationType(this.menuBar, SubstanceSlices.DecorationAreaType.HEADER);
        for (SubstanceWidget<JComponent> lafWidget : this.lafWidgets) {
            lafWidget.installDefaults();
        }
    }

    @Override
    protected void uninstallDefaults() {
        DecorationPainterUtils.clearDecorationType(this.menuBar);
        for (SubstanceWidget<JComponent> lafWidget : this.lafWidgets) {
            lafWidget.uninstallDefaults();
        }
        super.uninstallDefaults();
    }

    @Override
    protected void installListeners() {
        super.installListeners();
        for (SubstanceWidget<JComponent> lafWidget : this.lafWidgets) {
            lafWidget.installListeners();
        }
    }

    @Override
    protected void uninstallListeners() {
        for (SubstanceWidget<JComponent> lafWidget : this.lafWidgets) {
            lafWidget.uninstallListeners();
        }
        super.uninstallListeners();
    }

    @Override
    public void update(Graphics g2, JComponent c2) {
        boolean isOpaque = SubstanceCoreUtilities.isOpaque(c2);
        if (isOpaque) {
            BackgroundPaintingUtils.update(g2, c2, false);
        } else {
            super.update(g2, c2);
        }
        GhostPaintingUtils.paintGhostImages(c2, g2);
    }

    public JMenuBar getMenuBar() {
        return this.menuBar;
    }
}

