/*
 * Decompiled with CFR 0.152.
 */
package org.pushingpixels.substance.internal.ui;

import java.awt.Color;
import java.beans.PropertyChangeListener;
import javax.swing.JComponent;
import javax.swing.JInternalFrame;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.UIResource;
import javax.swing.plaf.basic.BasicInternalFrameUI;
import org.pushingpixels.substance.internal.ui.SubstanceDesktopIconUI;
import org.pushingpixels.substance.internal.utils.SubstanceCoreUtilities;
import org.pushingpixels.substance.internal.utils.SubstanceInternalFrameTitlePane;

public class SubstanceInternalFrameUI
extends BasicInternalFrameUI {
    private SubstanceInternalFrameTitlePane titlePane;
    private PropertyChangeListener substancePropertyListener;

    private SubstanceInternalFrameUI(JInternalFrame b2) {
        super(b2);
    }

    public static ComponentUI createUI(JComponent comp) {
        SubstanceCoreUtilities.testComponentCreationThreadingViolation(comp);
        return new SubstanceInternalFrameUI((JInternalFrame)comp);
    }

    @Override
    protected JComponent createNorthPane(JInternalFrame w2) {
        this.titlePane = new SubstanceInternalFrameTitlePane(w2);
        return this.titlePane;
    }

    @Override
    protected void uninstallComponents() {
        this.titlePane.uninstall();
        super.uninstallComponents();
    }

    @Override
    protected void installListeners() {
        super.installListeners();
        this.substancePropertyListener = propertyChangeEvent -> {
            Color newBackgr;
            SubstanceDesktopIconUI ui2;
            JInternalFrame.JDesktopIcon jdi;
            if ("closed".equals(propertyChangeEvent.getPropertyName())) {
                this.titlePane.uninstall();
                jdi = this.frame.getDesktopIcon();
                ui2 = (SubstanceDesktopIconUI)jdi.getUI();
                ui2.uninstallIfNecessary(jdi);
            }
            if ("background".equals(propertyChangeEvent.getPropertyName()) && !((newBackgr = (Color)propertyChangeEvent.getNewValue()) instanceof UIResource)) {
                this.getTitlePane().setBackground(newBackgr);
                this.frame.getDesktopIcon().setBackground(newBackgr);
            }
            if ("ancestor".equals(propertyChangeEvent.getPropertyName())) {
                jdi = this.frame.getDesktopIcon();
                ui2 = (SubstanceDesktopIconUI)jdi.getUI();
                ui2.installIfNecessary(jdi);
            }
        };
        this.frame.addPropertyChangeListener(this.substancePropertyListener);
    }

    @Override
    protected void uninstallListeners() {
        this.frame.removePropertyChangeListener(this.substancePropertyListener);
        this.substancePropertyListener = null;
        super.uninstallListeners();
    }

    public SubstanceInternalFrameTitlePane getTitlePane() {
        return this.titlePane;
    }

    void setWindowModified(boolean isWindowModified) {
        this.titlePane.getCloseButton().putClientProperty("substancelaf.internal.contentsModified", isWindowModified);
        SubstanceDesktopIconUI desktopIconUi = (SubstanceDesktopIconUI)this.frame.getDesktopIcon().getUI();
        desktopIconUi.setWindowModified(isWindowModified);
    }
}

