/*
 * Decompiled with CFR 0.152.
 */
package org.pushingpixels.substance.internal.ui;

import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Graphics2D;
import javax.swing.JComponent;
import javax.swing.UIManager;
import javax.swing.border.Border;
import javax.swing.border.EmptyBorder;
import javax.swing.plaf.BorderUIResource;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.UIResource;
import javax.swing.plaf.basic.BasicDesktopPaneUI;
import org.pushingpixels.substance.internal.painter.BackgroundPaintingUtils;
import org.pushingpixels.substance.internal.utils.SubstanceCoreUtilities;
import org.pushingpixels.substance.internal.utils.WidgetUtilities;
import org.pushingpixels.substance.internal.widget.animation.effects.GhostPaintingUtils;

public class SubstanceDesktopPaneUI
extends BasicDesktopPaneUI {
    public static ComponentUI createUI(JComponent comp) {
        SubstanceCoreUtilities.testComponentCreationThreadingViolation(comp);
        return new SubstanceDesktopPaneUI();
    }

    private SubstanceDesktopPaneUI() {
    }

    @Override
    protected void installDefaults() {
        super.installDefaults();
        Border curr = this.desktop.getBorder();
        if (curr == null || curr instanceof UIResource) {
            this.desktop.setBorder(new BorderUIResource(new EmptyBorder(0, 0, 0, 0)));
        }
    }

    @Override
    public void update(Graphics g2, JComponent c2) {
        if (!c2.isShowing()) {
            return;
        }
        Graphics2D graphics = (Graphics2D)g2.create();
        graphics.setComposite(WidgetUtilities.getAlphaComposite((Component)c2, g2));
        if (SubstanceCoreUtilities.isOpaque(c2)) {
            Color back = c2.getBackground();
            if (back instanceof UIResource) {
                graphics.setColor(UIManager.getColor("Panel.background"));
                graphics.fillRect(0, 0, c2.getWidth(), c2.getHeight());
            }
            BackgroundPaintingUtils.updateIfOpaque(graphics, c2);
        }
        super.paint(graphics, c2);
        GhostPaintingUtils.paintGhostImages(c2, graphics);
        graphics.dispose();
    }
}

