/*
 * Decompiled with CFR 0.152.
 */
package org.pushingpixels.substance.internal.ui;

import java.awt.Component;
import java.awt.ComponentOrientation;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.Shape;
import java.awt.event.MouseEvent;
import java.beans.PropertyChangeEvent;
import javax.swing.ButtonModel;
import javax.swing.ComboBoxEditor;
import javax.swing.DefaultButtonModel;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.ListCellRenderer;
import javax.swing.SwingUtilities;
import javax.swing.border.Border;
import javax.swing.border.EmptyBorder;
import javax.swing.plaf.BorderUIResource;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.UIResource;
import javax.swing.plaf.basic.BasicComboBoxUI;
import javax.swing.plaf.basic.ComboPopup;
import javax.swing.text.JTextComponent;
import org.pushingpixels.neon.api.NeonCortex;
import org.pushingpixels.substance.api.renderer.SubstanceDefaultComboBoxRenderer;
import org.pushingpixels.substance.internal.animation.StateTransitionTracker;
import org.pushingpixels.substance.internal.animation.TransitionAwareUI;
import org.pushingpixels.substance.internal.utils.RolloverTextControlListener;
import org.pushingpixels.substance.internal.utils.SubstanceCoreUtilities;
import org.pushingpixels.substance.internal.utils.SubstanceDropDownButton;
import org.pushingpixels.substance.internal.utils.SubstanceOutlineUtilities;
import org.pushingpixels.substance.internal.utils.SubstanceSizeUtils;
import org.pushingpixels.substance.internal.utils.SubstanceTextUtilities;
import org.pushingpixels.substance.internal.utils.border.SubstanceTextComponentBorder;
import org.pushingpixels.substance.internal.utils.combo.ComboBoxBackgroundDelegate;
import org.pushingpixels.substance.internal.utils.combo.SubstanceComboBoxEditor;
import org.pushingpixels.substance.internal.utils.combo.SubstanceComboPopup;

public class SubstanceComboBoxUI
extends BasicComboBoxUI
implements TransitionAwareUI {
    private ComboBoxPropertyChangeHandler substanceChangeHandler;
    private StateTransitionTracker stateTransitionTracker;
    private ButtonModel transitionModel;
    private RolloverTextControlListener substanceRolloverListener;
    private ComboBoxBackgroundDelegate delegate;
    private Icon uneditableArrowIcon;
    private Insets layoutInsets;

    public static ComponentUI createUI(JComponent comp) {
        SubstanceCoreUtilities.testComponentCreationThreadingViolation(comp);
        SubstanceComboBoxUI ui2 = new SubstanceComboBoxUI((JComboBox)comp);
        ui2.comboBox = (JComboBox)comp;
        ui2.comboBox.putClientProperty("substancelaf.internal.controlopacityoriginal", ui2.comboBox.isOpaque());
        ui2.comboBox.setOpaque(false);
        return ui2;
    }

    @Override
    public void installUI(JComponent c2) {
        super.installUI(c2);
        c2.putClientProperty("substancelaf.internal.textComponentAware", t2 -> {
            Component editorComp;
            if (t2.isEditable() && (editorComp = t2.getEditor().getEditorComponent()) instanceof JTextComponent) {
                return (JTextComponent)editorComp;
            }
            return null;
        });
    }

    @Override
    public void uninstallUI(JComponent c2) {
        c2.putClientProperty("substancelaf.internal.textComponentAware", null);
        Object originalOpacity = c2.getClientProperty("substancelaf.internal.controlopacityoriginal");
        if (originalOpacity instanceof Boolean) {
            c2.setOpaque((Boolean)originalOpacity);
        }
        c2.putClientProperty("substancelaf.internal.controlopacityoriginal", null);
        super.uninstallUI(c2);
    }

    private SubstanceComboBoxUI(JComboBox<Object> combo) {
        this.comboBox = combo;
        this.transitionModel = new DefaultButtonModel();
        this.transitionModel.setArmed(false);
        this.transitionModel.setSelected(false);
        this.transitionModel.setPressed(false);
        this.transitionModel.setRollover(false);
        this.transitionModel.setEnabled(combo.isEnabled());
        this.stateTransitionTracker = new StateTransitionTracker(this.comboBox, this.transitionModel);
        this.delegate = new ComboBoxBackgroundDelegate();
    }

    @Override
    protected JButton createArrowButton() {
        SubstanceDropDownButton result = new SubstanceDropDownButton(this.comboBox);
        result.setFont(this.comboBox.getFont());
        result.setIcon(this.getCurrentIcon(result));
        return result;
    }

    private Icon getCurrentIcon(JButton button) {
        int popupFlyoutOrientation = SubstanceCoreUtilities.getPopupFlyoutOrientation(this.comboBox);
        return SubstanceCoreUtilities.getArrowIcon(button, popupFlyoutOrientation);
    }

    @Override
    protected ListCellRenderer<Object> createRenderer() {
        return new SubstanceDefaultComboBoxRenderer.SubstanceUIResource(this.comboBox);
    }

    @Override
    protected void installListeners() {
        super.installListeners();
        this.substanceChangeHandler = new ComboBoxPropertyChangeHandler();
        this.comboBox.addPropertyChangeListener(this.substanceChangeHandler);
        this.substanceRolloverListener = new RolloverTextControlListener(this.comboBox, this, this.transitionModel);
        this.substanceRolloverListener.registerListeners();
        this.stateTransitionTracker.registerModelListeners();
        this.stateTransitionTracker.registerFocusListeners();
    }

    @Override
    protected void uninstallListeners() {
        this.stateTransitionTracker.unregisterModelListeners();
        this.stateTransitionTracker.unregisterFocusListeners();
        this.comboBox.removePropertyChangeListener(this.substanceChangeHandler);
        this.substanceChangeHandler = null;
        this.substanceRolloverListener.unregisterListeners();
        this.substanceRolloverListener = null;
        super.uninstallListeners();
    }

    @Override
    protected void installDefaults() {
        super.installDefaults();
        this.uneditableArrowIcon = SubstanceCoreUtilities.getArrowIcon(this.comboBox, () -> (TransitionAwareUI)((Object)this.comboBox.getUI()), SubstanceCoreUtilities.getPopupFlyoutOrientation(this.comboBox));
        this.updateComboBoxBorder();
    }

    @Override
    protected LayoutManager createLayoutManager() {
        return new SubstanceComboBoxLayoutManager();
    }

    @Override
    protected Rectangle rectangleForCurrentValue() {
        int width = this.comboBox.getWidth();
        int height = this.comboBox.getHeight();
        Insets insets = this.layoutInsets;
        int buttonWidth = SubstanceSizeUtils.getScrollBarWidth(SubstanceSizeUtils.getComponentFontSize(this.comboBox));
        if (this.comboBox.getComponentOrientation().isLeftToRight()) {
            return new Rectangle(insets.left, insets.top, width - insets.left - insets.right - buttonWidth, height - insets.top - insets.bottom);
        }
        int startX = insets.left + buttonWidth;
        return new Rectangle(startX, insets.top, width - startX - insets.right, height - insets.top - insets.bottom);
    }

    @Override
    protected Dimension getDefaultSize() {
        Component rend = new SubstanceDefaultComboBoxRenderer(this.comboBox).getListCellRendererComponent(this.listBox, (Object)" ", -1, false, false);
        rend.setFont(this.comboBox.getFont());
        return rend.getPreferredSize();
    }

    @Override
    public Dimension getMinimumSize(JComponent c2) {
        SubstanceDropDownButton button;
        Dimension size = this.getDisplaySize();
        if (this.arrowButton != null && (button = (SubstanceDropDownButton)this.arrowButton) != null) {
            Insets buttonInsets = button.getInsets();
            Insets insets = this.comboBox.getInsets();
            if (insets != null && buttonInsets != null) {
                size.width += insets.left + insets.right;
                size.width += buttonInsets.left + buttonInsets.right;
                size.width = (int)((double)size.width + button.getMinimumSize().getWidth());
                size.height += insets.top + insets.bottom;
            }
        }
        this.cachedMinimumSize.setSize(size.width, size.height);
        this.isMinimumSizeDirty = false;
        return new Dimension(this.cachedMinimumSize);
    }

    @Override
    protected ComboPopup createPopup() {
        SubstanceComboPopup sPopup = new SubstanceComboPopup(this.comboBox);
        ComponentOrientation currOrientation = this.comboBox.getComponentOrientation();
        SwingUtilities.invokeLater(() -> {
            ComboBoxEditor editor;
            if (this.comboBox == null) {
                return;
            }
            sPopup.applyComponentOrientation(currOrientation);
            sPopup.doLayout();
            ListCellRenderer cellRenderer = this.comboBox.getRenderer();
            if (cellRenderer instanceof Component) {
                ((Component)((Object)cellRenderer)).applyComponentOrientation(currOrientation);
            }
            if ((editor = this.comboBox.getEditor()) != null && editor.getEditorComponent() != null) {
                editor.getEditorComponent().applyComponentOrientation(currOrientation);
            }
            this.comboBox.repaint();
        });
        return sPopup;
    }

    @Override
    public void paint(Graphics g2, JComponent c2) {
        Rectangle r2;
        Graphics2D graphics = (Graphics2D)g2.create();
        int width = this.comboBox.getWidth();
        int height = this.comboBox.getHeight();
        Insets insets = this.comboBox.getInsets();
        int componentFontSize = SubstanceSizeUtils.getComponentFontSize(this.comboBox);
        if (this.comboBox.isEditable()) {
            SubstanceTextUtilities.paintTextCompBackground(g2, c2);
        } else {
            this.delegate.updateBackground(graphics, this.comboBox);
            Icon icon = this.uneditableArrowIcon;
            int iw = icon.getIconWidth();
            int ih2 = icon.getIconHeight();
            int origButtonWidth = SubstanceSizeUtils.getScrollBarWidth(componentFontSize);
            Graphics2D forIcon = (Graphics2D)graphics.create();
            forIcon.setRenderingHint(RenderingHints.KEY_INTERPOLATION, RenderingHints.VALUE_INTERPOLATION_BICUBIC);
            int iconY = 1 + insets.top + (height - insets.top - insets.bottom - ih2) / 2;
            if (this.comboBox.getComponentOrientation().isLeftToRight()) {
                int iconX = width - origButtonWidth - insets.right / 2 + (origButtonWidth - iw) / 2;
                forIcon.translate(iconX, iconY);
                icon.paintIcon(this.comboBox, forIcon, 0, 0);
            } else {
                int iconX = insets.left / 2 + (origButtonWidth - iw) / 2;
                forIcon.translate(iconX, iconY);
                icon.paintIcon(this.comboBox, forIcon, 0, 0);
            }
            forIcon.dispose();
        }
        this.hasFocus = this.comboBox.hasFocus();
        if (!this.comboBox.isEditable()) {
            r2 = this.rectangleForCurrentValue();
            ListCellRenderer<Object> renderer = this.comboBox.getRenderer();
            Component rendererComponent = this.hasFocus ? renderer.getListCellRendererComponent(this.listBox, this.comboBox.getSelectedItem(), -1, true, this.hasFocus) : renderer.getListCellRendererComponent(this.listBox, this.comboBox.getSelectedItem(), -1, false, this.hasFocus);
            rendererComponent.setFont(this.comboBox.getFont());
            boolean shouldValidate = false;
            if (rendererComponent instanceof JPanel) {
                shouldValidate = true;
            }
            if (this.comboBox.getComponentOrientation().isLeftToRight()) {
                this.currentValuePane.paintComponent(graphics, rendererComponent, this.comboBox, r2.x, r2.y, r2.width, r2.height, shouldValidate);
            } else {
                this.currentValuePane.paintComponent(graphics, rendererComponent, this.comboBox, r2.x, r2.y, r2.width, r2.height, shouldValidate);
            }
        }
        if (!this.comboBox.isEditable()) {
            r2 = new Rectangle(insets.left, this.layoutInsets.top, width - insets.left - insets.right, height - this.layoutInsets.top - this.layoutInsets.bottom);
            this.paintFocus(graphics, r2);
        }
        graphics.dispose();
    }

    private void paintFocus(Graphics g2, Rectangle bounds) {
        int fontSize = SubstanceSizeUtils.getComponentFontSize(this.comboBox);
        int x2 = bounds.x;
        int y2 = bounds.y;
        Graphics2D g2d = (Graphics2D)g2.create();
        g2d.translate(x2, y2);
        SubstanceCoreUtilities.paintFocus(g2d, this.comboBox, this.comboBox, this, SubstanceOutlineUtilities.getBaseOutline(bounds.width, bounds.height, SubstanceSizeUtils.getClassicButtonCornerRadius(fontSize), null, 0.0f), bounds, 1.0f, 0.0f);
        g2d.dispose();
    }

    public ComboPopup getPopup() {
        return this.popup;
    }

    @Override
    public void configureArrowButton() {
        super.configureArrowButton();
        this.arrowButton.setFocusable(false);
    }

    @Override
    protected void configureEditor() {
        super.configureEditor();
        if (this.editor instanceof JComponent) {
            Insets ins = SubstanceSizeUtils.getComboTextBorderInsets(SubstanceSizeUtils.getComponentFontSize(this.editor));
            ((JComponent)this.editor).setBorder(new EmptyBorder(ins.top, ins.left, ins.bottom, ins.right));
            this.editor.setBackground(this.comboBox.getBackground());
        }
    }

    @Override
    protected ComboBoxEditor createEditor() {
        return new SubstanceComboBoxEditor.UIResource();
    }

    private void updateComboBoxBorder() {
        Border b2 = this.comboBox.getBorder();
        if (b2 == null || b2 instanceof UIResource) {
            int comboFontSize = SubstanceSizeUtils.getComponentFontSize(this.comboBox);
            Insets comboBorderInsets = SubstanceSizeUtils.getComboBorderInsets(comboFontSize);
            if (this.comboBox.isEditable()) {
                SubstanceTextComponentBorder border = new SubstanceTextComponentBorder(comboBorderInsets);
                this.comboBox.setBorder(border);
            } else {
                this.comboBox.setBorder(new BorderUIResource.EmptyBorderUIResource(comboBorderInsets));
                this.comboBox.setPrototypeDisplayValue(this.comboBox.getPrototypeDisplayValue());
            }
            this.layoutInsets = SubstanceSizeUtils.getComboLayoutInsets(comboFontSize);
        } else {
            this.layoutInsets = new Insets(0, 0, 0, 0);
        }
    }

    @Override
    public StateTransitionTracker getTransitionTracker() {
        return this.stateTransitionTracker;
    }

    @Override
    public boolean isInside(MouseEvent me2) {
        if (!SubstanceCoreUtilities.isCurrentLookAndFeel()) {
            return false;
        }
        Shape contour = SubstanceOutlineUtilities.getBaseOutline(this.comboBox, SubstanceSizeUtils.getClassicButtonCornerRadius(SubstanceSizeUtils.getComponentFontSize(this.comboBox)), null);
        return contour.contains(me2.getPoint());
    }

    @Override
    public void update(Graphics g2, JComponent c2) {
        Graphics2D g2d = (Graphics2D)g2.create();
        NeonCortex.installDesktopHints(g2d, c2.getFont());
        this.paint(g2d, c2);
        g2d.dispose();
    }

    @Override
    public Dimension getPreferredSize(JComponent c2) {
        return super.getPreferredSize(c2);
    }

    public class ComboBoxPropertyChangeHandler
    extends BasicComboBoxUI.PropertyChangeHandler {
        public ComboBoxPropertyChangeHandler() {
            super(SubstanceComboBoxUI.this);
        }

        @Override
        public void propertyChange(PropertyChangeEvent e2) {
            String propertyName = e2.getPropertyName();
            if (propertyName.equals("componentOrientation")) {
                SwingUtilities.invokeLater(() -> {
                    if (SubstanceComboBoxUI.this.comboBox == null) {
                        return;
                    }
                    ComponentOrientation newOrientation = (ComponentOrientation)e2.getNewValue();
                    ListCellRenderer cellRenderer = SubstanceComboBoxUI.this.comboBox.getRenderer();
                    ComboBoxEditor editor = SubstanceComboBoxUI.this.comboBox.getEditor();
                    if (SubstanceComboBoxUI.this.popup instanceof Component) {
                        Component cPopup = (Component)((Object)SubstanceComboBoxUI.this.popup);
                        cPopup.applyComponentOrientation(newOrientation);
                        cPopup.doLayout();
                    }
                    if (cellRenderer instanceof Component) {
                        ((Component)((Object)cellRenderer)).applyComponentOrientation(newOrientation);
                    }
                    if (editor != null && editor.getEditorComponent() != null) {
                        editor.getEditorComponent().applyComponentOrientation(newOrientation);
                    }
                    if (SubstanceComboBoxUI.this.comboBox != null) {
                        SubstanceComboBoxUI.this.comboBox.repaint();
                    }
                });
            }
            if ("substancelaf.internal.comboBoxPopupFlyoutOrientation".equals(propertyName)) {
                SubstanceDropDownButton dropDownButton = (SubstanceDropDownButton)SubstanceComboBoxUI.this.arrowButton;
                dropDownButton.setIcon(SubstanceComboBoxUI.this.getCurrentIcon(dropDownButton));
                SubstanceComboBoxUI.this.uneditableArrowIcon = SubstanceCoreUtilities.getArrowIcon(SubstanceComboBoxUI.this.comboBox, () -> (TransitionAwareUI)((Object)SubstanceComboBoxUI.this.comboBox.getUI()), SubstanceCoreUtilities.getPopupFlyoutOrientation(SubstanceComboBoxUI.this.comboBox));
            }
            if ("font".equals(propertyName)) {
                SwingUtilities.invokeLater(() -> {
                    if (SubstanceComboBoxUI.this.comboBox != null) {
                        SubstanceComboBoxUI.this.comboBox.updateUI();
                    }
                });
            }
            if ("background".equals(propertyName) && SubstanceComboBoxUI.this.comboBox.isEditable()) {
                SubstanceComboBoxUI.this.comboBox.getEditor().getEditorComponent().setBackground(SubstanceComboBoxUI.this.comboBox.getBackground());
                SubstanceComboBoxUI.this.popup.getList().setBackground(SubstanceComboBoxUI.this.comboBox.getBackground());
            }
            if ("editable".equals(propertyName)) {
                SubstanceComboBoxUI.this.updateComboBoxBorder();
                SubstanceComboBoxUI.this.isMinimumSizeDirty = true;
            }
            if ("enabled".equals(propertyName)) {
                SubstanceComboBoxUI.this.transitionModel.setEnabled(SubstanceComboBoxUI.this.comboBox.isEnabled());
            }
        }
    }

    private class SubstanceComboBoxLayoutManager
    extends BasicComboBoxUI.ComboBoxLayoutManager {
        private SubstanceComboBoxLayoutManager() {
            super(SubstanceComboBoxUI.this);
        }

        @Override
        public void layoutContainer(Container parent) {
            int buttonWidth;
            JComboBox cb2 = (JComboBox)parent;
            int width = cb2.getWidth();
            int height = cb2.getHeight();
            Insets insets = SubstanceComboBoxUI.this.layoutInsets;
            int n2 = buttonWidth = SubstanceComboBoxUI.this.comboBox.isEditable() ? SubstanceSizeUtils.getScrollBarWidth(SubstanceSizeUtils.getComponentFontSize(SubstanceComboBoxUI.this.comboBox)) : SubstanceComboBoxUI.this.uneditableArrowIcon.getIconWidth();
            if (SubstanceComboBoxUI.this.arrowButton != null) {
                if (!SubstanceComboBoxUI.this.comboBox.isEditable()) {
                    SubstanceComboBoxUI.this.arrowButton.setBounds(0, 0, 0, 0);
                } else if (cb2.getComponentOrientation().isLeftToRight()) {
                    SubstanceComboBoxUI.this.arrowButton.setBounds(width - buttonWidth - insets.right, 0, buttonWidth + insets.right, height);
                } else {
                    SubstanceComboBoxUI.this.arrowButton.setBounds(0, 0, buttonWidth + insets.left, height);
                }
            }
            if (SubstanceComboBoxUI.this.editor != null) {
                Rectangle r2 = SubstanceComboBoxUI.this.rectangleForCurrentValue();
                SubstanceComboBoxUI.this.editor.setBounds(r2);
            }
        }
    }
}

