/*
 * Decompiled with CFR 0.152.
 */
package org.pushingpixels.substance.internal.ui;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.event.MouseEvent;
import java.beans.PropertyChangeListener;
import java.util.Set;
import javax.swing.AbstractButton;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JRadioButton;
import javax.swing.LookAndFeel;
import javax.swing.SwingUtilities;
import javax.swing.border.Border;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.basic.BasicButtonListener;
import javax.swing.plaf.basic.BasicButtonUI;
import javax.swing.text.View;
import org.pushingpixels.neon.api.NeonCortex;
import org.pushingpixels.substance.api.SubstanceSlices;
import org.pushingpixels.substance.api.SubstanceWidget;
import org.pushingpixels.substance.api.shaper.SubstanceButtonShaper;
import org.pushingpixels.substance.internal.AnimationConfigurationManager;
import org.pushingpixels.substance.internal.SubstanceWidgetRepository;
import org.pushingpixels.substance.internal.animation.ModificationAwareUI;
import org.pushingpixels.substance.internal.animation.StateTransitionTracker;
import org.pushingpixels.substance.internal.animation.TransitionAwareUI;
import org.pushingpixels.substance.internal.utils.ButtonBackgroundDelegate;
import org.pushingpixels.substance.internal.utils.ButtonVisualStateTracker;
import org.pushingpixels.substance.internal.utils.SubstanceCoreUtilities;
import org.pushingpixels.substance.internal.utils.SubstanceMetricsUtilities;
import org.pushingpixels.substance.internal.utils.SubstanceSizeUtils;
import org.pushingpixels.substance.internal.utils.SubstanceTextUtilities;
import org.pushingpixels.substance.internal.utils.WidgetUtilities;
import org.pushingpixels.substance.internal.utils.border.SubstanceButtonBorder;
import org.pushingpixels.substance.internal.utils.icon.GlowingIcon;
import org.pushingpixels.substance.internal.widget.animation.effects.GhostPaintingUtils;
import org.pushingpixels.substance.internal.widget.animation.effects.GhostingListener;
import org.pushingpixels.trident.api.Timeline;
import org.pushingpixels.trident.api.swing.SwingComponentTimeline;
import org.pushingpixels.trident.api.swing.SwingRepaintCallback;

public class SubstanceButtonUI
extends BasicButtonUI
implements TransitionAwareUI,
ModificationAwareUI {
    public static final String BORDER_COMPUTED = "substancelaf.internal.buttonbordercomputed";
    public static final String BORDER_COMPUTING = "substancelaf.internal.buttonbordercomputing";
    static final String BORDER_ORIGINAL = "substancelaf.internal.buttonborderoriginal";
    private static final String ICON_ORIGINAL = "substancelaf.internal.buttoniconoriginal";
    static final String OPACITY_ORIGINAL = "substancelaf.internal.controlopacityoriginal";
    static final String LOCK_OPACITY = "substancelaf.internal.lockopacity";
    public static final String IS_TITLE_CLOSE_BUTTON = "substancelaf.internal.isTitleCloseButton";
    private ButtonBackgroundDelegate delegate;
    private GlowingIcon glowingIcon;
    private PropertyChangeListener substancePropertyListener;
    private ButtonVisualStateTracker substanceVisualStateTracker;
    private GhostingListener ghostModelChangeListener;
    private Set<SubstanceWidget<JComponent>> lafWidgets;
    protected AbstractButton button;
    private Color textColor;
    private Timeline modifiedTimeline;
    private Rectangle viewRect = new Rectangle();
    private Rectangle iconRect = new Rectangle();
    private Rectangle textRect = new Rectangle();

    public static ComponentUI createUI(JComponent comp) {
        SubstanceCoreUtilities.testComponentCreationThreadingViolation(comp);
        return new SubstanceButtonUI((AbstractButton)comp);
    }

    private SubstanceButtonUI(AbstractButton button) {
        this.button = button;
        this.delegate = new ButtonBackgroundDelegate();
    }

    @Override
    public void installUI(JComponent c2) {
        this.lafWidgets = SubstanceWidgetRepository.getRepository().getMatchingWidgets(c2);
        super.installUI(c2);
        for (SubstanceWidget<JComponent> lafWidget : this.lafWidgets) {
            lafWidget.installUI();
        }
    }

    @Override
    public void uninstallUI(JComponent c2) {
        for (SubstanceWidget<JComponent> lafWidget : this.lafWidgets) {
            lafWidget.uninstallUI();
        }
        super.uninstallUI(c2);
    }

    @Override
    protected void installDefaults(AbstractButton b2) {
        super.installDefaults(b2);
        if (b2.getClientProperty(BORDER_ORIGINAL) == null) {
            b2.putClientProperty(BORDER_ORIGINAL, b2.getBorder());
        }
        SubstanceButtonShaper shaper = SubstanceCoreUtilities.getButtonShaper(b2);
        if (b2.getClientProperty(BORDER_COMPUTED) == null) {
            b2.setBorder(shaper.getButtonBorder(b2));
        } else {
            Border currBorder = b2.getBorder();
            if (!(currBorder instanceof SubstanceButtonBorder)) {
                b2.setBorder(shaper.getButtonBorder(b2));
            } else {
                SubstanceButtonBorder sbCurrBorder = (SubstanceButtonBorder)currBorder;
                if (shaper.getClass() != sbCurrBorder.getButtonShaperClass()) {
                    b2.setBorder(shaper.getButtonBorder(b2));
                }
            }
        }
        b2.putClientProperty(OPACITY_ORIGINAL, b2.isOpaque());
        b2.setOpaque(false);
        b2.setRolloverEnabled(true);
        LookAndFeel.installProperty(b2, "iconTextGap", SubstanceSizeUtils.getTextIconGap(SubstanceSizeUtils.getComponentFontSize(b2)));
        if (Boolean.TRUE.equals(b2.getClientProperty("substancelaf.internal.contentsModified"))) {
            this.trackModificationFlag();
        }
        for (SubstanceWidget<JComponent> lafWidget : this.lafWidgets) {
            lafWidget.installDefaults();
        }
    }

    @Override
    protected void uninstallDefaults(AbstractButton b2) {
        super.uninstallDefaults(b2);
        b2.setBorder((Border)b2.getClientProperty(BORDER_ORIGINAL));
        b2.setOpaque((Boolean)b2.getClientProperty(OPACITY_ORIGINAL));
        Icon origIcon = (Icon)b2.getClientProperty(ICON_ORIGINAL);
        if (origIcon != null) {
            b2.setIcon(origIcon);
        }
        b2.putClientProperty(OPACITY_ORIGINAL, null);
        for (SubstanceWidget<JComponent> lafWidget : this.lafWidgets) {
            lafWidget.uninstallDefaults();
        }
    }

    @Override
    protected BasicButtonListener createButtonListener(AbstractButton b2) {
        return null;
    }

    @Override
    protected void installListeners(AbstractButton b2) {
        super.installListeners(b2);
        this.substanceVisualStateTracker = new ButtonVisualStateTracker();
        this.substanceVisualStateTracker.installListeners(b2, true);
        this.trackGlowingIcon();
        this.substancePropertyListener = propertyChangeEvent -> {
            if ("icon".equals(propertyChangeEvent.getPropertyName())) {
                this.trackGlowingIcon();
            }
            if ("substancelaf.internal.contentsModified".equals(propertyChangeEvent.getPropertyName())) {
                boolean newValue = (Boolean)propertyChangeEvent.getNewValue();
                if (newValue) {
                    this.trackModificationFlag();
                } else if (this.modifiedTimeline != null) {
                    this.modifiedTimeline.cancel();
                }
            }
            if ("model".equals(propertyChangeEvent.getPropertyName())) {
                if (this.ghostModelChangeListener != null) {
                    this.ghostModelChangeListener.unregisterListeners();
                }
                this.ghostModelChangeListener = new GhostingListener(b2, b2.getModel());
                this.ghostModelChangeListener.registerListeners();
            }
        };
        b2.addPropertyChangeListener(this.substancePropertyListener);
        this.ghostModelChangeListener = new GhostingListener(b2, b2.getModel());
        this.ghostModelChangeListener.registerListeners();
        for (SubstanceWidget<JComponent> lafWidget : this.lafWidgets) {
            lafWidget.installListeners();
        }
    }

    @Override
    protected void uninstallListeners(AbstractButton b2) {
        this.substanceVisualStateTracker.uninstallListeners(b2);
        this.substanceVisualStateTracker = null;
        b2.removePropertyChangeListener(this.substancePropertyListener);
        this.substancePropertyListener = null;
        this.ghostModelChangeListener.unregisterListeners();
        this.ghostModelChangeListener = null;
        for (SubstanceWidget<JComponent> lafWidget : this.lafWidgets) {
            lafWidget.uninstallListeners();
        }
        super.uninstallListeners(b2);
    }

    @Override
    public void paint(Graphics g2, JComponent c2) {
        if (!SubstanceCoreUtilities.isCurrentLookAndFeel()) {
            return;
        }
        AbstractButton b2 = (AbstractButton)c2;
        FontMetrics fm = g2.getFontMetrics();
        Insets i2 = c2.getInsets();
        this.viewRect.x = i2.left;
        this.viewRect.y = i2.top;
        this.viewRect.width = b2.getWidth() - (i2.right + this.viewRect.x);
        this.viewRect.height = b2.getHeight() - (i2.bottom + this.viewRect.y);
        this.textRect.height = 0;
        this.textRect.width = 0;
        this.textRect.y = 0;
        this.textRect.x = 0;
        this.iconRect.height = 0;
        this.iconRect.width = 0;
        this.iconRect.y = 0;
        this.iconRect.x = 0;
        Font f2 = c2.getFont();
        String text = SwingUtilities.layoutCompoundLabel(c2, fm, b2.getText(), b2.getIcon(), b2.getVerticalAlignment(), b2.getHorizontalAlignment(), b2.getVerticalTextPosition(), b2.getHorizontalTextPosition(), this.viewRect, this.iconRect, this.textRect, b2.getText() == null ? 0 : b2.getIconTextGap());
        Graphics2D g2d = (Graphics2D)g2.create();
        View v2 = (View)c2.getClientProperty("html");
        g2d.setFont(f2);
        this.delegate.updateBackground(g2d, b2);
        if (v2 != null) {
            v2.paint(g2d, this.textRect);
        } else {
            this.textColor = this.paintButtonText(g2d, b2, this.textRect, text);
        }
        if (b2.getIcon() != null) {
            this.paintIcon(g2d, c2, this.iconRect);
        }
        if (b2.isFocusPainted()) {
            SubstanceCoreUtilities.paintFocus(g2d, b2, b2, this, null, this.textRect, 1.0f, SubstanceSizeUtils.getFocusRingPadding(SubstanceSizeUtils.getComponentFontSize(b2)));
        }
        g2d.dispose();
    }

    @Override
    public Dimension getPreferredSize(JComponent c2) {
        AbstractButton button = (AbstractButton)c2;
        SubstanceButtonShaper shaper = SubstanceCoreUtilities.getButtonShaper(button);
        Dimension superPref = SubstanceMetricsUtilities.getPreferredButtonSize(button);
        if (superPref == null) {
            return null;
        }
        if (shaper == null) {
            return superPref;
        }
        return shaper.getPreferredSize(button, superPref);
    }

    @Override
    public boolean contains(JComponent c2, int x2, int y2) {
        return ButtonBackgroundDelegate.contains((JButton)c2, x2, y2);
    }

    @Override
    protected void paintIcon(Graphics g2, JComponent c2, Rectangle iconRect) {
        c2.putClientProperty("icon.bounds", new Rectangle(iconRect));
        Graphics2D graphics = (Graphics2D)g2.create();
        GhostPaintingUtils.paintGhostIcon(graphics, (AbstractButton)c2, iconRect);
        AbstractButton b2 = (AbstractButton)c2;
        Icon originalIcon = SubstanceCoreUtilities.getOriginalIcon(b2, b2.getIcon());
        graphics.setComposite(WidgetUtilities.getAlphaComposite((Component)b2, g2));
        graphics.setRenderingHint(RenderingHints.KEY_INTERPOLATION, RenderingHints.VALUE_INTERPOLATION_BICUBIC);
        float activeAmount = this.substanceVisualStateTracker.getStateTransitionTracker().getActiveStrength();
        graphics.translate(iconRect.x, iconRect.y);
        if (activeAmount >= 0.0f) {
            if (AnimationConfigurationManager.getInstance().isAnimationAllowed(SubstanceSlices.AnimationFacet.ICON_GLOW, b2) && this.substanceVisualStateTracker.getStateTransitionTracker().getIconGlowTracker().isPlaying()) {
                this.glowingIcon.paintIcon(b2, graphics, 0, 0);
            } else {
                SubstanceSlices.IconThemingStrategy iconThemingStrategy = SubstanceCoreUtilities.getIconThemingType(b2);
                Icon themedIcon = !(b2 instanceof JRadioButton) && !(b2 instanceof JCheckBox) && iconThemingStrategy != null ? SubstanceCoreUtilities.getThemedIcon(b2, originalIcon, this.textColor) : originalIcon;
                themedIcon.paintIcon(b2, graphics, 0, 0);
                if (activeAmount > 0.0f && iconThemingStrategy != null && iconThemingStrategy.isForInactiveState() && originalIcon != themedIcon) {
                    graphics.setComposite(WidgetUtilities.getAlphaComposite(b2, activeAmount, g2));
                    originalIcon.paintIcon(b2, graphics, 0, 0);
                }
            }
        } else {
            originalIcon.paintIcon(b2, graphics, 0, 0);
        }
        graphics.dispose();
    }

    private Color paintButtonText(Graphics g2, AbstractButton button, Rectangle textRect, String text) {
        return SubstanceTextUtilities.paintText(g2, button, textRect, text, button.getDisplayedMnemonicIndex());
    }

    private void trackGlowingIcon() {
        Icon currIcon = this.button.getIcon();
        if (currIcon instanceof GlowingIcon) {
            return;
        }
        if (currIcon == null) {
            return;
        }
        this.glowingIcon = new GlowingIcon(currIcon, this.substanceVisualStateTracker.getStateTransitionTracker().getIconGlowTracker());
    }

    @Override
    public void update(Graphics g2, JComponent c2) {
        Graphics2D g2d = (Graphics2D)g2.create();
        NeonCortex.installDesktopHints(g2d, c2.getFont());
        this.paint(g2d, c2);
        g2d.dispose();
    }

    @Override
    public boolean isInside(MouseEvent me2) {
        return this.contains(this.button, me2.getX(), me2.getY());
    }

    @Override
    public StateTransitionTracker getTransitionTracker() {
        return this.substanceVisualStateTracker.getStateTransitionTracker();
    }

    private void trackModificationFlag() {
        this.modifiedTimeline = ((SwingComponentTimeline.Builder)AnimationConfigurationManager.getInstance().modifiedTimelineBuilder(this.button).addCallback(new SwingRepaintCallback(this.button))).build();
        this.modifiedTimeline.playLoop(Timeline.RepeatBehavior.REVERSE);
    }

    @Override
    public Timeline getModificationTimeline() {
        return this.modifiedTimeline;
    }
}

