/*
 * Decompiled with CFR 0.152.
 */
package org.pushingpixels.substance.internal.painter;

import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.LinearGradientPaint;
import java.awt.geom.Line2D;
import java.awt.image.BufferedImage;
import java.util.Collection;
import javax.swing.JComponent;
import javax.swing.JPopupMenu;
import org.pushingpixels.neon.api.NeonCortex;
import org.pushingpixels.substance.api.ComponentState;
import org.pushingpixels.substance.api.SubstanceCortex;
import org.pushingpixels.substance.api.SubstanceSkin;
import org.pushingpixels.substance.api.SubstanceSlices;
import org.pushingpixels.substance.api.colorscheme.SubstanceColorScheme;
import org.pushingpixels.substance.internal.utils.HashMapKey;
import org.pushingpixels.substance.internal.utils.LazyResettableHashMap;
import org.pushingpixels.substance.internal.utils.SubstanceColorSchemeUtilities;
import org.pushingpixels.substance.internal.utils.SubstanceColorUtilities;
import org.pushingpixels.substance.internal.utils.SubstanceCoreUtilities;
import org.pushingpixels.substance.internal.utils.SubstanceSizeUtils;

public class SeparatorPainterUtils {
    private static LazyResettableHashMap<BufferedImage> cached = new LazyResettableHashMap("SeparatorPainterUtils");

    public static void paintSeparator(Component c2, Graphics graphics, int width, int height, int orientation) {
        SeparatorPainterUtils.paintSeparator(c2, graphics, width, height, orientation, true, 10);
    }

    public static void paintSeparator(Component c2, Graphics graphics, int width, int height, int orientation, boolean hasShadow, int maxGradLength) {
        SeparatorPainterUtils.paintSeparator(c2, graphics, width, height, orientation, hasShadow, maxGradLength, maxGradLength, false);
    }

    public static void paintSeparator(Component c2, Graphics g2, int width, int height, int orientation, boolean hasShadow, int maxGradLengthStart, int maxGradLengthEnd, boolean toEnforceAlphaColors) {
        boolean isParentAPopup;
        SubstanceColorScheme compScheme = null;
        Container parent = c2.getParent();
        boolean bl = isParentAPopup = parent instanceof JPopupMenu || parent instanceof JComponent && ((JComponent)parent).getClientProperty("substancelaf.internal.popupInvokerLink") != null;
        if (isParentAPopup && (compScheme = SubstanceColorSchemeUtilities.getDirectColorScheme(c2, SubstanceSlices.ColorSchemeAssociationKind.SEPARATOR, ComponentState.ENABLED)) == null) {
            compScheme = SubstanceCoreUtilities.getSkin(c2).getBackgroundColorScheme(SubstanceCortex.ComponentOrParentChainScope.getDecorationType(c2));
        }
        if (compScheme == null) {
            compScheme = SubstanceColorSchemeUtilities.getColorScheme(c2, SubstanceSlices.ColorSchemeAssociationKind.SEPARATOR, ComponentState.ENABLED);
        }
        SeparatorPainterUtils.paintSeparator(c2, g2, compScheme, width, height, orientation, hasShadow, maxGradLengthStart, maxGradLengthEnd, toEnforceAlphaColors);
    }

    public static void paintSeparator(Component c2, Graphics g2, SubstanceColorScheme scheme, int width, int height, int orientation, boolean hasShadow, int maxGradLengthStart, int maxGradLengthEnd, boolean toEnforceAlphaColors) {
        SubstanceSlices.DecorationAreaType decorationAreaType = SubstanceCortex.ComponentOrParentChainScope.getDecorationType(c2);
        SubstanceSkin skin = SubstanceCoreUtilities.getSkin(c2);
        boolean toUseAlphaColors = decorationAreaType == null || decorationAreaType == SubstanceSlices.DecorationAreaType.NONE ? false : skin.isRegisteredAsDecorationArea(decorationAreaType) || skin.getOverlayPainters(decorationAreaType).size() > 0;
        toUseAlphaColors = toUseAlphaColors || toEnforceAlphaColors;
        Color backgrFill = SubstanceColorUtilities.getBackgroundFillColor(c2);
        int fontSize = SubstanceSizeUtils.getComponentFontSize(c2);
        float borderStrokeWidth = SubstanceSizeUtils.getBorderStrokeWidth();
        if (orientation == 0 && height == 0) {
            height = (int)Math.ceil(2.0 * (double)borderStrokeWidth);
        }
        if (orientation == 1 && width == 0) {
            width = (int)Math.ceil(2.0 * (double)borderStrokeWidth);
        }
        if (width == 0 || height == 0) {
            return;
        }
        HashMapKey key = SubstanceCoreUtilities.getHashKey(fontSize, scheme.getDisplayName(), width, height, orientation, hasShadow, maxGradLengthStart, maxGradLengthEnd, toUseAlphaColors, backgrFill.getRGB());
        BufferedImage singleLine = cached.get(key);
        if (singleLine == null) {
            singleLine = SubstanceCoreUtilities.getBlankImage(width, height);
            Graphics2D graphics = singleLine.createGraphics();
            Color primary = scheme.getSeparatorPrimaryColor();
            Color secondary = scheme.getSeparatorSecondaryColor();
            Color primaryZero = toUseAlphaColors ? SubstanceColorUtilities.getAlphaColor(primary, 0) : SubstanceColorUtilities.getInterpolatedColor(primary, backgrFill, 0.0);
            Color secondaryZero = toUseAlphaColors ? SubstanceColorUtilities.getAlphaColor(secondary, 0) : SubstanceColorUtilities.getInterpolatedColor(secondary, backgrFill, 0.0);
            graphics.setStroke(new BasicStroke(borderStrokeWidth, 0, 1));
            if (orientation == 1) {
                int gradStart = Math.min(maxGradLengthStart, height / 2);
                int gradEnd = Math.min(maxGradLengthEnd, height / 2);
                float gradStartFraction = (float)gradStart / (float)height;
                float gradEndFraction = (float)(height - gradEnd) / (float)height;
                float regularX = Math.max(0.0f, (float)width / 2.0f - borderStrokeWidth);
                LinearGradientPaint primaryPaint = new LinearGradientPaint(0.0f, 0.0f, 0.0f, height, new float[]{0.0f, gradStartFraction, gradEndFraction, 1.0f}, new Color[]{primaryZero, primary, primary, primaryZero});
                graphics.setPaint(primaryPaint);
                graphics.draw(new Line2D.Float(regularX, 0.0f, regularX, height));
                if (hasShadow) {
                    float shadowX = regularX + borderStrokeWidth;
                    LinearGradientPaint secondaryPaint = new LinearGradientPaint(0.0f, 0.0f, 0.0f, height, new float[]{0.0f, gradStartFraction, gradEndFraction, 1.0f}, new Color[]{secondaryZero, secondary, secondary, secondaryZero});
                    graphics.setPaint(secondaryPaint);
                    graphics.draw(new Line2D.Float(shadowX, 0.0f, shadowX, height));
                }
            } else {
                int gradStart = Math.min(maxGradLengthStart, width / 2);
                int gradEnd = Math.min(maxGradLengthEnd, width / 2);
                graphics.translate(0, Math.max(0, height / 2 - 1));
                float gradStartFraction = (float)gradStart / (float)width;
                float gradEndFraction = (float)(width - gradEnd) / (float)width;
                float regularY = Math.max(0.0f, (float)height / 2.0f - borderStrokeWidth);
                LinearGradientPaint primaryPaint = new LinearGradientPaint(0.0f, 0.0f, width, 0.0f, new float[]{0.0f, gradStartFraction, gradEndFraction, 1.0f}, new Color[]{primaryZero, primary, primary, primaryZero});
                graphics.setPaint(primaryPaint);
                graphics.draw(new Line2D.Float(0.0f, regularY, width, regularY));
                if (hasShadow) {
                    float shadowY = regularY + borderStrokeWidth;
                    LinearGradientPaint secondaryPaint = new LinearGradientPaint(0.0f, 0.0f, width, 0.0f, new float[]{0.0f, gradStartFraction, gradEndFraction, 1.0f}, new Color[]{secondaryZero, secondary, secondary, secondaryZero});
                    graphics.setPaint(secondaryPaint);
                    graphics.draw(new Line2D.Float(0.0f, shadowY, width, shadowY));
                }
            }
            graphics.dispose();
            cached.put(key, singleLine);
        }
        Graphics2D g2d = (Graphics2D)g2.create();
        NeonCortex.drawImage(g2d, singleLine, 0, 0);
        g2d.dispose();
    }

    public static void paintVerticalLines(Graphics g2, Component c2, SubstanceColorScheme scheme, int y2, Collection<Integer> x2, int height, float fadeStartFraction) {
        int componentFontSize = SubstanceSizeUtils.getComponentFontSize(c2);
        Color backgrFill = SubstanceColorUtilities.getBackgroundFillColor(c2);
        HashMapKey key = SubstanceCoreUtilities.getHashKey(componentFontSize, scheme.getDisplayName(), 0, height, 1, true, 0.0, Float.valueOf(fadeStartFraction), backgrFill.getRGB());
        float borderStrokeWidth = SubstanceSizeUtils.getBorderStrokeWidth();
        BufferedImage singleLine = cached.get(key);
        if (singleLine == null) {
            singleLine = SubstanceCoreUtilities.getBlankImage(Math.max(2, (int)Math.ceil(2.0 * (double)borderStrokeWidth)), height);
            Graphics2D graphics = singleLine.createGraphics();
            Color primary = scheme.getSeparatorPrimaryColor();
            Color secondary = scheme.getSeparatorSecondaryColor();
            graphics.setStroke(new BasicStroke(borderStrokeWidth, 0, 1));
            Color primaryZero = SubstanceColorUtilities.getInterpolatedColor(primary, backgrFill, 0.0);
            Color secondaryZero = SubstanceColorUtilities.getInterpolatedColor(secondary, backgrFill, 0.0);
            LinearGradientPaint forePaint = new LinearGradientPaint(0.0f, 0.0f, 0.0f, height, new float[]{0.0f, fadeStartFraction, 1.0f}, new Color[]{primary, primary, primaryZero});
            graphics.setPaint(forePaint);
            graphics.translate(borderStrokeWidth / 2.0f, 0.0);
            graphics.draw(new Line2D.Float(borderStrokeWidth / 2.0f, 0.0f, borderStrokeWidth / 2.0f, height));
            LinearGradientPaint backPaint = new LinearGradientPaint(0.0f, 0.0f, 0.0f, height, new float[]{0.0f, fadeStartFraction, 1.0f}, new Color[]{secondary, secondary, secondaryZero});
            graphics.setPaint(backPaint);
            graphics.draw(new Line2D.Float(3.0f * borderStrokeWidth / 2.0f, 0.0f, 3.0f * borderStrokeWidth / 2.0f, height));
            graphics.dispose();
            cached.put(key, singleLine);
        }
        Graphics2D g2d = (Graphics2D)g2.create();
        for (int lineX : x2) {
            NeonCortex.drawImage(g2d, singleLine, lineX, y2);
        }
        g2d.dispose();
    }

    public static void paintHorizontalLines(Graphics g2, Component c2, SubstanceColorScheme scheme, int x2, Collection<Integer> y2, int width, float fadeStartFraction, boolean isLtr) {
        int componentFontSize = SubstanceSizeUtils.getComponentFontSize(c2);
        Color backgrFill = SubstanceColorUtilities.getBackgroundFillColor(c2);
        HashMapKey key = SubstanceCoreUtilities.getHashKey(componentFontSize, scheme.getDisplayName(), width, 0, 1, true, 0.0, Float.valueOf(fadeStartFraction), isLtr, backgrFill.getRGB());
        float borderStrokeWidth = SubstanceSizeUtils.getBorderStrokeWidth();
        BufferedImage singleLine = cached.get(key);
        if (singleLine == null) {
            singleLine = SubstanceCoreUtilities.getBlankImage(width, Math.max(2, (int)Math.ceil(2.0 * (double)borderStrokeWidth)));
            Graphics2D graphics = singleLine.createGraphics();
            Color primary = scheme.getSeparatorPrimaryColor();
            Color secondary = scheme.getSeparatorSecondaryColor();
            graphics.setStroke(new BasicStroke(borderStrokeWidth, 0, 1));
            Color primaryZero = SubstanceColorUtilities.getInterpolatedColor(primary, backgrFill, 0.0);
            Color secondaryZero = SubstanceColorUtilities.getInterpolatedColor(secondary, backgrFill, 0.0);
            LinearGradientPaint forePaint = new LinearGradientPaint(0.0f, 0.0f, width, 0.0f, new float[]{0.0f, fadeStartFraction, 1.0f}, new Color[]{isLtr ? primary : primaryZero, primary, isLtr ? primaryZero : primary});
            graphics.setPaint(forePaint);
            graphics.draw(new Line2D.Float(0.0f, borderStrokeWidth / 2.0f, width, borderStrokeWidth / 2.0f));
            LinearGradientPaint backPaint = new LinearGradientPaint(0.0f, 9.0f, width, 0.0f, new float[]{0.0f, fadeStartFraction, 1.0f}, new Color[]{isLtr ? secondary : secondaryZero, secondary, isLtr ? secondaryZero : secondary});
            graphics.setPaint(backPaint);
            graphics.draw(new Line2D.Float(0.0f, 3.0f * borderStrokeWidth / 2.0f, width, 3.0f * borderStrokeWidth / 2.0f));
            graphics.dispose();
            cached.put(key, singleLine);
        }
        Graphics2D g2d = (Graphics2D)g2.create();
        for (int lineY : y2) {
            NeonCortex.drawImage(g2d, singleLine, x2, lineY);
        }
        g2d.dispose();
    }
}

