/*
 * Decompiled with CFR 0.152.
 */
package org.pushingpixels.substance.internal.painter;

import java.awt.Component;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Shape;
import javax.swing.CellRendererPane;
import javax.swing.JComponent;
import javax.swing.JPopupMenu;
import javax.swing.SwingUtilities;
import org.pushingpixels.substance.api.SubstanceCortex;
import org.pushingpixels.substance.api.SubstanceSkin;
import org.pushingpixels.substance.api.SubstanceSlices;
import org.pushingpixels.substance.api.colorscheme.SubstanceColorScheme;
import org.pushingpixels.substance.api.painter.decoration.SubstanceDecorationPainter;
import org.pushingpixels.substance.internal.utils.SubstanceCoreUtilities;

public class DecorationPainterUtils {
    private static final String DECORATION_AREA_TYPE = "substancelaf.internal.painter.decorationAreaType";
    public static final String POPUP_INVOKER_LINK = "substancelaf.internal.popupInvokerLink";

    public static void setDecorationType(JComponent comp, SubstanceSlices.DecorationAreaType type) {
        comp.putClientProperty(DECORATION_AREA_TYPE, type);
    }

    public static void clearDecorationType(JComponent comp) {
        if (comp != null) {
            comp.putClientProperty(DECORATION_AREA_TYPE, null);
        }
    }

    public static SubstanceSlices.DecorationAreaType getDecorationType(Component comp) {
        Component invoker;
        JPopupMenu popupMenu = null;
        JComponent popupInvoker = null;
        for (Component c2 = comp; c2 != null; c2 = c2.getParent()) {
            if (c2 instanceof JComponent) {
                JComponent jc2 = (JComponent)c2;
                Object prop = jc2.getClientProperty(DECORATION_AREA_TYPE);
                if (prop instanceof SubstanceSlices.DecorationAreaType) {
                    return (SubstanceSlices.DecorationAreaType)prop;
                }
                Object invokerProp = jc2.getClientProperty(POPUP_INVOKER_LINK);
                if (invokerProp instanceof PopupInvokerLink) {
                    popupInvoker = ((PopupInvokerLink)invokerProp).getPopupInvoker();
                }
            }
            if (!(c2 instanceof JPopupMenu)) continue;
            popupMenu = (JPopupMenu)c2;
        }
        if (popupMenu != null && popupMenu != (invoker = popupMenu.getInvoker())) {
            return DecorationPainterUtils.getDecorationType(popupMenu.getInvoker());
        }
        if (popupInvoker != null) {
            return DecorationPainterUtils.getDecorationType(popupInvoker);
        }
        return SubstanceSlices.DecorationAreaType.NONE;
    }

    public static SubstanceSlices.DecorationAreaType getImmediateDecorationType(Component comp) {
        JComponent jc2;
        Object prop;
        Component c2 = comp;
        if (c2 instanceof JComponent && (prop = (jc2 = (JComponent)c2).getClientProperty(DECORATION_AREA_TYPE)) instanceof SubstanceSlices.DecorationAreaType) {
            return (SubstanceSlices.DecorationAreaType)prop;
        }
        return null;
    }

    public static void paintDecorationBackground(Graphics g2, Component c2, boolean force) {
        SubstanceSlices.DecorationAreaType decorationType = SubstanceCortex.ComponentOrParentChainScope.getDecorationType(c2);
        DecorationPainterUtils.paintDecorationBackground(g2, c2, decorationType, force);
    }

    private static void paintDecorationBackground(Graphics g2, Component c2, SubstanceSlices.DecorationAreaType decorationType, boolean force) {
        boolean isInCellRenderer = SwingUtilities.getAncestorOfClass(CellRendererPane.class, c2) != null;
        boolean isPreviewMode = false;
        if (c2 instanceof JComponent) {
            isPreviewMode = Boolean.TRUE.equals(((JComponent)c2).getClientProperty("substance.widget.internal.previewMode"));
        }
        if (!(force || isPreviewMode || c2.isShowing() || isInCellRenderer)) {
            return;
        }
        if (c2.getHeight() == 0 || c2.getWidth() == 0) {
            return;
        }
        SubstanceSkin skin = SubstanceCoreUtilities.getSkin(c2);
        SubstanceDecorationPainter painter = skin.getDecorationPainter();
        Graphics2D g2d = (Graphics2D)g2.create();
        painter.paintDecorationArea(g2d, c2, decorationType, c2.getWidth(), c2.getHeight(), skin);
        g2d.dispose();
    }

    public static void paintDecorationArea(Graphics g2, Component c2, Shape contour, SubstanceSlices.DecorationAreaType decorationType, SubstanceColorScheme colorScheme, boolean force) {
        boolean isInCellRenderer = SwingUtilities.getAncestorOfClass(CellRendererPane.class, c2) != null;
        boolean isPreviewMode = false;
        if (c2 instanceof JComponent) {
            isPreviewMode = Boolean.TRUE.equals(((JComponent)c2).getClientProperty("substance.widget.internal.previewMode"));
        }
        if (!(force || isPreviewMode || c2.isShowing() || isInCellRenderer)) {
            return;
        }
        if (c2.getHeight() == 0 || c2.getWidth() == 0) {
            return;
        }
        SubstanceSkin skin = SubstanceCoreUtilities.getSkin(c2);
        SubstanceDecorationPainter painter = skin.getDecorationPainter();
        Graphics2D g2d = (Graphics2D)g2.create();
        painter.paintDecorationArea(g2d, c2, decorationType, contour, colorScheme);
        g2d.dispose();
    }

    public static interface PopupInvokerLink {
        public JComponent getPopupInvoker();
    }
}

