/*
 * Decompiled with CFR 0.152.
 */
package org.pushingpixels.substance.internal.painter;

import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import javax.swing.CellRendererPane;
import javax.swing.JComponent;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import javax.swing.JSpinner;
import javax.swing.SwingUtilities;
import javax.swing.text.JTextComponent;
import org.pushingpixels.substance.api.SubstanceCortex;
import org.pushingpixels.substance.api.SubstanceSkin;
import org.pushingpixels.substance.api.SubstanceSlices;
import org.pushingpixels.substance.internal.painter.DecorationPainterUtils;
import org.pushingpixels.substance.internal.painter.OverlayPainterUtils;
import org.pushingpixels.substance.internal.utils.SubstanceColorUtilities;
import org.pushingpixels.substance.internal.utils.SubstanceCoreUtilities;
import org.pushingpixels.substance.internal.utils.SubstancePopupContainer;
import org.pushingpixels.substance.internal.utils.WidgetUtilities;

public class BackgroundPaintingUtils {
    public static void updateIfOpaque(Graphics g2, JComponent c2) {
        if (SubstanceCoreUtilities.isOpaque(c2)) {
            BackgroundPaintingUtils.update(g2, c2, false);
        }
    }

    public static void update(Graphics g2, JComponent c2, boolean force) {
        if (!SubstanceCoreUtilities.isCurrentLookAndFeel()) {
            return;
        }
        Graphics2D graphics = (Graphics2D)g2.create();
        graphics.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_OFF);
        graphics.setComposite(WidgetUtilities.getAlphaComposite((Component)c2, g2));
        SubstanceSlices.DecorationAreaType decorationType = SubstanceCortex.ComponentOrParentChainScope.getDecorationType(c2);
        SubstanceSkin skin = SubstanceCoreUtilities.getSkin(c2);
        boolean isShowing = c2.isShowing();
        boolean showOverlays = true;
        if (c2.getParent() instanceof JPopupMenu || c2.getClass().isAnnotationPresent(SubstancePopupContainer.class)) {
            showOverlays = false;
        } else if (c2 instanceof JMenuItem) {
            showOverlays = false;
            if (c2 instanceof JMenu) {
                showOverlays = ((JMenu)c2).isTopLevelMenu();
            }
        } else if (c2 instanceof JMenuBar) {
            showOverlays = true;
        }
        if (isShowing && decorationType != SubstanceSlices.DecorationAreaType.NONE && skin.isRegisteredAsDecorationArea(decorationType)) {
            DecorationPainterUtils.paintDecorationBackground(graphics, c2, force);
            if (showOverlays) {
                OverlayPainterUtils.paintOverlays(graphics, c2, skin, decorationType);
            }
        } else {
            Color backgr = SubstanceColorUtilities.getBackgroundFillColor(c2 instanceof JTextComponent || c2 instanceof JSpinner ? c2.getParent() : c2);
            graphics.setColor(backgr);
            graphics.fillRect(0, 0, c2.getWidth(), c2.getHeight());
            if (isShowing && showOverlays) {
                OverlayPainterUtils.paintOverlays(graphics, c2, skin, decorationType);
            }
        }
        graphics.dispose();
    }

    public static void fillBackground(Graphics g2, JComponent c2, Color fillColor, Rectangle rect) {
        boolean isInCellRenderer;
        if (!SubstanceCoreUtilities.isCurrentLookAndFeel()) {
            return;
        }
        boolean bl = isInCellRenderer = SwingUtilities.getAncestorOfClass(CellRendererPane.class, c2) != null;
        if (!c2.isShowing() && !isInCellRenderer) {
            return;
        }
        Graphics2D graphics = (Graphics2D)g2.create();
        graphics.setComposite(WidgetUtilities.getAlphaComposite((Component)c2, g2));
        graphics.setColor(fillColor);
        graphics.fillRect(rect.x, rect.y, rect.width, rect.height);
        graphics.dispose();
    }
}

