/*
 * Decompiled with CFR 0.152.
 */
package org.pushingpixels.substance.internal.contrib.randelshofer.quaqua.colorchooser;

import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics;
import javax.swing.Icon;
import javax.swing.JList;
import org.pushingpixels.substance.api.renderer.SubstanceDefaultListCellRenderer;
import org.pushingpixels.substance.internal.contrib.randelshofer.quaqua.colorchooser.PaletteEntry;
import org.pushingpixels.substance.internal.utils.SubstanceColorUtilities;
import org.pushingpixels.substance.internal.utils.SubstanceStripingUtils;

public class PaletteEntryCellRenderer
extends SubstanceDefaultListCellRenderer {
    private ColorIcon icon = new ColorIcon();

    public PaletteEntryCellRenderer() {
        this.setIcon(this.icon);
        this.setOpaque(false);
    }

    @Override
    public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
        this.setComponentOrientation(list.getComponentOrientation());
        this.setEnabled(list.isEnabled());
        this.setFont(list.getFont());
        SubstanceStripingUtils.applyStripedBackground(list, index, this);
        PaletteEntry entry = (PaletteEntry)value;
        this.icon.setColor(entry.getColor());
        this.setText(entry.getName());
        return this;
    }

    static class ColorIcon
    implements Icon {
        private Color color = Color.black;

        ColorIcon() {
        }

        public void setColor(Color c2) {
            this.color = c2;
        }

        public Color getColor() {
            return this.color;
        }

        @Override
        public int getIconHeight() {
            return 15;
        }

        @Override
        public int getIconWidth() {
            return 25;
        }

        @Override
        public void paintIcon(Component c2, Graphics g2, int x2, int y2) {
            g2.setColor(this.getColor());
            g2.fillRect(x2, y2, this.getIconWidth() - 1, this.getIconHeight() - 1);
            g2.setColor(SubstanceColorUtilities.deriveByBrightness(this.getColor(), -0.5f));
            g2.drawRect(x2, y2, this.getIconWidth() - 1, this.getIconHeight() - 1);
        }
    }
}

