/*
 * Decompiled with CFR 0.152.
 */
package org.pushingpixels.substance.internal.contrib.randelshofer.quaqua.colorchooser;

import java.awt.BorderLayout;
import java.awt.CardLayout;
import java.awt.Component;
import java.awt.Insets;
import java.util.EnumSet;
import javax.swing.AbstractButton;
import javax.swing.ButtonGroup;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JToggleButton;
import javax.swing.JToolBar;
import javax.swing.border.EmptyBorder;
import org.pushingpixels.substance.api.SubstanceCortex;
import org.pushingpixels.substance.api.SubstanceSlices;
import org.pushingpixels.substance.internal.contrib.randelshofer.quaqua.colorchooser.SubstanceColorChooserPanel;
import org.pushingpixels.substance.internal.utils.icon.TransitionAwareIcon;

public class ColorChooserMainPanel
extends JPanel {
    private static String lastSelectedChooserName = null;
    private JPanel chooserPanelHolder;
    private JPanel mainPanel;
    private JPanel northPanel;
    private JPanel previewPanelHolder;
    private JToolBar toolBar;
    private ButtonGroup toolBarButtonGroup;

    public ColorChooserMainPanel() {
        this.initComponents();
    }

    public void setPreviewPanel(JComponent c2) {
        this.previewPanelHolder.removeAll();
        if (c2 != null) {
            this.previewPanelHolder.add(c2);
        }
    }

    public void addColorChooserPanel(SubstanceColorChooserPanel ccp) {
        String displayName = ccp.getDisplayName();
        if (displayName.equals("Color Picker")) {
            this.northPanel.add((Component)ccp, "West");
        } else {
            JToggleButton tb2 = new JToggleButton();
            tb2.setIcon(new TransitionAwareIcon(tb2, scheme -> ccp.getHiDpiAwareIcon(18, scheme), ccp.getDisplayName()));
            tb2.setToolTipText(displayName);
            tb2.setFocusable(false);
            SubstanceCortex.ComponentScope.setButtonStraightSides(tb2, EnumSet.allOf(SubstanceSlices.Side.class));
            JPanel centerView = new JPanel(new BorderLayout());
            centerView.add(ccp);
            this.chooserPanelHolder.add((Component)centerView, displayName);
            this.toolBarButtonGroup.add(tb2);
            this.toolBar.add(tb2);
            if (this.toolBar.getComponentCount() == 1 || lastSelectedChooserName != null && lastSelectedChooserName.equals(displayName)) {
                tb2.setSelected(true);
                CardLayout cl = (CardLayout)this.chooserPanelHolder.getLayout();
                cl.show(this.chooserPanelHolder, displayName);
            }
            tb2.addItemListener(itemEvent -> {
                if (itemEvent.getStateChange() == 1) {
                    CardLayout cl = (CardLayout)this.chooserPanelHolder.getLayout();
                    cl.show(this.chooserPanelHolder, displayName);
                    lastSelectedChooserName = displayName;
                }
            });
        }
    }

    public void removeAllColorChooserPanels() {
        Component[] tb2 = this.toolBar.getComponents();
        for (int i2 = 0; i2 < tb2.length; ++i2) {
            if (!(tb2[i2] instanceof AbstractButton)) continue;
            this.toolBarButtonGroup.remove((AbstractButton)tb2[i2]);
        }
        this.toolBar.removeAll();
        this.chooserPanelHolder.removeAll();
        this.northPanel.removeAll();
        this.northPanel.add(this.previewPanelHolder);
    }

    private void initComponents() {
        this.toolBarButtonGroup = new ButtonGroup();
        this.toolBar = new JToolBar();
        this.mainPanel = new JPanel();
        this.northPanel = new JPanel();
        this.previewPanelHolder = new JPanel();
        this.chooserPanelHolder = new JPanel();
        this.setLayout(new BorderLayout());
        this.toolBar.setFloatable(false);
        this.add((Component)this.toolBar, "North");
        this.mainPanel.setLayout(new BorderLayout());
        this.mainPanel.setBorder(new EmptyBorder(new Insets(5, 4, 7, 4)));
        this.northPanel.setLayout(new BorderLayout());
        this.previewPanelHolder.setLayout(new BorderLayout());
        this.northPanel.add((Component)this.previewPanelHolder, "Center");
        this.mainPanel.add((Component)this.northPanel, "North");
        this.chooserPanelHolder.setLayout(new CardLayout());
        this.chooserPanelHolder.setBorder(new EmptyBorder(new Insets(5, 0, 0, 0)));
        this.mainPanel.add((Component)this.chooserPanelHolder, "Center");
        this.add((Component)this.mainPanel, "Center");
    }
}

