/*
 * Decompiled with CFR 0.152.
 */
package org.pushingpixels.neon.internal.font;

import java.awt.Font;
import org.pushingpixels.neon.api.font.FontPolicy;
import org.pushingpixels.neon.api.font.FontSet;
import org.pushingpixels.neon.internal.contrib.jgoodies.looks.LookUtils;
import org.pushingpixels.neon.internal.font.FontSets;
import org.pushingpixels.neon.internal.font.Fonts;

public final class FontPolicies {
    private FontPolicies() {
    }

    public static FontPolicy createFixedPolicy(FontSet fontSet) {
        return new FixedPolicy(fontSet);
    }

    public static FontPolicy getDefaultPlasticOnWindowsPolicy() {
        return new DefaultPlasticOnWindowsPolicy();
    }

    public static FontPolicy getDefaultPlasticPolicy() {
        if (LookUtils.IS_OS_WINDOWS) {
            return FontPolicies.getDefaultPlasticOnWindowsPolicy();
        }
        return FontPolicies.getLogicalFontsPolicy();
    }

    public static FontPolicy getDefaultWindowsPolicy() {
        return new DefaultWindowsPolicy();
    }

    public static FontPolicy getLogicalFontsPolicy() {
        return FontPolicies.createFixedPolicy(FontSets.getLogicalFontSet());
    }

    private static final class FixedPolicy
    implements FontPolicy {
        private final FontSet fontSet;

        FixedPolicy(FontSet fontSet) {
            this.fontSet = fontSet;
        }

        @Override
        public FontSet getFontSet() {
            return this.fontSet;
        }
    }

    private static final class DefaultWindowsPolicy
    implements FontPolicy {
        private DefaultWindowsPolicy() {
        }

        @Override
        public FontSet getFontSet() {
            Font windowsControlFont = Fonts.getWindowsControlFont();
            Font controlFont = windowsControlFont != null ? windowsControlFont : new FontSets.DefaultUIResourceFont("Dialog", 0, 12);
            Font menuFont = controlFont;
            Font titleFont = controlFont;
            Font messageFont = controlFont;
            Font smallFont = controlFont.deriveFont(controlFont.getSize2D() - 2.0f);
            Font windowTitleFont = controlFont;
            return FontSets.createDefaultFontSet(controlFont, menuFont, titleFont, messageFont, smallFont, windowTitleFont);
        }
    }

    private static final class DefaultPlasticOnWindowsPolicy
    implements FontPolicy {
        private DefaultPlasticOnWindowsPolicy() {
        }

        @Override
        public FontSet getFontSet() {
            Font windowsControlFont = Fonts.getWindowsControlFont();
            Font controlFont = windowsControlFont != null ? windowsControlFont : new Font("Dialog", 0, 12);
            Font menuFont = controlFont;
            Font titleFont = controlFont.deriveFont(1);
            return FontSets.createDefaultFontSet(controlFont, menuFont, titleFont);
        }
    }
}

