/*
 * Decompiled with CFR 0.152.
 */
package org.pushingpixels.neon.internal.contrib.intellij;

import java.awt.Graphics2D;
import java.awt.GraphicsConfiguration;
import java.awt.GraphicsDevice;
import java.awt.GraphicsEnvironment;
import java.awt.geom.AffineTransform;
import java.util.WeakHashMap;

public class UIUtil {
    private static Double cachedScaleFactorReply = null;

    public static double getScaleFactor(Graphics2D graphics) {
        return DetectRetinaKit.getScaleFactor(graphics);
    }

    public static double getScaleFactor() {
        if (cachedScaleFactorReply != null) {
            return cachedScaleFactorReply;
        }
        double result = GraphicsEnvironment.isHeadless() ? 1.0 : DetectRetinaKit.getScaleFactor();
        cachedScaleFactorReply = result;
        return cachedScaleFactorReply;
    }

    private static final class DetectRetinaKit {
        private static final WeakHashMap<GraphicsDevice, Double> devicesScaleFactorCacheMap = new WeakHashMap();

        private DetectRetinaKit() {
        }

        private static double getScaleFactorModern(GraphicsDevice device) {
            GraphicsConfiguration graphicsConfig = device.getDefaultConfiguration();
            AffineTransform tx = graphicsConfig.getDefaultTransform();
            double scaleX = tx.getScaleX();
            double scaleY = tx.getScaleY();
            return Math.max(scaleX, scaleY);
        }

        private static double getScaleFactor(GraphicsDevice device) {
            if (devicesScaleFactorCacheMap.containsKey(device)) {
                return devicesScaleFactorCacheMap.get(device);
            }
            double result = DetectRetinaKit.getScaleFactorModern(device);
            devicesScaleFactorCacheMap.put(device, result);
            return result;
        }

        private static double getScaleFactor(Graphics2D g2) {
            GraphicsDevice device = g2.getDeviceConfiguration().getDevice();
            return DetectRetinaKit.getScaleFactor(device);
        }

        private static double getScaleFactor() {
            GraphicsDevice[] devices;
            double result = 1.0;
            GraphicsEnvironment e2 = GraphicsEnvironment.getLocalGraphicsEnvironment();
            for (GraphicsDevice device : devices = e2.getScreenDevices()) {
                result = Math.max(result, DetectRetinaKit.getScaleFactor(device));
            }
            return result;
        }
    }
}

