/*
 * Decompiled with CFR 0.152.
 */
package org.pushingpixels.neon.internal.contrib.intellij;

import java.awt.Graphics2D;
import java.awt.image.BufferedImage;
import java.awt.image.ColorModel;
import java.awt.image.WritableRaster;
import org.pushingpixels.neon.internal.contrib.intellij.HiDPIScaledGraphics;
import org.pushingpixels.neon.internal.contrib.intellij.UIUtil;

public class JBHiDPIScaledImage
extends BufferedImage {
    private boolean ignoreScaling;

    private JBHiDPIScaledImage(int width, int height, int type) {
        super(width, height, type);
    }

    private JBHiDPIScaledImage(ColorModel cm, WritableRaster raster, boolean isRasterPremultiplied) {
        super(cm, raster, isRasterPremultiplied, null);
    }

    public static JBHiDPIScaledImage create(int width, int height, int type) {
        return new JBHiDPIScaledImage((int)Math.ceil(UIUtil.getScaleFactor() * (double)width), (int)Math.ceil(UIUtil.getScaleFactor() * (double)height), type);
    }

    public static JBHiDPIScaledImage createUnscaled(int width, int height, int type) {
        JBHiDPIScaledImage result = new JBHiDPIScaledImage(width, height, type);
        result.ignoreScaling = true;
        return result;
    }

    public static JBHiDPIScaledImage create(ColorModel cm, WritableRaster raster, boolean isRasterPremultiplied) {
        return new JBHiDPIScaledImage(cm, raster, isRasterPremultiplied);
    }

    @Override
    public Graphics2D createGraphics() {
        Graphics2D g2 = super.createGraphics();
        if (!this.ignoreScaling) {
            double scaleFactor = UIUtil.getScaleFactor();
            g2.scale(scaleFactor, scaleFactor);
        }
        return new HiDPIScaledGraphics(g2);
    }
}

