/*
 * Decompiled with CFR 0.152.
 */
package org.osbot.rs07.api.model;

import java.util.List;
import org.osbot.core.api.Wrapper;
import org.osbot.rs07.Bot;
import org.osbot.rs07.accessor.XCharacter;
import org.osbot.rs07.accessor.XClient;
import org.osbot.rs07.accessor.XHitBarChangeNode;
import org.osbot.rs07.accessor.XHitBarDefinition;
import org.osbot.rs07.accessor.XHitBarNode;
import org.osbot.rs07.accessor.XWorldView;
import org.osbot.rs07.api.model.Animable;
import org.osbot.rs07.api.model.Entity;
import org.osbot.rs07.api.model.NPC;
import org.osbot.rs07.api.model.Player;
import org.osbot.rs07.api.model.SpotAnimation;
import org.osbot.rs07.api.ui.HeadMessage;
import org.osbot.rs07.api.ui.Skill;
import org.osbot.rs07.api.util.NodeDequeIteratorG;
import org.osbot.rs07.input.mouse.MoveMouseEvent;

public abstract class Character<C extends XCharacter<?>>
extends Animable<C>
implements Entity {
    private XHitBarChangeNode IiiiiiIIiii;
    private int iiIiIiiiIii;
    private int IIIiiiIiIII = 100;
    private XWorldView iIiIIiiIiii;

    public abstract int getPrayerIcon();

    public int getRotation() {
        return ((XCharacter)this.accessor).getRotation();
    }

    public int getAnimationDelay() {
        return ((XCharacter)this.accessor).getAnimationDelay();
    }

    @Override
    public int getX() {
        return this.getWorldView().getMapBaseX() + this.getLocalX();
    }

    @Override
    public XWorldView getWorldView() {
        Character character = this;
        if (this.iIiIIiiIiii != null) {
            return character.iIiIIiiIiii;
        }
        return character.getClient().getRootWorldView();
    }

    @Override
    public int getSizeX() {
        return 1;
    }

    public boolean isInteracting(Character<?> character) {
        Character<?> iIiIIiiIiii = this.getInteracting();
        return iIiIIiiIiii != null && iIiIIiiIiii.equals(character);
    }

    public int getHealthPercent() {
        if (this.iIiIiiIiiIi() != null) {
            return this.IIIiiiIiIII;
        }
        return 100;
    }

    public boolean isUnderAttack() {
        if (!this.isHitBarVisible()) {
            return false;
        }
        for (NPC nPC : this.getMethods().getNpcs().getAll()) {
            if (!nPC.isInteracting(this)) continue;
            return true;
        }
        for (Player player : this.getMethods().getPlayers().getAll()) {
            if (!player.isInteracting(this)) continue;
            return true;
        }
        return false;
    }

    public boolean isHitBarVisible() {
        return this.getHitBarLoopCycle() > ((XClient)this.getClient().accessor).getCurrentTime();
    }

    public boolean hasMentionedPhrase(String phrase, long maxTime) {
        return this.hasMentionedPhrase(phrase, 0L, maxTime);
    }

    public int getRotationForCamera() {
        return (int)((360.0 - (double)((XCharacter)this.accessor).getRotation() / 512.0 * 90.0 + 180.0) % 360.0);
    }

    @Override
    public int getY() {
        return this.getWorldView().getMapBaseY() + this.getLocalY();
    }

    @Override
    public int getZ() {
        return this.getWorldView().getPlane();
    }

    @Deprecated
    public int getCurrentHealth() {
        if (this instanceof Player) {
            Character character = this;
            if (character == ((Bot)character.bot).getMethods().myPlayer()) {
                return ((Bot)this.bot).getMethods().skills.getDynamic(Skill.HITPOINTS);
            }
        }
        return this.getHealthPercent();
    }

    public SpotAnimation getSpotAnimation() {
        return (SpotAnimation)Wrapper.wrap(((XCharacter)this.accessor).getAnimationSpot(), new Object[0]);
    }

    @Deprecated
    public int getCombatTime() {
        XHitBarChangeNode iIiIIiiIiii = this.iIiIiiIiiIi();
        if (iIiIIiiIiii != null) {
            return iIiIIiiIiii.getTime();
        }
        return 0;
    }

    /*
     * WARNING - void declaration
     */
    public Character(C c2) {
        super(instance);
        void instance;
    }

    @Deprecated
    public int getAnimationSpot() {
        return -1;
    }

    public int getWalkingQueueSize() {
        return ((XCharacter)this.accessor).getWalkingQueueSize();
    }

    public int[] getSplatSecondaryDamage() {
        return ((XCharacter)this.accessor).getSplatSecondaryDamage();
    }

    @Deprecated
    public int getHealth() {
        return this.getHealthPercent();
    }

    public int[] getSplatTime() {
        return ((XCharacter)this.accessor).getSplatTime();
    }

    public int[] getWalkingQueueX() {
        return ((XCharacter)this.accessor).getWalkingQueueX();
    }

    public int getAnimation() {
        return ((XCharacter)this.accessor).getAnimation().getId();
    }

    public int getHitBarLoopCycle() {
        XHitBarChangeNode iIiIIiiIiii = this.iIiIiiIiiIi();
        if (iIiIIiiIiii != null) {
            return iIiIIiiIiii.getTime() + 300;
        }
        return 0;
    }

    public int getHealthPercentCache() {
        Character character = this;
        character.iIiIiiIiiIi();
        return character.IIIiiiIiIII;
    }

    @Override
    public int getSizeY() {
        return 1;
    }

    public boolean hasMentionedPhrase(String phrase, long minTime, long maxTime) {
        long iIiIIiiIiii = System.currentTimeMillis();
        for (HeadMessage iIiIIiiIiii2 : this.getRecentMessages()) {
            if (iIiIIiiIiii2 == null || iIiIIiiIiii - iIiIIiiIiii2.getTime() < minTime || iIiIIiiIiii - iIiIIiiIiii2.getTime() > maxTime || !iIiIIiiIiii2.getMessage().toLowerCase().contains(phrase.toLowerCase())) continue;
            return true;
        }
        return false;
    }

    public int[] getWalkingQueueY() {
        return ((XCharacter)this.accessor).getWalkingQueueY();
    }

    @Override
    public int getLocalX() {
        return ((XCharacter)this.accessor).getWalkingQueueX()[0];
    }

    @Deprecated
    public void _setWorldView(XWorldView worldView) {
        this.iIiIIiiIiii = worldView;
    }

    public int getAnimation2() {
        return ((XCharacter)this.accessor).getAnimation2().getId();
    }

    public String getHeadMessage() {
        return ((XCharacter)this.accessor).getHeadMessage();
    }

    private XHitBarChangeNode iIiIiiIiiIi() {
        int iIiIIiiIiii = ((Bot)this.bot).getClient().getCurrentTick();
        if (this.iiIiIiiiIii == iIiIIiiIiii || ((XCharacter)this.accessor).getHitBars() == null) {
            return this.IiiiiiIIiii;
        }
        XHitBarChangeNode iIiIIiiIiii2 = null;
        XHitBarDefinition iIiIIiiIiii3 = null;
        for (XHitBarNode iIiIIiiIiii4 : new NodeDequeIteratorG(((XCharacter)this.accessor).getHitBars())) {
            if (iIiIIiiIiii4 == null) continue;
            iIiIIiiIiii3 = iIiIIiiIiii4.getDefinition();
            for (XHitBarChangeNode iIiIIiiIiii5 : new NodeDequeIteratorG(iIiIIiiIiii4.getChanges())) {
                if (iIiIIiiIiii2 != null && (iIiIIiiIiii5 == null || iIiIIiiIiii5.getTime() < iIiIIiiIiii2.getTime())) continue;
                iIiIIiiIiii2 = iIiIIiiIiii5;
            }
        }
        this.IiiiiiIIiii = iIiIIiiIiii2;
        this.iiIiIiiiIii = iIiIIiiIiii;
        if (iIiIIiiIiii2 != null) {
            this.IIIiiiIiIII = (int)Math.ceil((double)iIiIIiiIiii2.getHpPercentBegin() / (double)iIiIIiiIiii3.getBarScale() * 100.0);
        }
        return iIiIIiiIiii2;
    }

    public boolean isAnimating() {
        return this.getAnimation() != -1 || this.getAnimationDelay() != 0;
    }

    public int[] getSplatType() {
        return ((XCharacter)this.accessor).getSplatType();
    }

    public List<HeadMessage> getRecentMessages() {
        return this.getClient().getHeadMessages(this);
    }

    @Override
    public int getGridY() {
        return ((XCharacter)this.accessor).getGridY();
    }

    @Override
    public int getGridX() {
        return ((XCharacter)this.accessor).getGridX();
    }

    public boolean isAttackable() {
        block5: {
            block4: {
                if (this.getMethods().getMap().isMultiway()) {
                    return this.getHealthPercent() > 0;
                }
                if (this.getHealthPercent() > 0 && !this.isUnderAttack()) break block4;
                Character character = this;
                if (!character.isInteracting(character.getMethods().myPlayer())) break block5;
            }
            return true;
        }
        return false;
    }

    @Override
    public int getLocalY() {
        return ((XCharacter)this.accessor).getWalkingQueueY()[0];
    }

    @Override
    public boolean hover() {
        return !((Bot)this.bot).getEventExecutor().execute(new MoveMouseEvent(this)).hasFailed();
    }

    public Character<?> getInteracting() {
        int iIiIIiiIiii = ((XCharacter)this.accessor).getCharacterFacingUid();
        if (iIiIIiiIiii == -1) {
            return null;
        }
        if (iIiIIiiIiii < 65536) {
            return ((Bot)this.bot).getMethods().getNpcs().getLocalNPC(iIiIIiiIiii);
        }
        if ((iIiIIiiIiii -= 65536) == this.getClient().getMyPlayerIndex()) {
            return ((Bot)this.bot).getMethods().myPlayer();
        }
        return ((Bot)this.bot).getMethods().getPlayers().getLocalPlayer(iIiIIiiIiii);
    }

    public int[] getSplatDamage() {
        return ((XCharacter)this.accessor).getSplatDamage();
    }

    public abstract int getIndex();

    @Deprecated
    public int getMaximumHealth() {
        if (this instanceof Player) {
            Character character = this;
            if (character == ((Bot)character.bot).getMethods().myPlayer()) {
                return ((Bot)this.bot).getMethods().skills.getStatic(Skill.HITPOINTS);
            }
        }
        return 100;
    }

    public int[] getSplatSecondaryType() {
        return ((XCharacter)this.accessor).getSplatSecondaryType();
    }

    public boolean isMoving() {
        return this.getWalkingQueueSize() > 0;
    }

    public int getAnimationStanding() {
        return ((XCharacter)this.accessor).getAnimationStanding();
    }
}

