/*
 * Decompiled with CFR 0.152.
 */
package org.cef;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.io.FilenameFilter;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.HashSet;
import javax.swing.SwingUtilities;
import javax.swing.Timer;
import org.cef.CefClient;
import org.cef.CefSettings;
import org.cef.OS;
import org.cef.SystemBootstrap;
import org.cef.callback.CefSchemeHandlerFactory;
import org.cef.handler.CefAppHandler;
import org.cef.handler.CefAppHandlerAdapter;

public class CefApp
extends CefAppHandlerAdapter {
    private static CefApp self = null;
    private static CefAppHandler appHandler_ = null;
    private static CefAppState state_ = CefAppState.NONE;
    private Timer workTimer_ = null;
    private HashSet<CefClient> clients_ = new HashSet();
    private CefSettings settings_ = null;

    private CefApp(String[] args, CefSettings settings) throws UnsatisfiedLinkError {
        super(args);
        if (settings != null) {
            this.settings_ = settings.clone();
        }
        if (OS.isWindows()) {
            SystemBootstrap.loadLibrary("jawt");
            SystemBootstrap.loadLibrary("chrome_elf");
            SystemBootstrap.loadLibrary("libcef");
            SystemBootstrap.loadLibrary("jcef");
        } else if (OS.isLinux()) {
            SystemBootstrap.loadLibrary("cef");
        }
        if (appHandler_ == null) {
            appHandler_ = this;
        }
        try {
            Runnable r2 = new Runnable(){

                @Override
                public void run() {
                    if (!CefApp.this.N_PreInitialize()) {
                        throw new IllegalStateException("Failed to pre-initialize native code");
                    }
                }
            };
            if (SwingUtilities.isEventDispatchThread()) {
                r2.run();
            } else {
                SwingUtilities.invokeAndWait(r2);
            }
        }
        catch (Exception e2) {
            e2.printStackTrace();
        }
    }

    public static void addAppHandler(CefAppHandler appHandler) throws IllegalStateException {
        if (CefApp.getState().compareTo(CefAppState.NEW) > 0) {
            throw new IllegalStateException("Must be called before CefApp is initialized");
        }
        appHandler_ = appHandler;
    }

    public static synchronized CefApp getInstance() throws UnsatisfiedLinkError {
        return CefApp.getInstance(null, null);
    }

    public static synchronized CefApp getInstance(String[] args) throws UnsatisfiedLinkError {
        return CefApp.getInstance(args, null);
    }

    public static synchronized CefApp getInstance(CefSettings settings) throws UnsatisfiedLinkError {
        return CefApp.getInstance(null, settings);
    }

    public static synchronized CefApp getInstance(String[] args, CefSettings settings) throws UnsatisfiedLinkError {
        if (settings != null && CefApp.getState() != CefAppState.NONE && CefApp.getState() != CefAppState.NEW) {
            throw new IllegalStateException("Settings can only be passed to CEF before createClient is called the first time.");
        }
        if (self == null) {
            if (CefApp.getState() == CefAppState.TERMINATED) {
                throw new IllegalStateException("CefApp was terminated");
            }
            self = new CefApp(args, settings);
            CefApp.setState(CefAppState.NEW);
        }
        return self;
    }

    public final void setSettings(CefSettings settings) throws IllegalStateException {
        if (CefApp.getState() != CefAppState.NONE && CefApp.getState() != CefAppState.NEW) {
            throw new IllegalStateException("Settings can only be passed to CEF before createClient is called the first time.");
        }
        this.settings_ = settings.clone();
    }

    public final CefVersion getVersion() {
        try {
            return this.N_GetVersion();
        }
        catch (UnsatisfiedLinkError ule) {
            ule.printStackTrace();
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static final CefAppState getState() {
        CefAppState cefAppState = state_;
        synchronized (cefAppState) {
            return state_;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static final void setState(final CefAppState state) {
        CefAppState cefAppState = state_;
        synchronized (cefAppState) {
            state_ = state;
        }
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                if (appHandler_ != null) {
                    appHandler_.stateHasChanged(state);
                }
            }
        });
    }

    public final synchronized void dispose() {
        switch (CefApp.getState()) {
            case NEW: {
                CefApp.setState(CefAppState.TERMINATED);
                break;
            }
            case INITIALIZING: 
            case INITIALIZED: {
                CefApp.setState(CefAppState.SHUTTING_DOWN);
                if (this.clients_.isEmpty()) {
                    this.shutdown();
                    break;
                }
                HashSet<CefClient> clients = new HashSet<CefClient>(this.clients_);
                for (CefClient c2 : clients) {
                    c2.dispose();
                }
                break;
            }
        }
    }

    public synchronized CefClient createClient() {
        switch (CefApp.getState()) {
            case NEW: {
                CefApp.setState(CefAppState.INITIALIZING);
                this.initialize();
            }
            case INITIALIZING: 
            case INITIALIZED: {
                CefClient client = new CefClient();
                this.clients_.add(client);
                return client;
            }
        }
        throw new IllegalStateException("Can't crate client in state " + (Object)((Object)state_));
    }

    public boolean registerSchemeHandlerFactory(String schemeName, String domainName, CefSchemeHandlerFactory factory) {
        try {
            return this.N_RegisterSchemeHandlerFactory(schemeName, domainName, factory);
        }
        catch (Exception err) {
            err.printStackTrace();
            return false;
        }
    }

    public boolean clearSchemeHandlerFactories() {
        try {
            return this.N_ClearSchemeHandlerFactories();
        }
        catch (Exception err) {
            err.printStackTrace();
            return false;
        }
    }

    protected final synchronized void clientWasDisposed(CefClient client) {
        this.clients_.remove(client);
        if (this.clients_.isEmpty() && CefApp.getState().compareTo(CefAppState.SHUTTING_DOWN) >= 0) {
            this.shutdown();
        }
    }

    private final void initialize() {
        try {
            Runnable r2 = new Runnable(){

                @Override
                public void run() {
                    CefSettings settings;
                    String library_path = CefApp.getJcefLibPath();
                    System.out.println("initialize on " + Thread.currentThread() + " with library path " + library_path);
                    CefSettings cefSettings = settings = CefApp.this.settings_ != null ? CefApp.this.settings_ : new CefSettings();
                    if (OS.isMacintosh()) {
                        if (settings.browser_subprocess_path == null) {
                            Path path = Paths.get(library_path, "../Frameworks/jcef Helper.app/Contents/MacOS/jcef Helper");
                            settings.browser_subprocess_path = path.normalize().toAbsolutePath().toString();
                        }
                    } else if (OS.isWindows()) {
                        if (settings.browser_subprocess_path == null) {
                            Path path = Paths.get(library_path, "jcef_helper.exe");
                            settings.browser_subprocess_path = path.normalize().toAbsolutePath().toString();
                        }
                    } else if (OS.isLinux()) {
                        Path path;
                        if (settings.browser_subprocess_path == null) {
                            path = Paths.get(library_path, "jcef_helper");
                            settings.browser_subprocess_path = path.normalize().toAbsolutePath().toString();
                        }
                        if (settings.resources_dir_path == null) {
                            path = Paths.get(library_path, new String[0]);
                            settings.resources_dir_path = path.normalize().toAbsolutePath().toString();
                        }
                        if (settings.locales_dir_path == null) {
                            path = Paths.get(library_path, "locales");
                            settings.locales_dir_path = path.normalize().toAbsolutePath().toString();
                        }
                    }
                    if (CefApp.this.N_Initialize(appHandler_, settings)) {
                        CefApp.setState(CefAppState.INITIALIZED);
                    } else {
                        CefApp.setState(CefAppState.INITIALIZATION_FAILED);
                    }
                }
            };
            if (SwingUtilities.isEventDispatchThread()) {
                r2.run();
            } else {
                SwingUtilities.invokeAndWait(r2);
            }
        }
        catch (Exception e2) {
            e2.printStackTrace();
        }
    }

    protected final void handleBeforeTerminate() {
        System.out.println("Cmd+Q termination request.");
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                CefAppHandler handler = (CefAppHandler)(appHandler_ == null ? this : appHandler_);
                if (!handler.onBeforeTerminate()) {
                    CefApp.this.dispose();
                }
            }
        });
    }

    private final void shutdown() {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                System.out.println("shutdown on " + Thread.currentThread());
                CefApp.this.N_Shutdown();
                CefApp.setState(CefAppState.TERMINATED);
                self = null;
            }
        });
    }

    public final void doMessageLoopWork(final long delay_ms) {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                if (CefApp.getState() == CefAppState.TERMINATED) {
                    return;
                }
                long kMaxTimerDelay = 33L;
                if (CefApp.this.workTimer_ != null) {
                    CefApp.this.workTimer_.stop();
                    CefApp.this.workTimer_ = null;
                }
                if (delay_ms <= 0L) {
                    CefApp.this.N_DoMessageLoopWork();
                    CefApp.this.doMessageLoopWork(33L);
                } else {
                    long timer_delay_ms = delay_ms;
                    if (timer_delay_ms > 33L) {
                        timer_delay_ms = 33L;
                    }
                    CefApp.this.workTimer_ = new Timer((int)timer_delay_ms, new ActionListener(){

                        @Override
                        public void actionPerformed(ActionEvent evt) {
                            CefApp.this.workTimer_.stop();
                            CefApp.this.workTimer_ = null;
                            CefApp.this.N_DoMessageLoopWork();
                            CefApp.this.doMessageLoopWork(33L);
                        }
                    });
                    CefApp.this.workTimer_.start();
                }
            }
        });
    }

    public static final boolean startup(String[] args) {
        if (OS.isLinux() || OS.isMacintosh()) {
            SystemBootstrap.loadLibrary("jcef");
            return CefApp.N_Startup(OS.isMacintosh() ? CefApp.getCefFrameworkPath(args) : null);
        }
        return true;
    }

    private static final String getJcefLibPath() {
        String[] paths;
        String library_path = System.getProperty("java.library.path");
        for (String path : paths = library_path.split(System.getProperty("path.separator"))) {
            File dir = new File(path);
            String[] found = dir.list(new FilenameFilter(){

                @Override
                public boolean accept(File dir, String name) {
                    return name.equalsIgnoreCase("libjcef.dylib") || name.equalsIgnoreCase("libjcef.so") || name.equalsIgnoreCase("jcef.dll");
                }
            });
            if (found == null || found.length == 0) continue;
            return path;
        }
        return library_path;
    }

    private static final String getCefFrameworkPath(String[] args) {
        String switchPrefix = "--framework-dir-path=";
        for (String arg : args) {
            if (!arg.startsWith(switchPrefix)) continue;
            return new File(arg.substring(switchPrefix.length())).getAbsolutePath();
        }
        return new File(CefApp.getJcefLibPath() + "/../Frameworks/Chromium Embedded Framework.framework").getAbsolutePath();
    }

    private static final native boolean N_Startup(String var0);

    private final native boolean N_PreInitialize();

    private final native boolean N_Initialize(CefAppHandler var1, CefSettings var2);

    private final native void N_Shutdown();

    private final native void N_DoMessageLoopWork();

    private final native CefVersion N_GetVersion();

    private final native boolean N_RegisterSchemeHandlerFactory(String var1, String var2, CefSchemeHandlerFactory var3);

    private final native boolean N_ClearSchemeHandlerFactories();

    public static enum CefAppState {
        NONE,
        NEW,
        INITIALIZING,
        INITIALIZED,
        INITIALIZATION_FAILED,
        SHUTTING_DOWN,
        TERMINATED;

    }

    public final class CefVersion {
        public final int JCEF_COMMIT_NUMBER;
        public final int CEF_VERSION_MAJOR;
        public final int CEF_VERSION_MINOR;
        public final int CEF_VERSION_PATCH;
        public final int CEF_COMMIT_NUMBER;
        public final int CHROME_VERSION_MAJOR;
        public final int CHROME_VERSION_MINOR;
        public final int CHROME_VERSION_BUILD;
        public final int CHROME_VERSION_PATCH;

        private CefVersion(int jcefCommitNo, int cefMajor, int cefMinor, int cefPatch, int cefCommitNo, int chrMajor, int chrMin, int chrBuild, int chrPatch) {
            this.JCEF_COMMIT_NUMBER = jcefCommitNo;
            this.CEF_VERSION_MAJOR = cefMajor;
            this.CEF_VERSION_MINOR = cefMinor;
            this.CEF_VERSION_PATCH = cefPatch;
            this.CEF_COMMIT_NUMBER = cefCommitNo;
            this.CHROME_VERSION_MAJOR = chrMajor;
            this.CHROME_VERSION_MINOR = chrMin;
            this.CHROME_VERSION_BUILD = chrBuild;
            this.CHROME_VERSION_PATCH = chrPatch;
        }

        public String getJcefVersion() {
            return this.CEF_VERSION_MAJOR + "." + this.CEF_VERSION_MINOR + "." + this.CEF_VERSION_PATCH + "." + this.JCEF_COMMIT_NUMBER;
        }

        public String getCefVersion() {
            return this.CEF_VERSION_MAJOR + "." + this.CEF_VERSION_MINOR + "." + this.CEF_VERSION_PATCH;
        }

        public String getChromeVersion() {
            return this.CHROME_VERSION_MAJOR + "." + this.CHROME_VERSION_MINOR + "." + this.CHROME_VERSION_BUILD + "." + this.CHROME_VERSION_PATCH;
        }

        public String toString() {
            return "JCEF Version = " + this.getJcefVersion() + "\nCEF Version = " + this.getCefVersion() + "\nChromium Version = " + this.getChromeVersion();
        }
    }
}

