/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.compress.harmony.unpack200.bytecode;

import java.io.DataOutputStream;
import java.io.IOException;
import java.util.ArrayList;
import org.apache.commons.compress.harmony.unpack200.bytecode.AnnotationsAttribute;
import org.apache.commons.compress.harmony.unpack200.bytecode.CPUTF8;
import org.apache.commons.compress.harmony.unpack200.bytecode.ClassConstantPool;
import org.apache.commons.compress.harmony.unpack200.bytecode.ClassFileEntry;

public class RuntimeVisibleorInvisibleAnnotationsAttribute
extends AnnotationsAttribute {
    private final int num_annotations;
    private final AnnotationsAttribute.Annotation[] annotations;

    public RuntimeVisibleorInvisibleAnnotationsAttribute(CPUTF8 name, AnnotationsAttribute.Annotation[] annotations) {
        super(name);
        this.num_annotations = annotations.length;
        this.annotations = annotations;
    }

    @Override
    protected int getLength() {
        int length = 2;
        for (int i2 = 0; i2 < this.num_annotations; ++i2) {
            length += this.annotations[i2].getLength();
        }
        return length;
    }

    @Override
    protected void resolve(ClassConstantPool pool) {
        super.resolve(pool);
        for (int i2 = 0; i2 < this.annotations.length; ++i2) {
            this.annotations[i2].resolve(pool);
        }
    }

    @Override
    protected void writeBody(DataOutputStream dos) throws IOException {
        int size = dos.size();
        dos.writeShort(this.num_annotations);
        for (int i2 = 0; i2 < this.num_annotations; ++i2) {
            this.annotations[i2].writeBody(dos);
        }
        if (dos.size() - size != this.getLength()) {
            throw new Error();
        }
    }

    @Override
    public String toString() {
        return this.attributeName.underlyingString() + ": " + this.num_annotations + " annotations";
    }

    @Override
    protected ClassFileEntry[] getNestedClassFileEntries() {
        ArrayList<CPUTF8> nested = new ArrayList<CPUTF8>();
        nested.add(this.attributeName);
        for (int i2 = 0; i2 < this.annotations.length; ++i2) {
            nested.addAll(this.annotations[i2].getClassFileEntries());
        }
        ClassFileEntry[] nestedEntries = new ClassFileEntry[nested.size()];
        for (int i3 = 0; i3 < nestedEntries.length; ++i3) {
            nestedEntries[i3] = (ClassFileEntry)nested.get(i3);
        }
        return nestedEntries;
    }
}

