/*
 * Decompiled with CFR 0.152.
 */
package me.friwi.jcefmaven.impl.step.init;

import java.io.File;
import java.util.List;
import java.util.Objects;
import java.util.logging.Logger;
import me.friwi.jcefmaven.CefInitializationException;
import me.friwi.jcefmaven.EnumPlatform;
import me.friwi.jcefmaven.UnsupportedPlatformException;
import org.cef.CefApp;
import org.cef.CefSettings;
import org.cef.SystemBootstrap;

public class CefInitializer {
    private static final Logger LOGGER = Logger.getLogger(CefInitializer.class.getName());
    private static final String JAVA_LIBRARY_PATH = "java.library.path";

    public static CefApp initialize(File installDir, List<String> cefArgs, CefSettings cefSettings) throws UnsupportedPlatformException, CefInitializationException {
        Objects.requireNonNull(installDir, "installDir cannot be null");
        Objects.requireNonNull(cefArgs, "cefArgs cannot be null");
        Objects.requireNonNull(cefSettings, "cefSettings cannot be null");
        try {
            String path = System.getProperty(JAVA_LIBRARY_PATH);
            if (!path.endsWith(File.pathSeparator)) {
                path = path + File.pathSeparator;
            }
            path = path + installDir.getAbsolutePath();
            System.setProperty(JAVA_LIBRARY_PATH, path);
            SystemBootstrap.setLoader(libname -> {});
            try {
                System.loadLibrary("jawt");
            }
            catch (UnsatisfiedLinkError e2) {
                LOGGER.warning("Error while loading jawt library: " + e2.getMessage());
            }
            if (EnumPlatform.getCurrentPlatform().getOs().isWindows()) {
                System.load(new File(installDir, "chrome_elf.dll").getAbsolutePath());
                System.load(new File(installDir, "libcef.dll").getAbsolutePath());
                System.load(new File(installDir, "jcef.dll").getAbsolutePath());
            } else if (EnumPlatform.getCurrentPlatform().getOs().isLinux()) {
                System.load(new File(installDir, "libjcef.so").getAbsolutePath());
                boolean success = CefApp.startup(cefArgs.toArray(new String[0]));
                if (!success) {
                    throw new CefInitializationException("JCef did not initialize correctly!");
                }
                System.load(new File(installDir, "libcef.so").getAbsolutePath());
            } else if (EnumPlatform.getCurrentPlatform().getOs().isMacOSX()) {
                System.load(new File(installDir, "libjcef.dylib").getAbsolutePath());
                cefArgs.add(0, "--framework-dir-path=" + installDir.getAbsolutePath() + "/Chromium Embedded Framework.framework");
                cefArgs.add(0, "--main-bundle-path=" + installDir.getAbsolutePath() + "/jcef Helper.app");
                cefArgs.add(0, "--browser-subprocess-path=" + installDir.getAbsolutePath() + "/jcef Helper.app/Contents/MacOS/jcef Helper");
                cefSettings.browser_subprocess_path = installDir.getAbsolutePath() + "/jcef Helper.app/Contents/MacOS/jcef Helper";
                boolean success = CefApp.startup(cefArgs.toArray(new String[0]));
                if (!success) {
                    throw new CefInitializationException("JCef did not initialize correctly!");
                }
            }
            return CefApp.getInstance(cefArgs.toArray(new String[0]), cefSettings);
        }
        catch (RuntimeException e3) {
            throw new CefInitializationException("Error while initializing JCef", e3);
        }
    }
}

