/*
 * Decompiled with CFR 0.152.
 */
package me.friwi.jcefmaven.impl.step.fetch;

import com.google.gson.Gson;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.net.HttpURLConnection;
import java.net.URL;
import java.util.Collection;
import java.util.Map;
import java.util.Objects;
import java.util.function.Consumer;
import java.util.logging.Level;
import java.util.logging.Logger;
import me.friwi.jcefmaven.CefBuildInfo;
import me.friwi.jcefmaven.EnumPlatform;

public class PackageDownloader {
    private static final Gson GSON = new Gson();
    private static final Logger LOGGER = Logger.getLogger(PackageDownloader.class.getName());
    private static final int BUFFER_SIZE = 16384;

    public static void downloadNatives(CefBuildInfo info, EnumPlatform platform, File destination, Consumer<Float> progressConsumer, Collection<String> mirrors) throws IOException {
        Objects.requireNonNull(info, "info cannot be null");
        Objects.requireNonNull(platform, "platform cannot be null");
        Objects.requireNonNull(destination, "destination cannot be null");
        Objects.requireNonNull(progressConsumer, "progressConsumer cannot be null");
        Objects.requireNonNull(mirrors, "mirrors can not be null");
        if (mirrors.isEmpty()) {
            throw new RuntimeException("mirrors can not be empty");
        }
        if (!destination.createNewFile()) {
            throw new IOException("Could not create target file " + destination.getAbsolutePath());
        }
        String mvn_version = PackageDownloader.loadJCefMavenVersion();
        Exception lastException = null;
        for (String mirror : mirrors) {
            String m2 = mirror.replace("{platform}", platform.getIdentifier()).replace("{tag}", info.getReleaseTag()).replace("{mvn_version}", mvn_version);
            try {
                URL url = new URL(m2);
                HttpURLConnection uc2 = (HttpURLConnection)url.openConnection();
                try {
                    InputStream in = uc2.getInputStream();
                    try {
                        if (uc2.getResponseCode() != 200) {
                            LOGGER.log(Level.WARNING, "Request to mirror failed with code " + uc2.getResponseCode() + " from server: " + m2);
                            continue;
                        }
                        long length = uc2.getContentLengthLong();
                        try (FileOutputStream fos = new FileOutputStream(destination);){
                            int r2;
                            long progress = 0L;
                            progressConsumer.accept(Float.valueOf(0.0f));
                            byte[] buffer = new byte[16384];
                            long transferred = 0L;
                            while ((r2 = in.read(buffer)) > 0) {
                                fos.write(buffer, 0, r2);
                                long newprogress = (transferred += (long)r2) * 100L / length;
                                if (newprogress <= progress) continue;
                                progress = newprogress;
                                progressConsumer.accept(Float.valueOf(progress));
                            }
                            fos.flush();
                        }
                        uc2.disconnect();
                        return;
                    }
                    finally {
                        if (in == null) continue;
                        in.close();
                    }
                }
                catch (IOException e2) {
                    lastException = e2;
                    LOGGER.log(Level.WARNING, "Request failed with exception on mirror: " + m2 + " (" + e2.getClass().getSimpleName() + (e2.getMessage() == null ? "" : ": " + e2.getMessage()) + ")");
                    uc2.disconnect();
                }
            }
            catch (Exception e3) {
                LOGGER.log(Level.WARNING, "Request failed with exception on mirror: " + m2, e3);
                lastException = e3;
            }
        }
        if (lastException != null) {
            throw new IOException("None of the supplied mirrors were working", lastException);
        }
        throw new IOException("None of the supplied mirrors were working");
    }

    private static String loadJCefMavenVersion() throws IOException {
        Map object;
        try (InputStream in = PackageDownloader.class.getResourceAsStream("/jcefmaven_build_meta.json");){
            if (in == null) {
                throw new IOException("/jcefmaven_build_meta.json not found on class path");
            }
            object = GSON.fromJson((Reader)new InputStreamReader(in), Map.class);
        }
        catch (Exception e2) {
            throw new IOException("Invalid json content in jcefmaven_build_meta.json", e2);
        }
        return (String)object.get("version");
    }
}

