/*
 * Decompiled with CFR 0.152.
 */
package me.friwi.jcefmaven.impl.step.check;

import java.io.File;
import java.io.IOException;
import java.util.Objects;
import java.util.logging.Level;
import java.util.logging.Logger;
import me.friwi.jcefmaven.CefBuildInfo;
import me.friwi.jcefmaven.EnumPlatform;
import me.friwi.jcefmaven.UnsupportedPlatformException;

public class CefInstallationChecker {
    private static final Logger LOGGER = Logger.getLogger(CefInstallationChecker.class.getName());

    public static boolean checkInstallation(File installDir) throws UnsupportedPlatformException {
        CefBuildInfo required;
        CefBuildInfo installed;
        Objects.requireNonNull(installDir, "installDir cannot be null");
        File buildInfo = new File(installDir, "build_meta.json");
        if (!new File(installDir, "install.lock").exists()) {
            return false;
        }
        if (!buildInfo.exists()) {
            return false;
        }
        try {
            installed = CefBuildInfo.fromFile(buildInfo);
        }
        catch (IOException e2) {
            LOGGER.log(Level.WARNING, "Error while parsing existing installation. Reinstalling.", e2);
            return false;
        }
        try {
            required = CefBuildInfo.fromClasspath();
        }
        catch (IOException e3) {
            LOGGER.log(Level.WARNING, "Error while parsing existing installation. Reinstalling.", e3);
            return false;
        }
        return required.getReleaseTag().equals(installed.getReleaseTag()) && installed.getPlatform().equals(EnumPlatform.getCurrentPlatform().getIdentifier());
    }
}

