/*
 * Decompiled with CFR 0.152.
 */
package me.friwi.jcefmaven;

import com.google.gson.Gson;
import com.google.gson.JsonParseException;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.util.Map;
import java.util.Objects;
import org.cef.CefApp;

public class CefBuildInfo {
    private static final Gson GSON = new Gson();
    private static CefBuildInfo LOCAL_BUILD_INFO = null;
    private final String jcefUrl;
    private final String releaseTag;
    private final String releaseUrl;
    private final String platform;

    private CefBuildInfo(String jcefUrl, String releaseTag, String releaseUrl, String platform) {
        this.jcefUrl = jcefUrl;
        this.releaseTag = releaseTag;
        this.releaseUrl = releaseUrl;
        this.platform = platform;
    }

    public static CefBuildInfo fromClasspath() throws IOException {
        if (LOCAL_BUILD_INFO == null) {
            LOCAL_BUILD_INFO = CefBuildInfo.loadData(Objects.requireNonNull(CefApp.class.getResourceAsStream("/build_meta.json"), "The build_meta.json file from the jcef-api artifact could not be read"));
        }
        return LOCAL_BUILD_INFO;
    }

    public static CefBuildInfo fromFile(File file) throws IOException {
        return CefBuildInfo.loadData(Files.newInputStream(file.toPath(), new OpenOption[0]));
    }

    private static CefBuildInfo loadData(InputStream in) throws IOException {
        Map object;
        try {
            object = GSON.fromJson((Reader)new InputStreamReader(in), Map.class);
        }
        catch (JsonParseException e2) {
            throw new IOException("Invalid json content in build_meta.json", e2);
        }
        finally {
            in.close();
        }
        return new CefBuildInfo(Objects.requireNonNull(object.get("jcef_url"), "No jcef_url specified in build_meta.json").toString(), Objects.requireNonNull(object.get("release_tag"), "No release_tag specified in build_meta.json").toString(), Objects.requireNonNull(object.get("release_url"), "No release_url specified in build_meta.json").toString(), Objects.requireNonNull(object.get("platform"), "No platform specified in build_meta.json").toString());
    }

    public String getJcefUrl() {
        return this.jcefUrl;
    }

    public String getReleaseTag() {
        return this.releaseTag;
    }

    public String getReleaseUrl() {
        return this.releaseUrl;
    }

    public String getPlatform() {
        return this.platform;
    }
}

