/*
 * Decompiled with CFR 0.152.
 */
package jogamp.opengl.x11.glx;

import com.jogamp.common.nio.Buffers;
import com.jogamp.nativewindow.AbstractGraphicsDevice;
import com.jogamp.nativewindow.AbstractGraphicsScreen;
import com.jogamp.nativewindow.MutableSurface;
import com.jogamp.nativewindow.NativeSurface;
import com.jogamp.opengl.GLContext;
import com.jogamp.opengl.GLDrawableFactory;
import com.jogamp.opengl.GLException;
import java.nio.IntBuffer;
import jogamp.opengl.x11.glx.GLX;
import jogamp.opengl.x11.glx.X11GLXContext;
import jogamp.opengl.x11.glx.X11GLXDrawable;
import jogamp.opengl.x11.glx.X11GLXGraphicsConfiguration;

public class X11PbufferGLXDrawable
extends X11GLXDrawable {
    protected X11PbufferGLXDrawable(GLDrawableFactory gLDrawableFactory, NativeSurface nativeSurface) {
        super(gLDrawableFactory, nativeSurface, false);
    }

    @Override
    protected void setRealizedImpl() {
        if (this.realized) {
            this.createPbuffer();
        } else {
            this.destroyPbuffer();
        }
    }

    @Override
    public GLContext createContext(GLContext gLContext) {
        return new X11GLXContext(this, gLContext);
    }

    protected void destroyPbuffer() {
        NativeSurface nativeSurface = this.getNativeSurface();
        if (nativeSurface.getSurfaceHandle() != 0L) {
            GLX.glXDestroyPbuffer(nativeSurface.getDisplayHandle(), nativeSurface.getSurfaceHandle());
        }
        ((MutableSurface)nativeSurface).setSurfaceHandle(0L);
        if (DEBUG) {
            System.err.println(X11PbufferGLXDrawable.getThreadName() + ": Destroyed pbuffer " + this);
        }
    }

    private void createPbuffer() {
        MutableSurface mutableSurface = (MutableSurface)this.getNativeSurface();
        X11GLXGraphicsConfiguration x11GLXGraphicsConfiguration = (X11GLXGraphicsConfiguration)mutableSurface.getGraphicsConfiguration();
        AbstractGraphicsScreen abstractGraphicsScreen = x11GLXGraphicsConfiguration.getScreen();
        AbstractGraphicsDevice abstractGraphicsDevice = abstractGraphicsScreen.getDevice();
        long l2 = abstractGraphicsDevice.getHandle();
        if (DEBUG) {
            System.out.println(X11PbufferGLXDrawable.getThreadName() + ": Pbuffer config: " + x11GLXGraphicsConfiguration);
        }
        if (l2 == 0L) {
            throw new GLException("Null display");
        }
        int n2 = 0;
        IntBuffer intBuffer = Buffers.newDirectIntBuffer(7);
        intBuffer.put(n2++, 32833);
        intBuffer.put(n2++, mutableSurface.getSurfaceWidth());
        intBuffer.put(n2++, 32832);
        intBuffer.put(n2++, mutableSurface.getSurfaceHeight());
        intBuffer.put(n2++, 32796);
        intBuffer.put(n2++, 0);
        intBuffer.put(n2++, 0);
        long l3 = GLX.glXCreatePbuffer(l2, x11GLXGraphicsConfiguration.getFBConfig(), intBuffer);
        if (l3 == 0L) {
            throw new GLException("pbuffer creation error: glXCreatePbuffer() failed using fbConfig 0x" + Long.toHexString(x11GLXGraphicsConfiguration.getFBConfig()) + ", size " + mutableSurface.getSurfaceWidth() + "x" + mutableSurface.getSurfaceHeight() + ", " + x11GLXGraphicsConfiguration.getChosenCapabilities());
        }
        mutableSurface.setSurfaceHandle(l3);
        if (DEBUG) {
            System.err.println(X11PbufferGLXDrawable.getThreadName() + ": Created pbuffer " + this);
        }
    }
}

