/*
 * Decompiled with CFR 0.152.
 */
package jogamp.opengl.x11.glx;

import com.jogamp.common.ExceptionUtils;
import com.jogamp.common.nio.Buffers;
import com.jogamp.common.util.VersionNumber;
import com.jogamp.nativewindow.AbstractGraphicsConfiguration;
import com.jogamp.nativewindow.AbstractGraphicsDevice;
import com.jogamp.nativewindow.AbstractGraphicsScreen;
import com.jogamp.nativewindow.GenericUpstreamSurfacelessHook;
import com.jogamp.nativewindow.NativeSurface;
import com.jogamp.nativewindow.ProxySurface;
import com.jogamp.nativewindow.UpstreamSurfaceHook;
import com.jogamp.nativewindow.x11.X11GraphicsDevice;
import com.jogamp.nativewindow.x11.X11GraphicsScreen;
import com.jogamp.opengl.GLCapabilities;
import com.jogamp.opengl.GLCapabilitiesChooser;
import com.jogamp.opengl.GLCapabilitiesImmutable;
import com.jogamp.opengl.GLContext;
import com.jogamp.opengl.GLDrawable;
import com.jogamp.opengl.GLException;
import com.jogamp.opengl.GLProfile;
import com.jogamp.opengl.GLRendererQuirks;
import java.nio.Buffer;
import java.nio.ShortBuffer;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.List;
import jogamp.nativewindow.WrappedSurface;
import jogamp.nativewindow.x11.X11DummyUpstreamSurfaceHook;
import jogamp.nativewindow.x11.X11Lib;
import jogamp.nativewindow.x11.X11Util;
import jogamp.opengl.DesktopGLDynamicLookupHelper;
import jogamp.opengl.GLContextImpl;
import jogamp.opengl.GLDrawableFactoryImpl;
import jogamp.opengl.GLDrawableImpl;
import jogamp.opengl.GLDynamicLookupHelper;
import jogamp.opengl.GLGraphicsConfigurationUtil;
import jogamp.opengl.SharedResourceRunner;
import jogamp.opengl.x11.glx.GLX;
import jogamp.opengl.x11.glx.GLXUtil;
import jogamp.opengl.x11.glx.X11ExternalGLXContext;
import jogamp.opengl.x11.glx.X11ExternalGLXDrawable;
import jogamp.opengl.x11.glx.X11GLCapabilities;
import jogamp.opengl.x11.glx.X11GLXDynamicLibraryBundleInfo;
import jogamp.opengl.x11.glx.X11GLXGraphicsConfiguration;
import jogamp.opengl.x11.glx.X11GLXGraphicsConfigurationFactory;
import jogamp.opengl.x11.glx.X11OnscreenGLXDrawable;
import jogamp.opengl.x11.glx.X11PbufferGLXDrawable;
import jogamp.opengl.x11.glx.X11PixmapGLXDrawable;

public class X11GLXDrawableFactory
extends GLDrawableFactoryImpl {
    private static final boolean DEBUG_SHAREDCTX = DEBUG || GLContext.DEBUG;
    public static final VersionNumber versionOneZero = new VersionNumber(1, 0, 0);
    public static final VersionNumber versionOneOne = new VersionNumber(1, 1, 0);
    public static final VersionNumber versionOneTwo = new VersionNumber(1, 2, 0);
    public static final VersionNumber versionOneThree = new VersionNumber(1, 3, 0);
    public static final VersionNumber versionOneFour = new VersionNumber(1, 4, 0);
    static final String GLX_SGIX_pbuffer = "GLX_SGIX_pbuffer";
    private static DesktopGLDynamicLookupHelper x11GLXDynamicLookupHelper = null;
    private X11GraphicsDevice defaultDevice;
    private SharedResourceImplementation sharedResourceImplementation;
    private SharedResourceRunner sharedResourceRunner;
    private boolean gotGammaRampLength;
    private int gammaRampLength;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public X11GLXDrawableFactory() {
        Class<X11GLXDrawableFactory> clazz = X11GLXDrawableFactory.class;
        synchronized (X11GLXDrawableFactory.class) {
            if (null == x11GLXDynamicLookupHelper) {
                x11GLXDynamicLookupHelper = AccessController.doPrivileged(new PrivilegedAction<DesktopGLDynamicLookupHelper>(){

                    @Override
                    public DesktopGLDynamicLookupHelper run() {
                        DesktopGLDynamicLookupHelper desktopGLDynamicLookupHelper;
                        block3: {
                            try {
                                desktopGLDynamicLookupHelper = new DesktopGLDynamicLookupHelper(new X11GLXDynamicLibraryBundleInfo());
                                if (null != desktopGLDynamicLookupHelper && desktopGLDynamicLookupHelper.isLibComplete()) {
                                    GLX.getGLXProcAddressTable().reset(desktopGLDynamicLookupHelper);
                                }
                            }
                            catch (Exception exception) {
                                desktopGLDynamicLookupHelper = null;
                                if (!DEBUG) break block3;
                                exception.printStackTrace();
                            }
                        }
                        return desktopGLDynamicLookupHelper;
                    }
                });
            }
            // ** MonitorExit[var1_1] (shouldn't be in output)
            this.defaultDevice = new X11GraphicsDevice(X11Util.getNullDisplayName(), 0);
            if (null != x11GLXDynamicLookupHelper) {
                X11GLXGraphicsConfigurationFactory.registerFactory();
                this.sharedResourceImplementation = new SharedResourceImplementation();
                this.sharedResourceRunner = new SharedResourceRunner(this.sharedResourceImplementation);
                this.sharedResourceRunner.start();
            }
            return;
        }
    }

    @Override
    protected final boolean isComplete() {
        return null != x11GLXDynamicLookupHelper;
    }

    @Override
    protected final void shutdownImpl() {
        if (DEBUG) {
            System.err.println("X11GLXDrawableFactory.shutdown");
        }
        if (null != this.sharedResourceRunner) {
            this.sharedResourceRunner.stop();
            this.sharedResourceRunner = null;
        }
        if (null != this.sharedResourceImplementation) {
            this.sharedResourceImplementation.clear();
            this.sharedResourceImplementation = null;
        }
        this.defaultDevice = null;
        x11GLXDynamicLookupHelper = null;
    }

    @Override
    public final GLDynamicLookupHelper getGLDynamicLookupHelper(int n2, int n3) {
        return x11GLXDynamicLookupHelper;
    }

    @Override
    public final AbstractGraphicsDevice getDefaultDevice() {
        return this.defaultDevice;
    }

    @Override
    public final boolean getIsDeviceCompatible(AbstractGraphicsDevice abstractGraphicsDevice) {
        return null != x11GLXDynamicLookupHelper && abstractGraphicsDevice instanceof X11GraphicsDevice;
    }

    @Override
    protected final Thread getSharedResourceThread() {
        return this.sharedResourceRunner.start();
    }

    @Override
    protected final SharedResource getOrCreateSharedResourceImpl(AbstractGraphicsDevice abstractGraphicsDevice) {
        return (SharedResource)this.sharedResourceRunner.getOrCreateShared(abstractGraphicsDevice);
    }

    protected final long getOrCreateSharedDpy(AbstractGraphicsDevice abstractGraphicsDevice) {
        SharedResourceRunner.Resource resource = this.getOrCreateSharedResource(abstractGraphicsDevice);
        if (null != resource) {
            return resource.getDevice().getHandle();
        }
        return 0L;
    }

    @Override
    public final boolean hasOpenGLDesktopSupport() {
        return true;
    }

    @Override
    public final boolean hasOpenGLESSupport() {
        return false;
    }

    @Override
    public final boolean hasMajorMinorCreateContextARB() {
        return true;
    }

    @Override
    protected List<GLCapabilitiesImmutable> getAvailableCapabilitiesImpl(AbstractGraphicsDevice abstractGraphicsDevice) {
        return X11GLXGraphicsConfigurationFactory.getAvailableCapabilities(this, abstractGraphicsDevice);
    }

    @Override
    protected final GLDrawableImpl createOnscreenDrawableImpl(NativeSurface nativeSurface) {
        if (nativeSurface == null) {
            throw new IllegalArgumentException("Null target");
        }
        return new X11OnscreenGLXDrawable(this, nativeSurface, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected final GLDrawableImpl createOffscreenDrawableImpl(NativeSurface nativeSurface) {
        X11PbufferGLXDrawable x11PbufferGLXDrawable;
        if (nativeSurface == null) {
            throw new IllegalArgumentException("Null target");
        }
        AbstractGraphicsConfiguration abstractGraphicsConfiguration = nativeSurface.getGraphicsConfiguration();
        GLCapabilitiesImmutable gLCapabilitiesImmutable = (GLCapabilitiesImmutable)abstractGraphicsConfiguration.getChosenCapabilities();
        if (!gLCapabilitiesImmutable.isPBuffer()) {
            return new X11PixmapGLXDrawable(this, nativeSurface);
        }
        AbstractGraphicsDevice abstractGraphicsDevice = abstractGraphicsConfiguration.getScreen().getDevice();
        SharedResource sharedResource = (SharedResource)this.sharedResourceRunner.getOrCreateShared(abstractGraphicsDevice);
        if (null != sharedResource && sharedResource.isGLXVendorATI() && null == GLContext.getCurrent()) {
            sharedResource.getContext().makeCurrent();
            try {
                x11PbufferGLXDrawable = new X11PbufferGLXDrawable(this, nativeSurface);
            }
            finally {
                sharedResource.getContext().release();
            }
        } else {
            x11PbufferGLXDrawable = new X11PbufferGLXDrawable(this, nativeSurface);
        }
        return x11PbufferGLXDrawable;
    }

    public final boolean isGLXMultisampleAvailable(AbstractGraphicsDevice abstractGraphicsDevice) {
        SharedResource sharedResource;
        if (null != abstractGraphicsDevice && null != (sharedResource = (SharedResource)this.sharedResourceRunner.getOrCreateShared(abstractGraphicsDevice))) {
            return sharedResource.isGLXMultisampleAvailable();
        }
        return false;
    }

    public final VersionNumber getGLXVersionNumber(AbstractGraphicsDevice abstractGraphicsDevice) {
        if (null != abstractGraphicsDevice) {
            SharedResource sharedResource = (SharedResource)this.sharedResourceRunner.getOrCreateShared(abstractGraphicsDevice);
            if (null != sharedResource) {
                return sharedResource.getGLXVersion();
            }
            if (abstractGraphicsDevice instanceof X11GraphicsDevice) {
                return GLXUtil.getGLXServerVersionNumber((X11GraphicsDevice)abstractGraphicsDevice);
            }
        }
        return null;
    }

    public final boolean isGLXVersionGreaterEqualOneOne(AbstractGraphicsDevice abstractGraphicsDevice) {
        if (null != abstractGraphicsDevice) {
            SharedResource sharedResource = (SharedResource)this.sharedResourceRunner.getOrCreateShared(abstractGraphicsDevice);
            if (null != sharedResource) {
                return sharedResource.isGLXVersionGreaterEqualOneOne();
            }
            if (abstractGraphicsDevice instanceof X11GraphicsDevice) {
                VersionNumber versionNumber = GLXUtil.getGLXServerVersionNumber((X11GraphicsDevice)abstractGraphicsDevice);
                return versionNumber.compareTo(versionOneOne) >= 0;
            }
        }
        return false;
    }

    public final boolean isGLXVersionGreaterEqualOneThree(AbstractGraphicsDevice abstractGraphicsDevice) {
        if (null != abstractGraphicsDevice) {
            SharedResource sharedResource = (SharedResource)this.sharedResourceRunner.getOrCreateShared(abstractGraphicsDevice);
            if (null != sharedResource) {
                return sharedResource.isGLXVersionGreaterEqualOneThree();
            }
            if (abstractGraphicsDevice instanceof X11GraphicsDevice) {
                VersionNumber versionNumber = GLXUtil.getGLXServerVersionNumber((X11GraphicsDevice)abstractGraphicsDevice);
                return versionNumber.compareTo(versionOneThree) >= 0;
            }
        }
        return false;
    }

    @Override
    public final boolean canCreateGLPbuffer(AbstractGraphicsDevice abstractGraphicsDevice, GLProfile gLProfile) {
        SharedResourceRunner.Resource resource;
        if (null == abstractGraphicsDevice && null != (resource = this.sharedResourceRunner.getOrCreateShared(this.defaultDevice))) {
            abstractGraphicsDevice = resource.getDevice();
        }
        return this.isGLXVersionGreaterEqualOneThree(abstractGraphicsDevice);
    }

    @Override
    protected final ProxySurface createMutableSurfaceImpl(AbstractGraphicsDevice abstractGraphicsDevice, boolean bl, GLCapabilitiesImmutable gLCapabilitiesImmutable, GLCapabilitiesImmutable gLCapabilitiesImmutable2, GLCapabilitiesChooser gLCapabilitiesChooser, UpstreamSurfaceHook upstreamSurfaceHook) {
        X11GraphicsDevice x11GraphicsDevice = bl || !(abstractGraphicsDevice instanceof X11GraphicsDevice) ? new X11GraphicsDevice(X11Util.openDisplay(abstractGraphicsDevice.getConnection()), abstractGraphicsDevice.getUnitID(), true) : (X11GraphicsDevice)abstractGraphicsDevice;
        X11GraphicsScreen x11GraphicsScreen = new X11GraphicsScreen(x11GraphicsDevice, x11GraphicsDevice.getDefaultScreen());
        X11GLXGraphicsConfiguration x11GLXGraphicsConfiguration = X11GLXGraphicsConfigurationFactory.chooseGraphicsConfigurationStatic(gLCapabilitiesImmutable, gLCapabilitiesImmutable2, gLCapabilitiesChooser, x11GraphicsScreen, 0);
        if (null == x11GLXGraphicsConfiguration) {
            throw new GLException("Choosing GraphicsConfiguration failed w/ " + gLCapabilitiesImmutable + " on " + x11GraphicsScreen);
        }
        return new WrappedSurface(x11GLXGraphicsConfiguration, 0L, upstreamSurfaceHook, bl);
    }

    @Override
    public final ProxySurface createDummySurfaceImpl(AbstractGraphicsDevice abstractGraphicsDevice, boolean bl, GLCapabilitiesImmutable gLCapabilitiesImmutable, GLCapabilitiesImmutable gLCapabilitiesImmutable2, GLCapabilitiesChooser gLCapabilitiesChooser, int n2, int n3) {
        gLCapabilitiesImmutable = GLGraphicsConfigurationUtil.fixOnscreenGLCapabilities(gLCapabilitiesImmutable);
        return this.createMutableSurfaceImpl(abstractGraphicsDevice, bl, gLCapabilitiesImmutable, gLCapabilitiesImmutable2, gLCapabilitiesChooser, new X11DummyUpstreamSurfaceHook(n2, n3));
    }

    @Override
    public final ProxySurface createSurfacelessImpl(AbstractGraphicsDevice abstractGraphicsDevice, boolean bl, GLCapabilitiesImmutable gLCapabilitiesImmutable, GLCapabilitiesImmutable gLCapabilitiesImmutable2, GLCapabilitiesChooser gLCapabilitiesChooser, int n2, int n3) {
        gLCapabilitiesImmutable = GLGraphicsConfigurationUtil.fixOnscreenGLCapabilities(gLCapabilitiesImmutable);
        return this.createMutableSurfaceImpl(abstractGraphicsDevice, bl, gLCapabilitiesImmutable, gLCapabilitiesImmutable2, gLCapabilitiesChooser, new GenericUpstreamSurfacelessHook(n2, n3));
    }

    @Override
    protected final ProxySurface createProxySurfaceImpl(AbstractGraphicsDevice abstractGraphicsDevice, int n2, long l2, GLCapabilitiesImmutable gLCapabilitiesImmutable, GLCapabilitiesChooser gLCapabilitiesChooser, UpstreamSurfaceHook upstreamSurfaceHook) {
        X11GraphicsDevice x11GraphicsDevice = new X11GraphicsDevice(X11Util.openDisplay(abstractGraphicsDevice.getConnection()), abstractGraphicsDevice.getUnitID(), true);
        X11GraphicsScreen x11GraphicsScreen = new X11GraphicsScreen(x11GraphicsDevice, n2);
        int n3 = X11Lib.GetVisualIDFromWindow(x11GraphicsDevice.getHandle(), l2);
        if (0 == n3) {
            throw new GLException("Undefined VisualID of window 0x" + Long.toHexString(l2) + ", window probably invalid");
        }
        if (DEBUG) {
            System.err.println("X11GLXDrawableFactory.createProxySurfaceImpl 0x" + Long.toHexString(l2) + ": visualID 0x" + Integer.toHexString(n3));
        }
        X11GLXGraphicsConfiguration x11GLXGraphicsConfiguration = X11GLXGraphicsConfigurationFactory.chooseGraphicsConfigurationStatic(gLCapabilitiesImmutable, gLCapabilitiesImmutable, gLCapabilitiesChooser, x11GraphicsScreen, n3);
        if (DEBUG) {
            System.err.println("X11GLXDrawableFactory.createProxySurfaceImpl 0x" + Long.toHexString(l2) + ": " + x11GLXGraphicsConfiguration);
        }
        return new WrappedSurface(x11GLXGraphicsConfiguration, l2, upstreamSurfaceHook, true);
    }

    @Override
    protected final GLContext createExternalGLContextImpl() {
        return X11ExternalGLXContext.create(this, null);
    }

    @Override
    public final boolean canCreateExternalGLDrawable(AbstractGraphicsDevice abstractGraphicsDevice) {
        return this.canCreateGLPbuffer(abstractGraphicsDevice, null);
    }

    @Override
    protected final GLDrawable createExternalGLDrawableImpl() {
        return X11ExternalGLXDrawable.create(this, null);
    }

    @Override
    protected final synchronized int getGammaRampLength(NativeSurface nativeSurface) {
        int[] nArray;
        if (this.gotGammaRampLength) {
            return this.gammaRampLength;
        }
        long l2 = nativeSurface.getDisplayHandle();
        if (0L == l2) {
            return 0;
        }
        int n2 = nativeSurface.getScreenIndex();
        boolean bl = X11Lib.XF86VidModeGetGammaRampSize(l2, n2, nArray = new int[1], 0);
        if (!bl) {
            return 0;
        }
        this.gotGammaRampLength = true;
        this.gammaRampLength = nArray[0];
        System.err.println("XXX: Gamma ramp size: " + this.gammaRampLength);
        return this.gammaRampLength;
    }

    @Override
    protected final boolean setGammaRamp(NativeSurface nativeSurface, float[] fArray) {
        int n2;
        long l2 = nativeSurface.getDisplayHandle();
        if (0L == l2) {
            return false;
        }
        int n3 = nativeSurface.getScreenIndex();
        int n4 = fArray.length;
        short[] sArray = new short[n4];
        for (n2 = 0; n2 < n4; n2 += 1) {
            sArray[n2] = (short)(fArray[n2] * 65535.0f);
        }
        n2 = X11Lib.XF86VidModeSetGammaRamp(l2, n3, sArray.length, sArray, 0, sArray, 0, sArray, 0) ? 1 : 0;
        if (DEBUG) {
            X11GLXDrawableFactory.dumpRamp("SET__", sArray.length, sArray, sArray, sArray);
        }
        return n2 != 0;
    }

    private static void dumpRamp(String string, int n2, ShortBuffer shortBuffer, ShortBuffer shortBuffer2, ShortBuffer shortBuffer3) {
        for (int i2 = 0; i2 < n2; ++i2) {
            if (0 == i2 % 4) {
                System.err.printf("%n%4d/%4d %s: ", i2, n2, string);
            }
            System.err.printf(" [%04X %04X %04X], ", shortBuffer.get(i2), shortBuffer2.get(i2), shortBuffer3.get(i2));
        }
        System.err.println();
    }

    private static void dumpRamp(String string, int n2, short[] sArray, short[] sArray2, short[] sArray3) {
        for (int i2 = 0; i2 < n2; ++i2) {
            if (0 == i2 % 4) {
                System.err.printf("%n%4d/%4d %s: ", i2, n2, string);
            }
            System.err.printf(" [%04X %04X %04X], ", sArray[i2], sArray2[i2], sArray3[i2]);
        }
        System.err.println();
    }

    @Override
    protected final Buffer getGammaRamp(NativeSurface nativeSurface) {
        ShortBuffer shortBuffer;
        ShortBuffer shortBuffer2;
        ShortBuffer shortBuffer3;
        ShortBuffer shortBuffer4;
        int n2;
        long l2 = nativeSurface.getDisplayHandle();
        if (0L == l2) {
            return null;
        }
        int n3 = nativeSurface.getScreenIndex();
        boolean bl = X11Lib.XF86VidModeGetGammaRamp(l2, n3, n2 = this.getGammaRampLength(nativeSurface), shortBuffer4 = Buffers.slice(shortBuffer3 = Buffers.newDirectShortBuffer(3 * n2), 0 * n2, n2), shortBuffer2 = Buffers.slice(shortBuffer3, 1 * n2, n2), shortBuffer = Buffers.slice(shortBuffer3, 2 * n2, n2));
        if (!bl) {
            return null;
        }
        if (DEBUG) {
            X11GLXDrawableFactory.dumpRamp("GET__", n2, shortBuffer4, shortBuffer2, shortBuffer);
        }
        return shortBuffer3;
    }

    @Override
    protected final void resetGammaRamp(NativeSurface nativeSurface, Buffer buffer) {
        if (buffer == null) {
            return;
        }
        long l2 = nativeSurface.getDisplayHandle();
        if (0L == l2) {
            return;
        }
        int n2 = nativeSurface.getScreenIndex();
        X11GLXDrawableFactory.resetGammaRamp(l2, n2, buffer);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected final void resetGammaRamp(GLDrawableFactoryImpl.DeviceScreenID deviceScreenID, Buffer buffer) {
        if (buffer == null) {
            return;
        }
        long l2 = X11Util.openDisplay(deviceScreenID.deviceConnection);
        if (0L == l2) {
            return;
        }
        try {
            X11GLXDrawableFactory.resetGammaRamp(l2, deviceScreenID.screenIdx, buffer);
        }
        finally {
            X11Util.closeDisplay(l2);
        }
    }

    private static final void resetGammaRamp(long l2, int n2, Buffer buffer) {
        ShortBuffer shortBuffer = (ShortBuffer)buffer;
        int n3 = shortBuffer.capacity();
        if (n3 % 3 != 0) {
            throw new IllegalArgumentException("Must not be the original gamma ramp");
        }
        int n4 = n3 / 3;
        ShortBuffer shortBuffer2 = Buffers.slice(shortBuffer, 0 * n4, n4);
        ShortBuffer shortBuffer3 = Buffers.slice(shortBuffer, 1 * n4, n4);
        ShortBuffer shortBuffer4 = Buffers.slice(shortBuffer, 2 * n4, n4);
        if (DEBUG) {
            X11GLXDrawableFactory.dumpRamp("RESET", n4, shortBuffer2, shortBuffer3, shortBuffer4);
        }
        X11Lib.XF86VidModeSetGammaRamp(l2, n2, n4, shortBuffer2, shortBuffer3, shortBuffer4);
    }

    class SharedResourceImplementation
    extends SharedResourceRunner.AImplementation {
        SharedResourceImplementation() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public boolean isDeviceSupported(AbstractGraphicsDevice abstractGraphicsDevice) {
            boolean bl;
            X11GraphicsDevice x11GraphicsDevice = new X11GraphicsDevice(X11Util.openDisplay(abstractGraphicsDevice.getConnection()), abstractGraphicsDevice.getUnitID(), true);
            x11GraphicsDevice.lock();
            try {
                bl = GLXUtil.isGLXAvailableOnServer(x11GraphicsDevice);
            }
            finally {
                x11GraphicsDevice.unlock();
                x11GraphicsDevice.close();
            }
            if (DEBUG) {
                System.err.println("GLX " + (bl ? "is" : "not") + " available on device/server: " + x11GraphicsDevice);
            }
            return bl;
        }

        @Override
        public SharedResourceRunner.Resource createSharedResource(AbstractGraphicsDevice abstractGraphicsDevice) {
            X11GraphicsDevice x11GraphicsDevice = new X11GraphicsDevice(X11Util.openDisplay(abstractGraphicsDevice.getConnection()), abstractGraphicsDevice.getUnitID(), true);
            GLContextImpl gLContextImpl = null;
            boolean bl = false;
            x11GraphicsDevice.lock();
            try {
                boolean bl2;
                X11GraphicsScreen x11GraphicsScreen = new X11GraphicsScreen(x11GraphicsDevice, x11GraphicsDevice.getDefaultScreen());
                GLXUtil.initGLXClientDataSingleton(x11GraphicsDevice);
                String string = GLX.glXQueryServerString(x11GraphicsDevice.getHandle(), 0, 1);
                boolean bl3 = GLXUtil.isMultisampleAvailable(GLX.glXQueryServerString(x11GraphicsDevice.getHandle(), 0, 3));
                GLProfile gLProfile = GLProfile.get(x11GraphicsDevice, GLProfile.GL_PROFILE_LIST_MIN_DESKTOP, false);
                if (null == gLProfile) {
                    throw new GLException("Couldn't get default GLProfile for device: " + x11GraphicsDevice);
                }
                GLCapabilities gLCapabilities = new GLCapabilities(gLProfile);
                GLDrawableImpl gLDrawableImpl = X11GLXDrawableFactory.this.createOnscreenDrawableImpl(X11GLXDrawableFactory.this.createDummySurfaceImpl(x11GraphicsDevice, false, gLCapabilities, gLCapabilities, null, 64, 64));
                gLDrawableImpl.setRealized(true);
                X11GLCapabilities x11GLCapabilities = (X11GLCapabilities)gLDrawableImpl.getChosenGLCapabilities();
                boolean bl4 = !x11GLCapabilities.hasFBConfig();
                VersionNumber versionNumber = bl4 ? versionOneOne : GLXUtil.getGLXServerVersionNumber(x11GraphicsDevice);
                gLContextImpl = (GLContextImpl)gLDrawableImpl.createContext(null);
                if (null == gLContextImpl) {
                    throw new GLException("Couldn't create shared context for drawable: " + gLDrawableImpl);
                }
                boolean bl5 = bl = 0 != gLContextImpl.makeCurrent();
                if (bl && gLContextImpl.getGLVersionNumber().compareTo(GLContext.Version3_0) >= 0) {
                    bl2 = X11GLXDrawableFactory.this.probeSurfacelessCtx(gLContextImpl, true);
                } else {
                    X11GLXDrawableFactory.this.setNoSurfacelessCtxQuirk(gLContextImpl);
                    bl2 = false;
                }
                if (gLContextImpl.hasRendererQuirk(8)) {
                    X11Util.markAllDisplaysUnclosable();
                }
                if (DEBUG_SHAREDCTX) {
                    System.err.println("SharedDevice:  " + x11GraphicsDevice);
                    System.err.println("SharedScreen:  " + x11GraphicsScreen);
                    System.err.println("SharedContext: " + gLContextImpl + ", madeCurrent " + bl);
                    System.err.println("  allowsSurfacelessCtx " + bl2);
                    System.err.println("GLX Server Vendor:      " + string);
                    System.err.println("GLX Server Version:     " + versionNumber + ", forced " + bl4);
                    System.err.println("GLX Server Multisample: " + bl3);
                    System.err.println("GLX Client Vendor:      " + GLXUtil.getClientVendorName());
                    System.err.println("GLX Client Version:     " + GLXUtil.getClientVersionNumber());
                    System.err.println("GLX Client Multisample: " + GLXUtil.isClientMultisampleAvailable());
                }
                SharedResource sharedResource = new SharedResource(x11GraphicsDevice, x11GraphicsScreen, gLDrawableImpl, gLContextImpl, versionNumber, string, bl3 && GLXUtil.isClientMultisampleAvailable());
                return sharedResource;
            }
            catch (Throwable throwable) {
                throw new GLException("X11GLXDrawableFactory - Could not initialize shared resources for " + abstractGraphicsDevice, throwable);
            }
            finally {
                if (bl) {
                    gLContextImpl.release();
                }
                x11GraphicsDevice.unlock();
            }
        }

        @Override
        public void releaseSharedResource(SharedResourceRunner.Resource resource) {
            SharedResource sharedResource = (SharedResource)resource;
            if (DEBUG_SHAREDCTX) {
                System.err.println("Shutdown Shared:");
                System.err.println("Device  : " + sharedResource.device);
                System.err.println("Screen  : " + sharedResource.screen);
                System.err.println("Drawable: " + sharedResource.drawable);
                System.err.println("CTX     : " + sharedResource.context);
                ExceptionUtils.dumpStack(System.err);
            }
            if (null != sharedResource.context) {
                sharedResource.context.destroy();
                sharedResource.context = null;
            }
            if (null != sharedResource.drawable) {
                sharedResource.drawable.setRealized(false);
                sharedResource.drawable = null;
            }
            if (null != sharedResource.screen) {
                sharedResource.screen = null;
            }
            if (null != sharedResource.device) {
                sharedResource.device.close();
                sharedResource.device = null;
            }
        }
    }

    static class SharedResource
    implements SharedResourceRunner.Resource {
        private final String glXServerVendorName;
        private final boolean isGLXServerVendorATI;
        private final boolean isGLXServerVendorNVIDIA;
        private final VersionNumber glXServerVersion;
        private final boolean glXServerVersionOneOneCapable;
        private final boolean glXServerVersionOneThreeCapable;
        private final boolean glXMultisampleAvailable;
        X11GraphicsDevice device;
        X11GraphicsScreen screen;
        GLDrawableImpl drawable;
        GLContextImpl context;

        SharedResource(X11GraphicsDevice x11GraphicsDevice, X11GraphicsScreen x11GraphicsScreen, GLDrawableImpl gLDrawableImpl, GLContextImpl gLContextImpl, VersionNumber versionNumber, String string, boolean bl) {
            this.device = x11GraphicsDevice;
            this.screen = x11GraphicsScreen;
            this.drawable = gLDrawableImpl;
            this.context = gLContextImpl;
            this.glXServerVersion = versionNumber;
            this.glXServerVersionOneOneCapable = this.glXServerVersion.compareTo(versionOneOne) >= 0;
            this.glXServerVersionOneThreeCapable = this.glXServerVersion.compareTo(versionOneThree) >= 0;
            this.glXServerVendorName = string;
            this.isGLXServerVendorATI = GLXUtil.isVendorATI(this.glXServerVendorName);
            this.isGLXServerVendorNVIDIA = GLXUtil.isVendorNVIDIA(this.glXServerVendorName);
            this.glXMultisampleAvailable = bl;
        }

        @Override
        public final boolean isAvailable() {
            return null != this.context;
        }

        @Override
        public final AbstractGraphicsDevice getDevice() {
            return this.device;
        }

        @Override
        public final AbstractGraphicsScreen getScreen() {
            return this.screen;
        }

        @Override
        public final GLDrawableImpl getDrawable() {
            return this.drawable;
        }

        @Override
        public final GLContextImpl getContext() {
            return this.context;
        }

        @Override
        public GLRendererQuirks getRendererQuirks(GLProfile gLProfile) {
            return null != this.context ? this.context.getRendererQuirks() : null;
        }

        final String getGLXVendorName() {
            return this.glXServerVendorName;
        }

        final boolean isGLXVendorATI() {
            return this.isGLXServerVendorATI;
        }

        final boolean isGLXVendorNVIDIA() {
            return this.isGLXServerVendorNVIDIA;
        }

        final VersionNumber getGLXVersion() {
            return this.glXServerVersion;
        }

        final boolean isGLXVersionGreaterEqualOneOne() {
            return this.glXServerVersionOneOneCapable;
        }

        final boolean isGLXVersionGreaterEqualOneThree() {
            return this.glXServerVersionOneThreeCapable;
        }

        final boolean isGLXMultisampleAvailable() {
            return this.glXMultisampleAvailable;
        }
    }
}

